/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMerger;
import com.android.ide.common.resources.ResourceRepositories;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;

public final class TestResourceRepository
extends AbstractResourceRepository
implements SingleNamespaceResourceRepository {
    private final ResourceNamespace namespace;
    private final ResourceTable resourceTable = new ResourceTable();

    public TestResourceRepository(ResourceNamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public ResourceTable getFullTable() {
        return this.resourceTable;
    }

    @Override
    protected ListMultimap<String, ResourceItem> getMap(ResourceNamespace namespace, ResourceType type, boolean create) {
        ListMultimap multimap = (ListMultimap)this.resourceTable.get(namespace, type);
        if (multimap == null && create) {
            multimap = ArrayListMultimap.create();
            this.resourceTable.put(namespace, type, multimap);
        }
        return multimap;
    }

    @Override
    public ResourceNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public String getPackageName() {
        return this.namespace.getPackageName();
    }

    public void update(ResourceMerger merger) {
        ResourceRepositories.updateTableFromMerger(merger, this.resourceTable);
    }
}

