/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolJavaType;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class SymbolIo {
    public static final String ANDROID_ATTR_PREFIX = "android_";

    private SymbolIo() {
    }

    public static SymbolTable readFromAapt(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, ReadConfiguration.AAPT);
    }

    public static SymbolTable readFromAaptNoValues(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, ReadConfiguration.AAPT_NO_VALUES);
    }

    public static SymbolTable readFromPartialRFile(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, ReadConfiguration.PARTIAL_FILE);
    }

    public static SymbolTable readFromPublicTxtFile(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, ReadConfiguration.PUBLIC_FILE);
    }

    private static SymbolTable read(File file, String tablePackage, ReadConfiguration readConfiguration) throws IOException {
        SymbolTable.Builder table;
        try (Stream<String> lines = Files.lines(file.toPath(), Charsets.UTF_8);){
            Iterator<String> linesIterator = lines.iterator();
            int startLine = SymbolIo.checkFileTypeHeader(linesIterator, readConfiguration, file.toPath());
            table = new SymbolLineReader(readConfiguration, linesIterator, file.toPath(), startLine).readLines();
        }
        if (tablePackage != null) {
            table.tablePackage(tablePackage);
        }
        return table.build();
    }

    public static SymbolTable readSymbolListWithPackageName(Path file) throws IOException {
        return SymbolIo.readWithPackage(file, ReadConfiguration.SYMBOL_LIST_WITH_PACKAGE);
    }

    public static SymbolTable readRDef(Path file) throws IOException {
        return SymbolIo.readWithPackage(file, ReadConfiguration.R_DEF);
    }

    private static SymbolTable readWithPackage(Path file, ReadConfiguration readConfiguration) throws IOException {
        SymbolTable.Builder table;
        String tablePackage;
        try (Stream<String> lines = Files.lines(file, Charsets.UTF_8);){
            Iterator<String> linesIterator = lines.iterator();
            int startLine = SymbolIo.checkFileTypeHeader(linesIterator, readConfiguration, file);
            if (!linesIterator.hasNext()) {
                throw new IOException("Internal error: Symbol file with package cannot be empty. File located at: " + file);
            }
            tablePackage = linesIterator.next().trim();
            table = new SymbolLineReader(readConfiguration, linesIterator, file, startLine + 1).readLines();
        }
        table.tablePackage(tablePackage);
        return table.build();
    }

    private static int checkFileTypeHeader(Iterator<String> lines, ReadConfiguration readConfiguration, Path path) throws IOException {
        if (readConfiguration.fileTypeHeader == null) {
            return 1;
        }
        if (!lines.hasNext()) {
            throw new IOException("Internal Error: Invalid symbol file '" + path + "', cannot be empty for type '" + (Object)((Object)readConfiguration) + "'");
        }
        String firstLine = lines.next();
        if (!lines.hasNext() || !readConfiguration.fileTypeHeader.equals(firstLine)) {
            throw new IOException("Internal Error: Invalid symbol file '" + path + "', first line is incorrect for type '" + (Object)((Object)readConfiguration) + "'.\n Expected '" + readConfiguration.fileTypeHeader + "' but got '" + firstLine + "'");
        }
        return 2;
    }

    private static SymbolData readAaptLine(String line) throws IOException {
        int pos = line.indexOf(32);
        String typeName = line.substring(0, pos);
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        if (type == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        int pos2 = line.indexOf(32, pos + 1);
        String className = line.substring(pos + 1, pos2);
        ResourceType resourceType = ResourceType.fromClassName((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        int pos3 = line.indexOf(32, pos2 + 1);
        String name = line.substring(pos2 + 1, pos3);
        String value = line.substring(pos3 + 1).trim();
        return new SymbolData(resourceType, name, type, value);
    }

    private static SymbolData readPartialRLine(String line) throws IOException {
        int pos = line.indexOf(32);
        String accessName = line.substring(0, pos);
        ResourceVisibility accessibility = ResourceVisibility.getEnum((String)accessName);
        if (accessibility == null) {
            throw new IOException("Invalid resource access qualifier " + accessName);
        }
        int pos2 = line.indexOf(32, pos + 1);
        String typeName = line.substring(pos + 1, pos2);
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        if (type == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        int pos3 = line.indexOf(32, pos2 + 1);
        String className = line.substring(pos2 + 1, pos3);
        ResourceType resourceType = ResourceType.fromClassName((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        String name = line.substring(pos3 + 1);
        return new SymbolData(accessibility, resourceType, name, type, "");
    }

    private static SymbolData readPublicTxtLine(String line) throws IOException {
        int pos = line.indexOf(32);
        String className = line.substring(0, pos);
        ResourceType resourceType = ResourceType.fromClassName((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        String typeName = resourceType == ResourceType.STYLEABLE ? "int[]" : "int";
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        if (type == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        String name = line.substring(pos + 1);
        return new SymbolData(ResourceVisibility.PUBLIC, resourceType, name, type, "");
    }

    private static SymbolData readSymbolListWithPackageLine(String line) throws IOException {
        ResourceType resourceType;
        int startPos = line.indexOf(32);
        boolean maybeDefinition = false;
        String typeName = line.substring(0, startPos);
        if (typeName.equals("attr?")) {
            maybeDefinition = true;
            resourceType = ResourceType.ATTR;
        } else {
            resourceType = ResourceType.fromClassName((String)typeName);
        }
        if (resourceType == null) {
            throw new IOException("Invalid symbol type " + typeName);
        }
        int endPos = line.indexOf(32, startPos + 1);
        if (resourceType == ResourceType.STYLEABLE && endPos > 0) {
            String name = line.substring(startPos + 1, endPos);
            startPos = endPos + 1;
            ImmutableList.Builder children = ImmutableList.builder();
            while (true) {
                if ((endPos = line.indexOf(32, startPos)) == -1) break;
                children.add((Object)line.substring(startPos, endPos));
                startPos = endPos + 1;
            }
            children.add((Object)line.substring(startPos));
            return new SymbolData(name, (ImmutableList<String>)children.build());
        }
        String name = line.substring(startPos + 1);
        if (resourceType == ResourceType.ATTR) {
            return new SymbolData(name, maybeDefinition);
        }
        return new SymbolData(resourceType, name);
    }

    private static String computeItemName(String prefix, String name) {
        String indexName = name.substring(prefix.length());
        if (indexName.startsWith(ANDROID_ATTR_PREFIX)) {
            indexName = "android:" + indexName.substring(ANDROID_ATTR_PREFIX.length());
        }
        return indexName;
    }

    public static void writeForAar(SymbolTable table, File file) throws IOException {
        SymbolIo.writeForAar(table, file.toPath());
    }

    public static void writeForAar(SymbolTable table, Path file) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));
             PrintWriter pw = new PrintWriter(os);){
            for (ResourceType resType : ResourceType.values()) {
                List<Symbol> symbols2 = table.getSymbolByResourceType(resType);
                if (symbols2.isEmpty()) continue;
                for (Symbol s : symbols2) {
                    pw.print(s.getJavaType().getTypeName());
                    pw.print(' ');
                    pw.print(s.getResourceType().getName());
                    pw.print(' ');
                    pw.print(s.getCanonicalName());
                    pw.print(' ');
                    if (s.getResourceType() != ResourceType.STYLEABLE) {
                        pw.print("0x");
                        pw.print(Integer.toHexString(s.getIntValue()));
                        pw.print('\n');
                        continue;
                    }
                    Symbol.StyleableSymbol styleable = (Symbol.StyleableSymbol)s;
                    SymbolIo.writeStyleableValue(styleable, pw);
                    pw.print('\n');
                    ImmutableList<String> children = styleable.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        pw.print(SymbolJavaType.INT.getTypeName());
                        pw.print(' ');
                        pw.print(ResourceType.STYLEABLE.getName());
                        pw.print(' ');
                        pw.print(s.getCanonicalName());
                        pw.print('_');
                        pw.print(SymbolUtils.canonicalizeValueResourceName((String)children.get(i)));
                        pw.print(' ');
                        pw.print(Integer.toString(i));
                        pw.print('\n');
                    }
                }
            }
        }
    }

    private static void writeStyleableValue(Symbol.StyleableSymbol s, PrintWriter pw) {
        pw.print("{ ");
        ImmutableList<Integer> values = s.getValues();
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("0x");
            pw.print(Integer.toHexString((Integer)values.get(i)));
        }
        pw.print(" }");
    }

    public static void writeRDef(SymbolTable table, Path file) throws IOException {
        Preconditions.checkNotNull((Object)ReadConfiguration.R_DEF.fileTypeHeader, (Object)("Missing package for R-def file " + file.toAbsolutePath()));
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            writer.write(ReadConfiguration.R_DEF.fileTypeHeader);
            ((Writer)writer).write(10);
            writer.write(table.getTablePackage());
            ((Writer)writer).write(10);
            for (ResourceType resType : ResourceType.values()) {
                List<Symbol> symbols2 = table.getSymbolByResourceType(resType);
                if (symbols2.isEmpty()) continue;
                for (Symbol s : symbols2) {
                    writer.write(s.getResourceType().getName());
                    if (s.getResourceType() == ResourceType.ATTR && ((Symbol.AttributeSymbol)s).isMaybeDefinition()) {
                        ((Writer)writer).write(63);
                    }
                    ((Writer)writer).write(32);
                    writer.write(s.getName());
                    if (s.getResourceType() == ResourceType.STYLEABLE) {
                        ImmutableList<String> children = s.getChildren();
                        for (String child : children) {
                            ((Writer)writer).write(32);
                            writer.write(child);
                        }
                    }
                    ((Writer)writer).write(10);
                }
            }
        }
    }

    public static void writeSymbolListWithPackageName(Path symbolTable, Path manifest, Path outputFile) throws IOException {
        String packageName;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(manifest, new OpenOption[0]));){
            packageName = AndroidManifestParser.parse(is).getPackage();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Failed to get package name from manifest " + manifest.toAbsolutePath(), e);
        }
        SymbolIo.writeSymbolListWithPackageName(symbolTable, packageName, outputFile);
    }

    public static void writeSymbolListWithPackageName(Path symbolTable, String packageName, Path outputFile) throws IOException {
        try (PrintWriter writer = new PrintWriter(new BufferedOutputStream(Files.newOutputStream(outputFile, new OpenOption[0])));){
            if (packageName != null) {
                ((Writer)writer).write(packageName);
            }
            if (!Files.exists(symbolTable, new LinkOption[0])) {
                ((Writer)writer).write(10);
                return;
            }
            String styleableChildPrefix = null;
            try (Stream<String> lines = Files.lines(symbolTable);){
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    int end;
                    int middle;
                    int start;
                    String line = (String)iterator.next();
                    if (styleableChildPrefix != null && line.startsWith(styleableChildPrefix)) {
                        start = styleableChildPrefix.length() + 1;
                        int end2 = line.indexOf(32, styleableChildPrefix.length());
                        if (end2 == -1) continue;
                        ((Writer)writer).write(32);
                        ((Writer)writer).write(line, start, end2 - start);
                        continue;
                    }
                    if (line.startsWith("int styleable ") || (start = line.indexOf(32) + 1) == 0 || (middle = line.indexOf(32, start) + 1) == 0 || (end = line.indexOf(32, middle) + 1) == 0) continue;
                    ((Writer)writer).write(10);
                    ((Writer)writer).write(line, start, end - start - 1);
                    if (line.startsWith("int[] ")) {
                        styleableChildPrefix = "int styleable " + line.substring(middle, end - 1);
                        continue;
                    }
                    styleableChildPrefix = null;
                }
            }
            ((Writer)writer).write(10);
        }
    }

    public static File exportToJava(SymbolTable table, File directory, boolean finalIds) {
        Preconditions.checkArgument((boolean)directory.isDirectory());
        Splitter splitter = Splitter.on((char)'.');
        Iterable directories = splitter.split((CharSequence)table.getTablePackage());
        File file = directory;
        for (String d : directories) {
            file = new File(file, d);
        }
        FileUtils.mkdirs((File)file);
        file = new File(file, "R.java");
        String idModifiers = finalIds ? "public static final" : "public static";
        try (PrintWriter pw = new PrintWriter(new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])));){
            pw.println("/* AUTO-GENERATED FILE.  DO NOT MODIFY.");
            pw.println(" *");
            pw.println(" * This class was automatically generated by the");
            pw.println(" * gradle plugin from the resource data it found. It");
            pw.println(" * should not be modified by hand.");
            pw.println(" */");
            if (!table.getTablePackage().isEmpty()) {
                pw.print("package ");
                pw.print(table.getTablePackage());
                pw.print(';');
                pw.println();
            }
            pw.println();
            pw.println("public final class R {");
            pw.println("    private R() {}");
            pw.println();
            String typeName = SymbolJavaType.INT.getTypeName();
            for (ResourceType resType : ResourceType.values()) {
                List<Symbol> symbols2 = table.getSymbolByResourceType(resType);
                if (symbols2.isEmpty()) continue;
                pw.print("    public static final class ");
                pw.print(resType.getName());
                pw.print(" {");
                pw.println();
                pw.print("        private ");
                pw.print(resType.getName());
                pw.println("() {}");
                pw.println();
                for (Symbol s : symbols2) {
                    String name = s.getCanonicalName();
                    pw.print("        ");
                    pw.print(idModifiers);
                    pw.print(' ');
                    pw.print(s.getJavaType().getTypeName());
                    pw.print(' ');
                    pw.print(name);
                    pw.print(" = ");
                    if (s.getResourceType() != ResourceType.STYLEABLE) {
                        pw.print("0x");
                        pw.print(Integer.toHexString(s.getIntValue()));
                        pw.print(';');
                        pw.println();
                        continue;
                    }
                    Symbol.StyleableSymbol styleable = (Symbol.StyleableSymbol)s;
                    SymbolIo.writeStyleableValue(styleable, pw);
                    pw.print(';');
                    pw.println();
                    ImmutableList<String> children = styleable.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        pw.print("        ");
                        pw.print(idModifiers);
                        pw.print(' ');
                        pw.print(typeName);
                        pw.print(' ');
                        pw.print(name);
                        pw.print('_');
                        pw.print(SymbolUtils.canonicalizeValueResourceName((String)children.get(i)));
                        pw.print(" = ");
                        pw.print(i);
                        pw.print(';');
                        pw.println();
                    }
                }
                pw.print("    }");
                pw.println();
            }
            pw.print('}');
            pw.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return file;
    }

    private static enum ReadConfiguration {
        AAPT(true, false){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readAaptLine(line);
            }
        }
        ,
        AAPT_NO_VALUES(false, false, false, true, null){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readAaptLine(line);
            }
        }
        ,
        SYMBOL_LIST_WITH_PACKAGE(false, true){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readSymbolListWithPackageLine(line);
            }
        }
        ,
        R_DEF(false, true, true, false, "R_DEF: Internal format may change without notice"){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readSymbolListWithPackageLine(line);
            }
        }
        ,
        PARTIAL_FILE(false, false){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readPartialRLine(line);
            }
        }
        ,
        PUBLIC_FILE(false, true){

            @Override
            public SymbolData parseLine(String line) throws IOException {
                return SymbolIo.readPublicTxtLine(line);
            }
        };

        final boolean readValues;
        final boolean singleLineStyleable;
        final boolean rawSymbolNames;
        final boolean ignoreRogueChildren;
        final String fileTypeHeader;

        private ReadConfiguration(boolean readValues, boolean singleLineStyleable) {
            this(readValues, singleLineStyleable, false, false, null);
        }

        private ReadConfiguration(boolean readValues, boolean singleLineStyleable, boolean rawSymbolNames, boolean ignoreRogueChildren, String fileTypeHeader) {
            this.readValues = readValues;
            this.singleLineStyleable = singleLineStyleable;
            this.fileTypeHeader = fileTypeHeader;
            this.rawSymbolNames = rawSymbolNames;
            this.ignoreRogueChildren = ignoreRogueChildren;
        }

        abstract SymbolData parseLine(String var1) throws IOException;
    }

    private static final class SymbolData {
        final ResourceVisibility accessibility;
        final ResourceType resourceType;
        final String name;
        final SymbolJavaType javaType;
        final String value;
        final ImmutableList<String> children;
        final boolean maybeDefinition;

        public SymbolData(ResourceType resourceType, String name, SymbolJavaType javaType, String value) {
            this.accessibility = ResourceVisibility.UNDEFINED;
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = javaType;
            this.value = value;
            this.children = ImmutableList.of();
            this.maybeDefinition = false;
        }

        public SymbolData(ResourceVisibility accessibility, ResourceType resourceType, String name, SymbolJavaType javaType, String value) {
            this.accessibility = accessibility;
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = javaType;
            this.value = value;
            this.children = ImmutableList.of();
            this.maybeDefinition = false;
        }

        public SymbolData(String name, ImmutableList<String> children) {
            this.accessibility = ResourceVisibility.UNDEFINED;
            this.resourceType = ResourceType.STYLEABLE;
            this.name = name;
            this.javaType = SymbolJavaType.INT_LIST;
            this.value = "";
            this.children = children;
            this.maybeDefinition = false;
        }

        public SymbolData(ResourceType resourceType, String name) {
            this.accessibility = ResourceVisibility.UNDEFINED;
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = resourceType == ResourceType.STYLEABLE ? SymbolJavaType.INT_LIST : SymbolJavaType.INT;
            this.value = "";
            this.children = ImmutableList.of();
            this.maybeDefinition = false;
        }

        public SymbolData(String name, boolean maybeDefinition) {
            this.accessibility = ResourceVisibility.UNDEFINED;
            this.name = name;
            this.javaType = SymbolJavaType.INT;
            this.resourceType = ResourceType.ATTR;
            this.value = "";
            this.children = ImmutableList.of();
            this.maybeDefinition = maybeDefinition;
        }
    }

    private static class SymbolLineReader {
        private final SymbolTable.Builder table = SymbolTable.builder();
        private final Iterator<String> lines;
        private final Path file;
        private final ReadConfiguration readConfiguration;
        private int currentLineNumber;
        private String currentLineContent;
        private final List<SymbolData> aaptStyleableChildrenCache = new ArrayList<SymbolData>(10);
        private static final Comparator<SymbolData> SYMBOL_DATA_VALUE_COMPARATOR = Comparator.comparingInt(o -> Integer.parseInt(o.value));

        SymbolLineReader(ReadConfiguration readConfiguration, Iterator<String> lines, Path file, int startLine) {
            this.readConfiguration = readConfiguration;
            this.lines = lines;
            this.file = file;
            this.currentLineNumber = startLine - 1;
        }

        private void readNextLine() {
            if (!this.lines.hasNext()) {
                this.currentLineContent = null;
            } else {
                this.currentLineContent = this.lines.next();
                ++this.currentLineNumber;
            }
        }

        SymbolTable.Builder readLines() throws IOException {
            if (!this.lines.hasNext()) {
                return this.table;
            }
            this.readNextLine();
            try {
                while (this.currentLineContent != null) {
                    String canonicalName;
                    SymbolData data = this.readConfiguration.parseLine(this.currentLineContent);
                    if (data.resourceType == ResourceType.STYLEABLE) {
                        switch (data.javaType) {
                            case INT: {
                                if (this.readConfiguration.ignoreRogueChildren) {
                                    this.readNextLine();
                                    break;
                                }
                                throw new IOException("Unexpected styleable child " + this.currentLineContent);
                            }
                            case INT_LIST: {
                                this.readNextLine();
                                this.handleStyleable(this.table, data);
                            }
                        }
                        continue;
                    }
                    int value = 0;
                    if (this.readConfiguration.readValues) {
                        value = SymbolUtils.valueStringToInt(data.value);
                    }
                    String string = canonicalName = this.readConfiguration.rawSymbolNames ? SymbolUtils.canonicalizeValueResourceName(data.name) : data.name;
                    if (data.resourceType == ResourceType.ATTR) {
                        this.table.add(new Symbol.AttributeSymbol(data.name, value, data.maybeDefinition, data.accessibility, canonicalName));
                    } else {
                        this.table.add(new Symbol.NormalSymbol(data.resourceType, data.name, value, data.accessibility, canonicalName));
                    }
                    this.readNextLine();
                }
            }
            catch (IOException | IndexOutOfBoundsException e) {
                throw new IOException(String.format("File format error reading %1$s line %2$d: '%3$s'", this.file.toString(), this.currentLineNumber, this.currentLineContent), e);
            }
            return this.table;
        }

        private void handleStyleable(SymbolTable.Builder table, SymbolData data) throws IOException {
            ImmutableList<Integer> values;
            if (this.readConfiguration.singleLineStyleable) {
                String canonicalName = this.readConfiguration.rawSymbolNames ? SymbolUtils.canonicalizeValueResourceName(data.name) : data.name;
                table.add(new Symbol.StyleableSymbol(data.name, (ImmutableList<Integer>)ImmutableList.of(), data.children, data.accessibility, canonicalName));
                return;
            }
            String styleableLineContent = this.currentLineContent;
            int styleableLineIndex = this.currentLineNumber;
            String data_name = data.name + "_";
            this.aaptStyleableChildrenCache.clear();
            List<SymbolData> children = this.aaptStyleableChildrenCache;
            while (this.currentLineContent != null) {
                SymbolData subData = this.readConfiguration.parseLine(this.currentLineContent);
                if (subData.resourceType != ResourceType.STYLEABLE || subData.javaType != SymbolJavaType.INT) break;
                children.add(subData);
                this.readNextLine();
            }
            if (this.readConfiguration.readValues) {
                try {
                    children.sort(SYMBOL_DATA_VALUE_COMPARATOR);
                }
                catch (NumberFormatException e) {
                    this.currentLineContent = styleableLineContent;
                    this.currentLineNumber = styleableLineIndex;
                    throw new IOException(e);
                }
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (SymbolData aaptStyleableChild : children) {
                builder.add((Object)SymbolIo.computeItemName(data_name, aaptStyleableChild.name));
            }
            ImmutableList childNames = builder.build();
            if (this.readConfiguration.readValues) {
                try {
                    values = SymbolUtils.parseArrayLiteral(childNames.size(), data.value);
                }
                catch (NumberFormatException e) {
                    this.currentLineContent = styleableLineContent;
                    this.currentLineNumber = styleableLineIndex;
                    throw new IOException("Unable to parse array literal " + data.name + " = " + data.value, e);
                }
            } else {
                values = ImmutableList.of();
            }
            String canonicalName = this.readConfiguration.rawSymbolNames ? SymbolUtils.canonicalizeValueResourceName(data.name) : data.name;
            table.add(new Symbol.StyleableSymbol(canonicalName, values, (ImmutableList<String>)childNames, data.accessibility, data.name));
        }
    }
}

