/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.ide.common.build.ApkInfo;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class ApkData
implements ApkInfo,
VariantOutput,
Comparable<ApkData> {
    private static final Comparator<ApkData> COMPARATOR = Comparator.nullsLast(Comparator.comparing(ApkData::getType).thenComparingInt(ApkData::getVersionCode).thenComparing(ApkData::getOutputFileName, Comparator.nullsLast(String::compareTo)).thenComparing(ApkData::getVersionName, Comparator.nullsLast(String::compareTo)).thenComparing(ApkData::isEnabled));
    private Supplier<String> versionName = () -> null;
    private IntSupplier versionCode = () -> 0;
    private AtomicBoolean enabled = new AtomicBoolean(true);
    private String outputFileName;

    @Override
    public Collection<FilterData> getFilters() {
        return ImmutableList.of();
    }

    public Collection<String> getFilterTypes() {
        return this.getFilters().stream().map(FilterData::getFilterType).collect(Collectors.toList());
    }

    @Override
    public FilterData getFilter(VariantOutput.FilterType filterType) {
        for (FilterData filter2 : this.getFilters()) {
            if (VariantOutput.FilterType.valueOf((String)filter2.getFilterType()) != filterType) continue;
            return filter2;
        }
        return null;
    }

    public String getFilter(String filterType) {
        return ApkData.getFilter(this.getFilters(), VariantOutput.FilterType.valueOf((String)filterType));
    }

    @Override
    public boolean requiresAapt() {
        return true;
    }

    @Override
    public abstract String getBaseName();

    @Override
    public abstract String getFullName();

    @Override
    public abstract VariantOutput.OutputType getType();

    public abstract String getDirName();

    public void setVersionCode(IntSupplier versionCode) {
        this.versionCode = versionCode;
    }

    public void setVersionName(Supplier<String> versionName) {
        this.versionName = versionName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    @Override
    public int getVersionCode() {
        return this.versionCode.getAsInt();
    }

    @Override
    public String getVersionName() {
        return this.versionName.get();
    }

    @Override
    public String getOutputFileName() {
        return this.outputFileName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("fullName", (Object)this.getFullName()).add("filters", this.getFilters()).add("versionCode", this.getVersionCode()).add("versionName", (Object)this.getVersionName()).toString();
    }

    public OutputFile getMainOutputFile() {
        throw new UnsupportedOperationException("getMainOutputFile is no longer supported.  Use getOutputFileName if you need to determine the file name of the output.");
    }

    public Collection<? extends OutputFile> getOutputs() {
        throw new UnsupportedOperationException("getOutputs is no longer supported.  Use getOutputFileName if you need to determine the file name of the output.");
    }

    public String getOutputType() {
        return this.getType().name();
    }

    public static String getFilter(Collection<FilterData> filters, VariantOutput.FilterType filterType) {
        for (FilterData filter2 : filters) {
            if (VariantOutput.FilterType.valueOf((String)filter2.getFilterType()) != filterType) continue;
            return filter2.getIdentifier();
        }
        return null;
    }

    public void disable() {
        this.enabled.set(false);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApkData that = (ApkData)o;
        return this.getVersionCode() == that.getVersionCode() && Objects.equals(this.outputFileName, that.outputFileName) && Objects.equals(this.getVersionName(), that.getVersionName()) && Objects.equals(this.enabled.get(), that.enabled.get());
    }

    public int hashCode() {
        return Objects.hash(this.getVersionCode(), this.enabled.get(), this.getVersionName(), this.outputFileName);
    }

    @Override
    public int compareTo(ApkData other) {
        return COMPARATOR.compare(this, other);
    }
}

