/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.aapt.Resources;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ProtoXmlPullParser
implements XmlPullParser {
    private InputStream myStream;
    private int myEventType;
    private final List<Resources.XmlNode> myNodeStack = new ArrayList<Resources.XmlNode>();
    private final TIntArrayList myCurrentChildIndices = new TIntArrayList();

    public void setFeature(String feature, boolean state) throws XmlPullParserException {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(feature) && !state) {
            throw new XmlPullParserException("Cannot turn off namespace processing");
        }
        throw new XmlPullParserException("Unsupported feature: " + feature);
    }

    public boolean getFeature(String feature) {
        return "http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(feature);
    }

    public void setProperty(String property, @Nullable Object value) throws XmlPullParserException {
        throw new XmlPullParserException("Unsupported property: " + property);
    }

    @Nullable
    public Object getProperty(String property) {
        return null;
    }

    public void setInput(Reader in) {
        throw new UnsupportedOperationException("Use setInput(InputStream, String) instead");
    }

    public void setInput(InputStream inputStream, @Nullable String inputEncoding) {
        this.myStream = inputStream;
        this.myNodeStack.clear();
        this.myCurrentChildIndices.clear();
        this.myEventType = 0;
    }

    @Nullable
    public String getInputEncoding() {
        return null;
    }

    public void defineEntityReplacementText(String entityName, String replacementText) {
        throw new UnsupportedOperationException();
    }

    public final int getDepth() {
        return this.myNodeStack.size();
    }

    public final int getLineNumber() {
        if (this.myEventType == 0) {
            return 1;
        }
        Resources.XmlNode node = this.getCurrentNode();
        if (node != null && node.hasSource()) {
            return node.getSource().getLineNumber();
        }
        return -1;
    }

    public final int getColumnNumber() {
        if (this.myEventType == 0) {
            return 0;
        }
        Resources.XmlNode node = this.getCurrentNode();
        if (node != null && node.hasSource()) {
            return node.getSource().getColumnNumber();
        }
        return -1;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        String text = this.getText();
        if (text == null) {
            throw new XmlPullParserException("Illegal state - no current text");
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public String getText() {
        Resources.XmlNode node = this.getCurrentNode();
        if (node != null && node.getNodeCase() == Resources.XmlNode.NodeCase.TEXT) {
            return node.getText();
        }
        return null;
    }

    @Nullable
    public char[] getTextCharacters(int[] holderForStartAndLength) {
        String text = this.getText();
        if (text == null) {
            return null;
        }
        holderForStartAndLength[0] = 0;
        holderForStartAndLength[1] = text.length();
        return text.toCharArray();
    }

    @Nullable
    public String getNamespace() {
        Resources.XmlElement element = this.getCurrentElement();
        if (element == null) {
            return null;
        }
        return element.getNamespaceUri();
    }

    @Nullable
    public String getName() {
        Resources.XmlElement element = this.getCurrentElement();
        if (element == null) {
            return null;
        }
        return ProtoXmlPullParser.getNameWithoutPrefix(element.getName());
    }

    @Nullable
    public String getPrefix() {
        Resources.XmlElement element = this.getCurrentElement();
        if (element == null) {
            return null;
        }
        return ProtoXmlPullParser.getPrefix(element.getName());
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        Resources.XmlElement element = this.getCurrentElement();
        if (element == null) {
            throw new XmlPullParserException("Illegal state - no current element");
        }
        return element.getAttributeCount() == 0 && element.getChildCount() == 0;
    }

    public int getAttributeCount() {
        Resources.XmlElement element = this.getCurrentElement();
        if (element == null || this.myEventType != 2) {
            return -1;
        }
        return element.getAttributeCount();
    }

    public String getAttributeNamespace(int index) {
        return this.getAttribute(index).getNamespaceUri();
    }

    public String getAttributeName(int index) {
        return ProtoXmlPullParser.getNameWithoutPrefix(this.getAttribute(index).getName());
    }

    @Nullable
    public String getAttributePrefix(int index) {
        return this.getPrefixFromNamespace(this.getAttribute(index).getNamespaceUri());
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        return false;
    }

    public String getAttributeValue(int index) {
        return this.getAttribute(index).getValue();
    }

    @Nullable
    public String getAttributeValue(@Nullable String namespace, String name) {
        Resources.XmlElement element = this.getCurrentElement();
        if (element == null || this.myEventType != 2) {
            throw new IndexOutOfBoundsException();
        }
        for (Resources.XmlAttribute attribute : element.getAttributeList()) {
            if (!attribute.getName().equals(name) || !(namespace == null ? attribute.getNamespaceUri().isEmpty() : attribute.getNamespaceUri().equals(namespace))) continue;
            return attribute.getValue();
        }
        return null;
    }

    public final int getEventType() {
        return this.myEventType;
    }

    public int next() throws XmlPullParserException, IOException {
        if (this.myStream == null) {
            throw new XmlPullParserException("Input is not set");
        }
        switch (this.myEventType) {
            case 1: {
                break;
            }
            case 0: {
                assert (this.myNodeStack.isEmpty());
                assert (this.myCurrentChildIndices.isEmpty());
                Resources.XmlNode rootNode = Resources.XmlNode.parseFrom((InputStream)this.myStream);
                this.myNodeStack.add(rootNode);
                this.myCurrentChildIndices.add(0);
                this.myEventType = 2;
                break;
            }
            case 2: {
                this.nextChild();
                break;
            }
            case 3: 
            case 4: {
                this.myNodeStack.remove(this.myNodeStack.size() - 1);
                this.myCurrentChildIndices.remove(this.myCurrentChildIndices.size() - 1);
                if (this.myNodeStack.isEmpty()) {
                    this.myEventType = 1;
                    break;
                }
                this.nextChild();
            }
        }
        return this.myEventType;
    }

    private void nextChild() {
        Resources.XmlElement element = this.getCurrentElement();
        assert (element != null);
        int childIndex = this.myCurrentChildIndices.get(this.myCurrentChildIndices.size() - 1);
        if (childIndex < element.getChildCount()) {
            Resources.XmlNode node = element.getChild(childIndex);
            this.myCurrentChildIndices.set(this.myCurrentChildIndices.size() - 1, childIndex + 1);
            this.myNodeStack.add(node);
            this.myCurrentChildIndices.add(0);
            this.myEventType = node.hasElement() ? 2 : (node.getText().isEmpty() ? 3 : 4);
        } else {
            this.myEventType = 3;
        }
    }

    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    public String nextText() throws XmlPullParserException, IOException {
        String text;
        if (this.myEventType != 2) {
            throw new XmlPullParserException("Precondition: START_TAG");
        }
        this.next();
        if (this.myEventType == 4) {
            text = this.getText();
            assert (text != null);
            this.next();
        } else {
            text = "";
        }
        if (this.myEventType != 3) {
            throw new XmlPullParserException("Expected END_TAG");
        }
        return text;
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int myEventType = this.next();
        if (myEventType == 4 && this.isWhitespace()) {
            myEventType = this.next();
        }
        if (myEventType != 2 && myEventType != 3) {
            throw new XmlPullParserException("Expected START_TAG or END_TAG", (XmlPullParser)this, null);
        }
        return myEventType;
    }

    public int getNamespaceCount(int depth) {
        if (depth > this.myNodeStack.size()) {
            throw new IllegalArgumentException("Requested depth (" + depth + ") is greater than current (" + this.myNodeStack.size() + ")");
        }
        int count = 0;
        for (int i = 0; i < depth; ++i) {
            Resources.XmlNode node = this.myNodeStack.get(i);
            if (!node.hasElement()) continue;
            count += node.getElement().getNamespaceDeclarationCount();
        }
        return count;
    }

    @Nullable
    public String getNamespacePrefix(int pos) {
        for (Resources.XmlNode node : this.myNodeStack) {
            if (!node.hasElement()) continue;
            Resources.XmlElement element = node.getElement();
            int namespaceCount = element.getNamespaceDeclarationCount();
            if (pos < namespaceCount) {
                return element.getNamespaceDeclaration(pos).getPrefix();
            }
            pos -= namespaceCount;
        }
        throw new IndexOutOfBoundsException();
    }

    public String getNamespaceUri(int pos) {
        for (Resources.XmlNode node : this.myNodeStack) {
            if (!node.hasElement()) continue;
            Resources.XmlElement element = node.getElement();
            int namespaceCount = element.getNamespaceDeclarationCount();
            if (pos < namespaceCount) {
                return element.getNamespaceDeclaration(pos).getUri();
            }
            pos -= namespaceCount;
        }
        throw new IndexOutOfBoundsException();
    }

    @Nullable
    public String getNamespace(@Nullable String prefix) {
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        int i = this.myNodeStack.size();
        while (--i >= 0) {
            Resources.XmlNode node = this.myNodeStack.get(i);
            if (!node.hasElement()) continue;
            Resources.XmlElement element = node.getElement();
            int j = element.getNamespaceDeclarationCount();
            while (--j >= 0) {
                Resources.XmlNamespace namespace = element.getNamespaceDeclaration(j);
                if (!namespace.getPrefix().equals(prefix)) continue;
                return namespace.getUri();
            }
        }
        return null;
    }

    @Nullable
    private String getPrefixFromNamespace(String namespaceUri) {
        if (namespaceUri.isEmpty()) {
            return null;
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceUri)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceUri)) {
            return "xmlns";
        }
        int i = this.myNodeStack.size();
        while (--i >= 0) {
            Resources.XmlNode node = this.myNodeStack.get(i);
            if (!node.hasElement()) continue;
            Resources.XmlElement element = node.getElement();
            int j = element.getNamespaceDeclarationCount();
            while (--j >= 0) {
                Resources.XmlNamespace namespace = element.getNamespaceDeclaration(j);
                if (!namespace.getUri().equals(namespaceUri)) continue;
                return namespace.getPrefix();
            }
        }
        return null;
    }

    public String getPositionDescription() {
        StringBuilder buf = new StringBuilder(this.myEventType < XmlPullParser.TYPES.length ? XmlPullParser.TYPES[this.myEventType] : "unknown");
        buf.append(' ');
        if (this.myEventType == 2 || this.myEventType == 3) {
            String prefix;
            buf.append('<');
            if (this.myEventType == 3) {
                buf.append('/');
            }
            if ((prefix = this.getPrefix()) != null) {
                buf.append(prefix).append(':');
            }
            buf.append(this.getName());
            Resources.XmlElement element = this.getCurrentElement();
            assert (element != null);
            int attributeCount = this.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                buf.append(' ');
                Resources.XmlAttribute attribute = element.getAttribute(i);
                prefix = this.getPrefixFromNamespace(attribute.getNamespaceUri());
                if (prefix != null) {
                    buf.append(prefix).append(':');
                }
                buf.append(attribute.getName());
                buf.append("=\"");
                buf.append(attribute.getValue());
                buf.append('\"');
            }
            buf.append('>');
        } else if (this.myEventType == 4) {
            String text = this.getText();
            assert (text != null);
            if (text.length() <= 16) {
                buf.append(text);
            } else {
                buf.append(text, 0, 16).append("...");
            }
        }
        int line = this.getLineNumber();
        int column = this.getColumnNumber();
        if (line >= 1) {
            buf.append(" @").append(line);
            if (column >= 0) {
                buf.append(':').append(column);
            }
        }
        return buf.toString();
    }

    public void require(int type, @Nullable String namespace, @Nullable String name) throws XmlPullParserException {
        if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new XmlPullParserException("Expected: " + XmlPullParser.TYPES[type] + " {" + namespace + "}" + name);
        }
    }

    @Nullable
    private Resources.XmlNode getCurrentNode() {
        return this.myNodeStack.isEmpty() ? null : this.myNodeStack.get(this.myNodeStack.size() - 1);
    }

    @Nullable
    private Resources.XmlElement getCurrentElement() {
        Resources.XmlNode node = this.getCurrentNode();
        if (node != null && node.hasElement()) {
            return node.getElement();
        }
        return null;
    }

    private Resources.XmlAttribute getAttribute(int index) {
        Resources.XmlElement element = this.getCurrentElement();
        if (element == null || this.myEventType != 2) {
            throw new IndexOutOfBoundsException();
        }
        return element.getAttribute(index);
    }

    @Nullable
    private static String getPrefix(String fullName) {
        int pos = fullName.indexOf(58);
        return pos >= 0 ? fullName.substring(0, pos) : null;
    }

    private static String getNameWithoutPrefix(String fullName) {
        int pos = fullName.indexOf(58);
        return pos >= 0 ? fullName.substring(pos + 1) : fullName;
    }
}

