/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H$J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0003H$J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\bH$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/ide/common/repository/NetworkCache;", "", "baseUrl", "", "cacheKey", "cacheDir", "Ljava/io/File;", "networkTimeoutMs", "", "cacheExpiryHours", "networkEnabled", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;IIZ)V", "getCacheDir", "()Ljava/io/File;", "error", "", "throwable", "", "message", "findData", "Ljava/io/InputStream;", "relative", "readDefaultData", "readUrlData", "", "url", "timeout", "sdk-common"})
public abstract class NetworkCache {
    private final String baseUrl;
    private final String cacheKey;
    @Nullable
    private final File cacheDir;
    private final int networkTimeoutMs;
    private final int cacheExpiryHours;
    private final boolean networkEnabled;

    @Nullable
    protected abstract byte[] readUrlData(@NotNull String var1, int var2);

    @Nullable
    protected abstract InputStream readDefaultData(@NotNull String var1);

    protected abstract void error(@NotNull Throwable var1, @Nullable String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected InputStream findData(@NotNull String relative) {
        Intrinsics.checkParameterIsNotNull((Object)relative, (String)"relative");
        if (this.cacheDir == null) return this.readDefaultData(relative);
        File file = this.cacheDir;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (file) {
            block10: {
                boolean bl3 = false;
                CharSequence charSequence = relative;
                File file2 = this.cacheDir;
                boolean bl4 = false;
                boolean bl5 = charSequence.length() > 0;
                String string = bl5 ? relative : this.cacheKey;
                File file3 = file2;
                File file4 = new File(file3, string);
                if (file4.exists()) {
                    long lastModified = file4.lastModified();
                    long now = System.currentTimeMillis();
                    long expiryMs = TimeUnit.HOURS.toMillis(this.cacheExpiryHours);
                    if (!this.networkEnabled) return new BufferedInputStream(new FileInputStream(file4));
                    if (lastModified == 0L) return new BufferedInputStream(new FileInputStream(file4));
                    if (now - lastModified <= expiryMs) {
                        return new BufferedInputStream(new FileInputStream(file4));
                    }
                }
                if (this.networkEnabled) {
                    try {
                        byte[] data = this.readUrlData(this.baseUrl + relative, this.networkTimeoutMs);
                        if (data != null) {
                            File parent;
                            File file5 = parent = file4.getParentFile();
                            if (file5 != null) {
                                file5.mkdirs();
                            }
                            Files.write((byte[])data, (File)file4);
                            return new ByteArrayInputStream(data);
                        }
                    }
                    catch (AssertionError e) {
                        throw (Throwable)((Object)e);
                    }
                    catch (Throwable e) {
                        if (!file4.exists()) break block10;
                        return new BufferedInputStream(new FileInputStream(file4));
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
            return this.readDefaultData(relative);
        }
    }

    @Nullable
    public final File getCacheDir() {
        return this.cacheDir;
    }

    public NetworkCache(@NotNull String baseUrl, @NotNull String cacheKey, @Nullable File cacheDir, int networkTimeoutMs, int cacheExpiryHours, boolean networkEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        this.baseUrl = baseUrl;
        this.cacheKey = cacheKey;
        this.cacheDir = cacheDir;
        this.networkTimeoutMs = networkTimeoutMs;
        this.cacheExpiryHours = cacheExpiryHours;
        this.networkEnabled = networkEnabled;
    }

    public /* synthetic */ NetworkCache(String string, String string2, File file, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            file = null;
        }
        if ((n3 & 8) != 0) {
            n = 3000;
        }
        if ((n3 & 0x10) != 0) {
            n2 = (int)TimeUnit.DAYS.toHours(7L);
        }
        if ((n3 & 0x20) != 0) {
            bl = true;
        }
        this(string, string2, file, n, n2, bl);
    }
}

