/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.Library;
import com.android.ide.common.gradle.model.IdeLibraries;
import com.android.ide.common.gradle.model.IdeMavenCoordinates;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import java.util.Objects;

public abstract class IdeLibrary
extends IdeModel
implements Library {
    private static final long serialVersionUID = 2L;
    private final IdeMavenCoordinates myResolvedCoordinates;
    private final String myBuildId;
    private final String myProject;
    private final String myName;
    private final Boolean myIsSkipped;
    private final Boolean myProvided;
    private final int myHashCode;

    protected IdeLibrary(Library library, ModelCache modelCache) {
        super(library, modelCache);
        this.myResolvedCoordinates = IdeLibraries.computeResolvedCoordinate(library, modelCache);
        this.myBuildId = IdeLibrary.copyNewProperty(() -> ((Library)library).getBuildId(), null);
        this.myProject = IdeLibrary.copyNewProperty(() -> ((Library)library).getProject(), null);
        this.myName = IdeLibrary.copyNewProperty(() -> ((Library)library).getName(), null);
        this.myProvided = IdeLibrary.copyNewProperty(() -> ((Library)library).isProvided(), null);
        this.myIsSkipped = IdeLibrary.copyNewProperty(() -> ((Library)library).isSkipped(), null);
        this.myHashCode = this.calculateHashCode();
    }

    public IdeMavenCoordinates getRequestedCoordinates() {
        throw new UnusedModelMethodException("getRequestedCoordinates");
    }

    public IdeMavenCoordinates getResolvedCoordinates() {
        return this.myResolvedCoordinates;
    }

    public String getBuildId() {
        return this.myBuildId;
    }

    public String getProject() {
        return this.myProject;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isSkipped() {
        if (this.myIsSkipped != null) {
            return this.myIsSkipped;
        }
        throw new UnsupportedOperationException("Unsupported method: IdeLibrary.isSkipped()");
    }

    public boolean isProvided() {
        if (this.myProvided != null) {
            return this.myProvided;
        }
        throw new UnsupportedOperationException("Unsupported method: IdeLibrary.isProvided()");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeLibrary)) {
            return false;
        }
        IdeLibrary library = (IdeLibrary)o;
        return library.canEqual(this) && Objects.equals(this.myIsSkipped, library.myIsSkipped) && Objects.equals(this.myProvided, library.myProvided) && Objects.equals(this.myResolvedCoordinates, library.myResolvedCoordinates) && Objects.equals(this.myBuildId, library.myBuildId) && Objects.equals(this.myProject, library.myProject) && Objects.equals(this.myName, library.myName);
    }

    public boolean canEqual(Object other) {
        return other instanceof IdeLibrary;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myResolvedCoordinates, this.myBuildId, this.myProject, this.myName, this.myProvided, this.myIsSkipped);
    }

    public String toString() {
        return "myResolvedCoordinates=" + this.myResolvedCoordinates + ", myBuildId='" + this.myBuildId + '\'' + ", myProject='" + this.myProject + '\'' + ", myName='" + this.myName + '\'' + ", myProvided=" + this.myProvided;
    }
}

