/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ide.common.util.PathString;
import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0002\b\u0003\u001a\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u001a(\u0010\u001b\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\u00152\b\b\u0002\u0010\u001e\u001a\u00020\u0018H\u0002\u001a!\u0010\u001b\u001a\u00020\u0015*\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180!H\u0082\b\u001a\n\u0010\"\u001a\u00020#*\u00020$\u001a\n\u0010\"\u001a\u00020#*\u00020%\u001a\u000e\u0010&\u001a\u0004\u0018\u00010#*\u0004\u0018\u00010$\u001a\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(*\b\u0012\u0004\u0012\u00020$0)\u001a\u0014\u0010*\u001a\u00020\u0006*\u00020\u00062\u0006\u0010+\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"APK_URI", "Ljava/net/URI;", "JAR_URI", "NUL_CHAR", "", "PARENT", "", "SELF", "defaultFilesystemUri", "getDefaultFilesystemUri", "()Ljava/net/URI;", "uriCache", "Ljava/util/concurrent/ConcurrentHashMap;", "chooseSeparator", "c1", "c2", "createRootUri", "scheme", "detectSeparator", "path", "rootLength", "", "getUri", "isSeparator", "", "c", "prefixLength", "countUntil", "char", "startIndex", "ignoreCase", "Lkotlin/ranges/IntProgression;", "predicate", "Lkotlin/Function1;", "toPathString", "Lcom/android/ide/common/util/PathString;", "Ljava/io/File;", "Ljava/nio/file/Path;", "toPathStringOrNull", "toPathStrings", "", "", "withSeparator", "sep", "sdk-common"})
@JvmName(name="PathStringUtil")
public final class PathStringUtil {
    @NotNull
    public static final String PARENT = "..";
    @NotNull
    public static final String SELF = ".";
    public static final char NUL_CHAR = '\u0000';
    @NotNull
    private static final URI defaultFilesystemUri;
    private static final ConcurrentHashMap<String, URI> uriCache;
    private static final URI APK_URI;
    private static final URI JAR_URI;

    @NotNull
    public static final PathString toPathString(@NotNull Path $this$toPathString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toPathString, (String)"$this$toPathString");
        return new PathString($this$toPathString);
    }

    @NotNull
    public static final PathString toPathString(@NotNull File $this$toPathString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toPathString, (String)"$this$toPathString");
        return new PathString($this$toPathString);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PathString> toPathStrings(@NotNull Collection<? extends File> $this$toPathStrings) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$toPathStrings, (String)"$this$toPathStrings");
        Iterable $this$map$iv = $this$toPathStrings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PathString pathString = new PathString((File)it);
            collection.add(pathString);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final PathString toPathStringOrNull(@Nullable File $this$toPathStringOrNull) {
        File file = $this$toPathStringOrNull;
        return file != null ? PathStringUtil.toPathString(file) : null;
    }

    @NotNull
    public static final URI getDefaultFilesystemUri() {
        return defaultFilesystemUri;
    }

    private static final boolean isSeparator(char c) {
        return c == '/' || c == '\\';
    }

    /*
     * WARNING - void declaration
     */
    private static final int prefixLength(String path) {
        int firstSlash = path.length();
        int n = 0;
        int n2 = path.length();
        while (n < n2) {
            void i;
            if (PathStringUtil.isSeparator(path.charAt((int)i))) {
                firstSlash = i;
                break;
            }
            ++i;
        }
        int firstColon = PathStringUtil.countUntil$default(path, ':', 0, false, 6, null);
        int prefixEnd = firstColon + 1;
        if (firstColon >= firstSlash) {
            if (firstSlash > 0) {
                return 0;
            }
            prefixEnd = 0;
        }
        while (prefixEnd < path.length() && PathStringUtil.isSeparator(path.charAt(prefixEnd))) {
            ++prefixEnd;
        }
        return prefixEnd;
    }

    /*
     * WARNING - void declaration
     */
    private static final int countUntil(@NotNull IntProgression $this$countUntil, Function1<? super Integer, Boolean> predicate) {
        int $i$f$countUntil = 0;
        int result2 = 0;
        IntProgression intProgression = $this$countUntil;
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void item;
                if (((Boolean)predicate.invoke((Object)((int)item))).booleanValue()) {
                    return result2;
                }
                ++result2;
                if (item == n2) break;
                item += n3;
            }
        }
        return result2;
    }

    private static final int countUntil(@NotNull String $this$countUntil, char c, int startIndex, boolean ignoreCase) {
        int result2 = StringsKt.indexOf((CharSequence)$this$countUntil, (char)c, (int)startIndex, (boolean)ignoreCase);
        return result2 == -1 ? $this$countUntil.length() : result2;
    }

    static /* synthetic */ int countUntil$default(String string, char c, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return PathStringUtil.countUntil(string, c, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final char detectSeparator(String path, int rootLength) {
        int startIndex;
        int n = startIndex = RangesKt.coerceAtLeast((int)(rootLength - 1), (int)0);
        int n2 = path.length();
        while (n < n2) {
            void i;
            char c = path.charAt((int)i);
            if (PathStringUtil.isSeparator(c)) {
                return c;
            }
            ++i;
        }
        return '\u0000';
    }

    private static final String withSeparator(@NotNull String $this$withSeparator, char sep) {
        return sep == '\u0000' ? $this$withSeparator : StringsKt.replace$default((String)StringsKt.replace$default((String)$this$withSeparator, (char)'/', (char)sep, (boolean)false, (int)4, null), (char)'\\', (char)sep, (boolean)false, (int)4, null);
    }

    private static final char chooseSeparator(char c1, char c2) {
        return c1 == '\u0000' ? (c2 == '\u0000' ? File.separatorChar : c2) : c1;
    }

    private static final URI getUri(String scheme) {
        URI uRI;
        String string = scheme;
        if (Intrinsics.areEqual((Object)string, (Object)defaultFilesystemUri.getScheme())) {
            uRI = defaultFilesystemUri;
        } else if (Intrinsics.areEqual((Object)string, (Object)APK_URI.getScheme())) {
            uRI = APK_URI;
        } else if (Intrinsics.areEqual((Object)string, (Object)JAR_URI.getScheme())) {
            uRI = JAR_URI;
        } else {
            ConcurrentMap $this$getOrPut$iv = uriCache;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(scheme);
            if (object == null) {
                boolean bl = false;
                URI uRI2 = PathStringUtil.createRootUri(scheme);
                boolean bl2 = false;
                boolean bl3 = false;
                URI default$iv = uRI2;
                boolean bl4 = false;
                object = $this$getOrPut$iv.putIfAbsent(scheme, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkExpressionValueIsNotNull(object, (String)"uriCache.getOrPut(scheme\u2026{ createRootUri(scheme) }");
            uRI = (URI)object;
        }
        return uRI;
    }

    private static final URI createRootUri(String scheme) {
        return new URI(scheme, "", "/", null);
    }

    static {
        FileSystem fileSystem = FileSystems.getDefault();
        boolean bl = false;
        boolean bl2 = false;
        FileSystem it = fileSystem;
        boolean bl3 = false;
        FileSystem fileSystem2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem2, (String)"it");
        URI uRI = it.getPath(fileSystem2.getSeparator(), new String[0]).toUri();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"FileSystems.getDefault()\u2026h(it.separator) }.toUri()");
        defaultFilesystemUri = uRI;
        uriCache = new ConcurrentHashMap();
        APK_URI = PathStringUtil.createRootUri("apk");
        JAR_URI = PathStringUtil.createRootUri("jar");
    }

    public static final /* synthetic */ String access$withSeparator(String $this$access_u24withSeparator, char sep) {
        return PathStringUtil.withSeparator($this$access_u24withSeparator, sep);
    }

    public static final /* synthetic */ boolean access$isSeparator(char c) {
        return PathStringUtil.isSeparator(c);
    }

    public static final /* synthetic */ int access$countUntil(IntProgression $this$access_u24countUntil, Function1 predicate) {
        return PathStringUtil.countUntil($this$access_u24countUntil, (Function1<? super Integer, Boolean>)predicate);
    }

    public static final /* synthetic */ char access$chooseSeparator(char c1, char c2) {
        return PathStringUtil.chooseSeparator(c1, c2);
    }

    public static final /* synthetic */ char access$detectSeparator(String path, int rootLength) {
        return PathStringUtil.detectSeparator(path, rootLength);
    }

    public static final /* synthetic */ URI access$getUri(String scheme) {
        return PathStringUtil.getUri(scheme);
    }

    public static final /* synthetic */ int access$prefixLength(String path) {
        return PathStringUtil.prefixLength(path);
    }
}

