/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.build.GenericBuiltArtifact;
import com.android.ide.common.build.GenericBuiltArtifacts;
import com.android.ide.common.build.GenericFilterConfiguration;
import com.android.resources.Density;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000bJ>\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0004J \u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0004H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\fH\u0002J2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/android/ide/common/build/GenericBuiltArtifactsSplitOutputMatcher;", "", "()V", "computeBestOutput", "", "Ljava/io/File;", "deviceConfigProvider", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "builtArtifacts", "Lcom/android/ide/common/build/GenericBuiltArtifacts;", "variantAbiFilters", "", "", "outputs", "deviceDensity", "", "deviceAbis", "getAbiPreferenceOrder", "builtArtifact", "Lcom/android/ide/common/build/GenericBuiltArtifact;", "deviceAbi", "getFilter", "variantOutput", "filterType", "isMainApkCompatibleWithDevice", "", "mainBuiltArtifact", "sdk-common"})
public final class GenericBuiltArtifactsSplitOutputMatcher {
    public static final GenericBuiltArtifactsSplitOutputMatcher INSTANCE;

    @NotNull
    public final List<File> computeBestOutput(@NotNull DeviceConfigProvider deviceConfigProvider, @NotNull GenericBuiltArtifacts builtArtifacts, @Nullable Collection<String> variantAbiFilters) {
        Intrinsics.checkParameterIsNotNull((Object)deviceConfigProvider, (String)"deviceConfigProvider");
        Intrinsics.checkParameterIsNotNull((Object)builtArtifacts, (String)"builtArtifacts");
        int n = deviceConfigProvider.getDensity();
        List list = deviceConfigProvider.getAbis();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"deviceConfigProvider.abis");
        return this.computeBestOutput(builtArtifacts, variantAbiFilters, n, list);
    }

    @NotNull
    public final List<File> computeBestOutput(@NotNull GenericBuiltArtifacts outputs, @Nullable Collection<String> variantAbiFilters, int deviceDensity, @NotNull List<String> deviceAbis) {
        List list;
        GenericBuiltArtifact match2;
        Intrinsics.checkParameterIsNotNull((Object)outputs, (String)"outputs");
        Intrinsics.checkParameterIsNotNull(deviceAbis, (String)"deviceAbis");
        Density densityEnum = Density.getEnum((int)deviceDensity);
        String densityValue = null;
        Density density = densityEnum;
        densityValue = density != null ? density.getResourceValue() : null;
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList()");
        List matches = arrayList;
        for (GenericBuiltArtifact builtArtifact : outputs.getElements()) {
            String densityFilter = this.getFilter(builtArtifact, "DENSITY");
            String abiFilter = this.getFilter(builtArtifact, "ABI");
            if (densityFilter != null && Intrinsics.areEqual((Object)densityFilter, (Object)densityValue) ^ true || abiFilter != null && !deviceAbis.contains(abiFilter)) continue;
            matches.add(builtArtifact);
        }
        if (matches.isEmpty()) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            return (List)immutableList;
        }
        GenericBuiltArtifact genericBuiltArtifact = match2 = (GenericBuiltArtifact)Collections.max(matches, new Comparator<T>(deviceAbis){
            final /* synthetic */ List $deviceAbis;

            public final int compare(@NotNull GenericBuiltArtifact splitOutput, @NotNull GenericBuiltArtifact splitOutput2) {
                Intrinsics.checkParameterIsNotNull((Object)splitOutput, (String)"splitOutput");
                Intrinsics.checkParameterIsNotNull((Object)splitOutput2, (String)"splitOutput2");
                int rc = splitOutput.getVersionCode() - splitOutput2.getVersionCode();
                if (rc != 0) {
                    return rc;
                }
                int abiOrder1 = GenericBuiltArtifactsSplitOutputMatcher.access$getAbiPreferenceOrder(GenericBuiltArtifactsSplitOutputMatcher.INSTANCE, splitOutput, this.$deviceAbis);
                int abiOrder2 = GenericBuiltArtifactsSplitOutputMatcher.access$getAbiPreferenceOrder(GenericBuiltArtifactsSplitOutputMatcher.INSTANCE, splitOutput2, this.$deviceAbis);
                return abiOrder1 - abiOrder2;
            }
            {
                this.$deviceAbis = list;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)genericBuiltArtifact, (String)"match");
        if (this.isMainApkCompatibleWithDevice(genericBuiltArtifact, variantAbiFilters, (Collection<String>)deviceAbis)) {
            ImmutableList immutableList = ImmutableList.of((Object)new File(match2.getOutputFile()));
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(File(match.outputFile))");
            list = (List)immutableList;
        } else {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            list = (List)immutableList;
        }
        return list;
    }

    private final int getAbiPreferenceOrder(GenericBuiltArtifact builtArtifact, List<String> deviceAbi) {
        String abiFilter = this.getFilter(builtArtifact, "ABI");
        if (Strings.isNullOrEmpty((String)abiFilter)) {
            return deviceAbi.size() - 1;
        }
        int match2 = deviceAbi.indexOf(abiFilter);
        if (match2 == 0) {
            match2 = deviceAbi.size();
        } else if (match2 > 0) {
            match2 = deviceAbi.size() - match2 - 1;
        }
        return match2;
    }

    private final boolean isMainApkCompatibleWithDevice(GenericBuiltArtifact mainBuiltArtifact, Collection<String> variantAbiFilters, Collection<String> deviceAbis) {
        if (this.getFilter(mainBuiltArtifact, "ABI") == null && variantAbiFilters != null && !variantAbiFilters.isEmpty()) {
            for (String abi : deviceAbis) {
                if (!variantAbiFilters.contains(abi)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private final String getFilter(GenericBuiltArtifact variantOutput, String filterType) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = variantOutput.getFilters();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GenericFilterConfiguration it = (GenericFilterConfiguration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFilterType(), (Object)filterType)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        GenericFilterConfiguration genericFilterConfiguration = v0;
        return genericFilterConfiguration != null ? genericFilterConfiguration.getIdentifier() : null;
    }

    private GenericBuiltArtifactsSplitOutputMatcher() {
    }

    static {
        GenericBuiltArtifactsSplitOutputMatcher genericBuiltArtifactsSplitOutputMatcher;
        INSTANCE = genericBuiltArtifactsSplitOutputMatcher = new GenericBuiltArtifactsSplitOutputMatcher();
    }

    public static final /* synthetic */ int access$getAbiPreferenceOrder(GenericBuiltArtifactsSplitOutputMatcher $this, GenericBuiltArtifact builtArtifact, List deviceAbi) {
        return $this.getAbiPreferenceOrder(builtArtifact, deviceAbi);
    }
}

