/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class IdeJavaLibrary
extends IdeLibrary
implements JavaLibrary {
    private static final long serialVersionUID = 2L;
    private final File myJarFile;
    private final List<? extends JavaLibrary> myDependencies;
    private final int myHashCode;

    IdeJavaLibrary() {
        this.myJarFile = null;
        this.myDependencies = Collections.emptyList();
        this.myHashCode = 0;
    }

    public IdeJavaLibrary(JavaLibrary library, ModelCache modelCache) {
        super((Library)library, modelCache);
        this.myJarFile = library.getJarFile();
        this.myDependencies = IdeModel.copy(library.getDependencies(), modelCache, dependency -> new IdeJavaLibrary((JavaLibrary)dependency, modelCache));
        this.myHashCode = this.calculateHashCode();
    }

    public File getJarFile() {
        return this.myJarFile;
    }

    public List<? extends JavaLibrary> getDependencies() {
        return this.myDependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeJavaLibrary)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdeJavaLibrary library = (IdeJavaLibrary)o;
        return library.canEqual(this) && Objects.equals(this.myJarFile, library.myJarFile) && Objects.equals(this.myDependencies, library.myDependencies);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof IdeJavaLibrary;
    }

    @Override
    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    protected int calculateHashCode() {
        return Objects.hash(super.calculateHashCode(), this.myJarFile, this.myDependencies);
    }

    @Override
    public String toString() {
        return "IdeJavaLibrary{" + super.toString() + ", myJarFile=" + this.myJarFile + ", myDependencies=" + this.myDependencies + "}";
    }
}

