/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model.impl.ndk.v1;

import com.android.ide.common.gradle.model.ndk.v1.IdeNativeFile;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class IdeNativeFileImpl
implements IdeNativeFile,
Serializable {
    private final File myFilePath;
    private final String mySettingsName;
    @Nullable
    private final File myWorkingDirectory;
    private final int myHashCode;

    public IdeNativeFileImpl() {
        this.myFilePath = null;
        this.mySettingsName = "";
        this.myWorkingDirectory = null;
        this.myHashCode = 0;
    }

    public IdeNativeFileImpl(File filePath, String settingsName, @Nullable File workingDirectory) {
        this.myFilePath = filePath;
        this.mySettingsName = settingsName;
        this.myWorkingDirectory = workingDirectory;
        this.myHashCode = this.calculateHashCode();
    }

    @Override
    public File getFilePath() {
        return this.myFilePath;
    }

    @Override
    public String getSettingsName() {
        return this.mySettingsName;
    }

    @Override
    public File getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeFileImpl)) {
            return false;
        }
        IdeNativeFileImpl file = (IdeNativeFileImpl)o;
        return Objects.equals(this.myFilePath, file.myFilePath) && Objects.equals(this.mySettingsName, file.mySettingsName) && Objects.equals(this.myWorkingDirectory, file.myWorkingDirectory);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myFilePath, this.mySettingsName, this.myWorkingDirectory);
    }

    public String toString() {
        return "IdeNativeFile{myFilePath=" + this.myFilePath + ", mySettingsName='" + this.mySettingsName + '\'' + ", myWorkingDirectory=" + this.myWorkingDirectory + "}";
    }
}

