/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.annotations.concurrency.Slow;
import com.android.io.CancellableFileIo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H$J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0015J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0003H$J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\bH%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/ide/common/repository/NetworkCache;", "", "baseUrl", "", "cacheKey", "cacheDir", "Ljava/nio/file/Path;", "networkTimeoutMs", "", "cacheExpiryHours", "networkEnabled", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;IIZ)V", "getCacheDir", "()Ljava/nio/file/Path;", "error", "", "throwable", "", "message", "findData", "Ljava/io/InputStream;", "relative", "readDefaultData", "readUrlData", "", "url", "timeout", "sdk-common"})
public abstract class NetworkCache {
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String cacheKey;
    @Nullable
    private final Path cacheDir;
    private final int networkTimeoutMs;
    private final int cacheExpiryHours;
    private final boolean networkEnabled;

    public NetworkCache(@NotNull String baseUrl, @NotNull String cacheKey, @Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours, boolean networkEnabled) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        this.baseUrl = baseUrl;
        this.cacheKey = cacheKey;
        this.cacheDir = cacheDir;
        this.networkTimeoutMs = networkTimeoutMs;
        this.cacheExpiryHours = cacheExpiryHours;
        this.networkEnabled = networkEnabled;
    }

    public /* synthetic */ NetworkCache(String string, String string2, Path path, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            path = null;
        }
        if ((n3 & 8) != 0) {
            n = 3000;
        }
        if ((n3 & 0x10) != 0) {
            n2 = (int)TimeUnit.DAYS.toHours(7L);
        }
        if ((n3 & 0x20) != 0) {
            bl = true;
        }
        this(string, string2, path, n, n2, bl);
    }

    @Nullable
    public final Path getCacheDir() {
        return this.cacheDir;
    }

    @Slow
    @Nullable
    protected abstract byte[] readUrlData(@NotNull String var1, int var2);

    @Nullable
    protected abstract InputStream readDefaultData(@NotNull String var1);

    protected abstract void error(@NotNull Throwable var1, @Nullable String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Slow
    @Nullable
    protected InputStream findData(@NotNull String relative) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        if (this.cacheDir == null) return this.readDefaultData(relative);
        Path path = this.cacheDir;
        synchronized (path) {
            boolean bl = false;
            Path file = this.getCacheDir().resolve(((CharSequence)relative).length() > 0 ? relative : this.cacheKey);
            try {
                long lastModified = CancellableFileIo.getLastModifiedTime((Path)file, (LinkOption[])new LinkOption[0]).toMillis();
                long now = System.currentTimeMillis();
                long expiryMs = TimeUnit.HOURS.toMillis(this.cacheExpiryHours);
                if (!this.networkEnabled) return CancellableFileIo.newInputStream((Path)file, (OpenOption[])new OpenOption[0]);
                if (lastModified == 0L) return CancellableFileIo.newInputStream((Path)file, (OpenOption[])new OpenOption[0]);
                if (now - lastModified <= expiryMs) {
                    return CancellableFileIo.newInputStream((Path)file, (OpenOption[])new OpenOption[0]);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
            if (this.networkEnabled) {
                try {
                    byte[] data = this.readUrlData(Intrinsics.stringPlus((String)this.baseUrl, (Object)relative), this.networkTimeoutMs);
                    if (data != null) {
                        Path path2 = file.getParent();
                        if (path2 != null) {
                            Path it = path2;
                            boolean bl2 = false;
                            Files.createDirectories(it, new FileAttribute[0]);
                        }
                        Files.write(file, data, new OpenOption[0]);
                        return new ByteArrayInputStream(data);
                    }
                }
                catch (AssertionError e) {
                    throw e;
                }
                catch (Throwable e) {
                    try {
                        return CancellableFileIo.newInputStream((Path)file, (OpenOption[])new OpenOption[0]);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
            return this.readDefaultData(relative);
        }
    }
}

