/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.sdk;

import com.android.instantapp.sdk.InstantAppSdkException;
import com.android.instantapp.sdk.Metadata;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ManifestParser {
    private final File myManifestFile;
    private final File myApksDirectory;

    ManifestParser(File instantAppSdk) throws InstantAppSdkException {
        this.myManifestFile = new File(instantAppSdk, "manifest.xml");
        if (!this.myManifestFile.exists() || !this.myManifestFile.isFile()) {
            throw new InstantAppSdkException("Manifest file " + this.myManifestFile.getAbsolutePath() + " does not exist.");
        }
        this.myApksDirectory = new File(new File(instantAppSdk, "tools"), "apks");
        if (!this.myApksDirectory.exists() || !this.myApksDirectory.isDirectory()) {
            throw new InstantAppSdkException("Apks folder " + this.myApksDirectory.getAbsolutePath() + " does not exist.");
        }
    }

    @VisibleForTesting
    static List<Metadata.GServicesOverride> parseGServicesOverrides(Element gServicesOverridesNode) {
        LinkedList<Metadata.GServicesOverride> gServicesOverrides = new LinkedList<Metadata.GServicesOverride>();
        NodeList gServicesOverrideNodes = gServicesOverridesNode.getElementsByTagName("gservicesOverride");
        for (int i2 = 0; i2 < gServicesOverrideNodes.getLength(); ++i2) {
            Metadata.GServicesOverride gServicesOverride = ManifestParser.parseGServicesOverride((Element)gServicesOverrideNodes.item(i2));
            gServicesOverrides.add(gServicesOverride);
        }
        return gServicesOverrides;
    }

    private static Set<Metadata.Device> parseEnabledDevices(Element enabledDevicesNode) {
        HashSet<Metadata.Device> enabledDevices = new HashSet<Metadata.Device>();
        NodeList enabledDeviceNodes = enabledDevicesNode.getElementsByTagName("device");
        for (int i2 = 0; i2 < enabledDeviceNodes.getLength(); ++i2) {
            Metadata.Device device = ManifestParser.parseDevice((Element)enabledDeviceNodes.item(i2));
            enabledDevices.add(device);
        }
        return enabledDevices;
    }

    @VisibleForTesting
    static Metadata.Device parseDevice(Element deviceNode) {
        String manufacturer = deviceNode.getElementsByTagName("manufacturer").getLength() > 0 ? deviceNode.getElementsByTagName("manufacturer").item(0).getTextContent() : null;
        String androidDevice = deviceNode.getElementsByTagName("androidDevice").getLength() > 0 ? deviceNode.getElementsByTagName("androidDevice").item(0).getTextContent() : null;
        String product = deviceNode.getElementsByTagName("product").getLength() > 0 ? deviceNode.getElementsByTagName("product").item(0).getTextContent() : null;
        String hardware = deviceNode.getElementsByTagName("hardware").getLength() > 0 ? deviceNode.getElementsByTagName("hardware").item(0).getTextContent() : null;
        HashSet<Integer> apiLevelsSet = new HashSet<Integer>();
        NodeList sdkIntNodes = deviceNode.getElementsByTagName("sdkInt");
        for (int i2 = 0; i2 < sdkIntNodes.getLength(); ++i2) {
            String sdkIntString = sdkIntNodes.item(i2).getTextContent();
            int sdkInt = Integer.parseInt(sdkIntString);
            apiLevelsSet.add(sdkInt);
        }
        return new Metadata.Device(manufacturer, androidDevice, apiLevelsSet, product, hardware);
    }

    @VisibleForTesting
    static Metadata.GServicesOverride parseGServicesOverride(Element gServicesOverrideNode) {
        String key = gServicesOverrideNode.getElementsByTagName("key").item(0).getTextContent();
        String value = gServicesOverrideNode.getElementsByTagName("value").item(0).getTextContent();
        HashSet<Metadata.Device> devices = new HashSet<Metadata.Device>();
        NodeList deviceNodes = gServicesOverrideNode.getElementsByTagName("device");
        for (int i2 = 0; i2 < deviceNodes.getLength(); ++i2) {
            Metadata.Device device = ManifestParser.parseDevice((Element)deviceNodes.item(i2));
            devices.add(device);
        }
        return new Metadata.GServicesOverride(devices, key, value);
    }

    public Metadata getMetadata() throws InstantAppSdkException {
        try {
            Element manifest = (Element)DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.myManifestFile).getElementsByTagName("manifest").item(0);
            return this.parseManifest(manifest);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new InstantAppSdkException("Manifest file is corrupted.", e);
        }
        catch (RuntimeException e) {
            throw new InstantAppSdkException("Manifest file is not in the expected format.", e);
        }
    }

    private Metadata parseManifest(Element manifestNode) {
        String versionCodeString = manifestNode.getElementsByTagName("versionCode").item(0).getTextContent();
        long versionCode = Long.parseLong(versionCodeString);
        String versionName = manifestNode.getElementsByTagName("versionName").item(0).getTextContent();
        Map<Metadata.Arch, List<Metadata.ApkInfo>> apks = this.parseApks((Element)manifestNode.getElementsByTagName("apks").item(0));
        Set<Metadata.Device> enabledDevices = ManifestParser.parseEnabledDevices((Element)manifestNode.getElementsByTagName("enabledDevices").item(0));
        List<Metadata.GServicesOverride> gServicesOverrides = ManifestParser.parseGServicesOverrides((Element)manifestNode.getElementsByTagName("gservicesOverrides").item(0));
        Metadata.LibraryCompatibility libraryCompatibility = this.parseLibraryCompatibility((Element)manifestNode.getElementsByTagName("libraryCompatibility").item(0));
        return new Metadata(versionCode, versionName, apks, enabledDevices, gServicesOverrides, libraryCompatibility);
    }

    private Map<Metadata.Arch, List<Metadata.ApkInfo>> parseApks(Element apksNode) {
        EnumMap<Metadata.Arch, List<Metadata.ApkInfo>> apks = new EnumMap<Metadata.Arch, List<Metadata.ApkInfo>>(Metadata.Arch.class);
        NodeList apkNodes = apksNode.getElementsByTagName("apkVersionInfo");
        for (int i2 = 0; i2 < apkNodes.getLength(); ++i2) {
            Metadata.ApkInfo apkInfo = this.parseApkVersionInfo((Element)apkNodes.item(i2));
            if (!apks.containsKey((Object)apkInfo.getArch())) {
                apks.put(apkInfo.getArch(), new LinkedList());
            }
            ((List)apks.get((Object)apkInfo.getArch())).add(apkInfo);
        }
        return apks;
    }

    @VisibleForTesting
    Metadata.ApkInfo parseApkVersionInfo(Element apkVersionInfoNode) {
        String path = apkVersionInfoNode.getElementsByTagName("path").item(0).getTextContent();
        File apkFile = new File(this.myApksDirectory, path.replace("/", File.separator));
        String pkgName = apkVersionInfoNode.getElementsByTagName("packageName").item(0).getTextContent();
        NodeList archNodes = apkVersionInfoNode.getElementsByTagName("arch");
        String archName = archNodes.getLength() == 0 ? "default" : archNodes.item(0).getTextContent();
        Metadata.Arch arch = Metadata.Arch.create(archName);
        String versionCodeString = apkVersionInfoNode.getElementsByTagName("versionCode").item(0).getTextContent();
        HashSet<Integer> apiLevelsSet = new HashSet<Integer>();
        NodeList sdkIntsNodes = apkVersionInfoNode.getElementsByTagName("sdkInt");
        if (sdkIntsNodes.getLength() > 0) {
            NodeList sdkIntNodes = ((Element)sdkIntsNodes.item(0)).getElementsByTagName("sdkInt");
            for (int i2 = 0; i2 < sdkIntNodes.getLength(); ++i2) {
                String sdkIntString = sdkIntNodes.item(i2).getTextContent();
                int sdkInt = Integer.parseInt(sdkIntString);
                apiLevelsSet.add(sdkInt);
            }
        }
        long versionCode = Long.parseLong(versionCodeString);
        return new Metadata.ApkInfo(pkgName, apkFile, arch, apiLevelsSet, versionCode);
    }

    @VisibleForTesting
    Metadata.LibraryCompatibility parseLibraryCompatibility(Element libraryCompatibilityNode) {
        String aiaCompatApiMinVersionString = libraryCompatibilityNode.getElementsByTagName("aiaCompatApiMinVersion").item(0).getTextContent();
        long aiaCompatApiMinVersion = Long.parseLong(aiaCompatApiMinVersionString);
        return new Metadata.LibraryCompatibility(aiaCompatApiMinVersion);
    }
}

