/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.ide.common.build.BaselineProfileDetails;
import com.android.ide.common.build.CommonBuiltArtifacts;
import com.android.utils.PathUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u0003*\u0004\b\u0002\u0010\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0011\u001a\u00028\u00012\u0006\u0010\u0012\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00020\u00152\u0006\u0010\u0012\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0012\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010&J_\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00028\u00012\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00020\u001b2\b\u0010-\u001a\u0004\u0018\u00010\u00182\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\b\u0010/\u001a\u0004\u0018\u00010\u001fH&\u00a2\u0006\u0002\u00100J\u0013\u00101\u001a\u00028\u00002\u0006\u00102\u001a\u000203\u00a2\u0006\u0002\u00104R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u00065"}, d2={"Lcom/android/ide/common/build/CommonBuiltArtifactsTypeAdapter;", "T", "Lcom/android/ide/common/build/CommonBuiltArtifacts;", "ArtifactTypeT", "ElementT", "Lcom/google/gson/TypeAdapter;", "projectPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getProjectPath", "()Ljava/nio/file/Path;", "artifactTypeTypeAdapter", "getArtifactTypeTypeAdapter", "()Lcom/google/gson/TypeAdapter;", "elementTypeAdapter", "getElementTypeAdapter", "getArtifactType", "artifacts", "(Lcom/android/ide/common/build/CommonBuiltArtifacts;)Ljava/lang/Object;", "getElements", "", "(Lcom/android/ide/common/build/CommonBuiltArtifacts;)Ljava/util/Collection;", "getElementType", "", "(Lcom/android/ide/common/build/CommonBuiltArtifacts;)Ljava/lang/String;", "getBaselineProfiles", "", "Lcom/android/ide/common/build/BaselineProfileDetails;", "(Lcom/android/ide/common/build/CommonBuiltArtifacts;)Ljava/util/List;", "getMinSdkVersionForDexing", "", "(Lcom/android/ide/common/build/CommonBuiltArtifacts;)Ljava/lang/Integer;", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "(Lcom/google/gson/stream/JsonWriter;Lcom/android/ide/common/build/CommonBuiltArtifacts;)V", "instantiate", "version", "artifactType", "applicationId", "variantName", "elements", "elementType", "baselineProfiles", "minSdkVersionForDexing", "(ILjava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/util/List;Ljava/lang/Integer;)Lcom/android/ide/common/build/CommonBuiltArtifacts;", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "(Lcom/google/gson/stream/JsonReader;)Lcom/android/ide/common/build/CommonBuiltArtifacts;", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nGenericBuiltArtifactsTypeAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericBuiltArtifactsTypeAdapter.kt\ncom/android/ide/common/build/CommonBuiltArtifactsTypeAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n1863#2:245\n1863#2,2:246\n1864#2:248\n1#3:249\n*S KotlinDebug\n*F\n+ 1 GenericBuiltArtifactsTypeAdapter.kt\ncom/android/ide/common/build/CommonBuiltArtifactsTypeAdapter\n*L\n66#1:245\n73#1:246,2\n66#1:248\n*E\n"})
public abstract class CommonBuiltArtifactsTypeAdapter<T extends CommonBuiltArtifacts, ArtifactTypeT, ElementT>
extends TypeAdapter<T> {
    @NotNull
    private final Path projectPath;

    public CommonBuiltArtifactsTypeAdapter(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.projectPath = projectPath;
    }

    @NotNull
    public final Path getProjectPath() {
        return this.projectPath;
    }

    @NotNull
    public abstract TypeAdapter<ArtifactTypeT> getArtifactTypeTypeAdapter();

    @NotNull
    public abstract TypeAdapter<ElementT> getElementTypeAdapter();

    public abstract ArtifactTypeT getArtifactType(@NotNull T var1);

    @NotNull
    public abstract Collection<ElementT> getElements(@NotNull T var1);

    @Nullable
    public abstract String getElementType(@NotNull T var1);

    @Nullable
    public abstract List<BaselineProfileDetails> getBaselineProfiles(@NotNull T var1);

    @Nullable
    public abstract Integer getMinSdkVersionForDexing(@NotNull T var1);

    public final void write(@NotNull JsonWriter out, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("version").value((Number)value.getVersion());
        out.name("artifactType");
        this.getArtifactTypeTypeAdapter().write(out, this.getArtifactType(value));
        out.name("applicationId").value(value.getApplicationId());
        out.name("variantName").value(value.getVariantName());
        out.name("elements").beginArray();
        for (ElementT element : this.getElements(value)) {
            this.getElementTypeAdapter().write(out, element);
        }
        out.endArray();
        String string = this.getElementType(value);
        if (string != null) {
            String elementType = string;
            boolean bl = false;
            out.name("elementType").value(elementType);
        }
        List<BaselineProfileDetails> baselineProfiles = this.getBaselineProfiles(value);
        if (baselineProfiles != null) {
            out.name("baselineProfiles").beginArray();
            Iterable $this$forEach$iv = baselineProfiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BaselineProfileDetails entry = (BaselineProfileDetails)element$iv;
                boolean bl = false;
                out.beginObject();
                out.name("minApi").value((Number)entry.getMinApi());
                out.name("maxApi").value((Number)entry.getMaxApi());
                out.name("baselineProfiles").beginArray();
                Iterable $this$forEach$iv2 = entry.getBaselineProfileFiles();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    Path relativePath = this.projectPath.relativize(it.toPath());
                    out.value(PathUtils.toSystemIndependentPath((Path)relativePath));
                }
                out.endArray();
                out.endObject();
            }
            out.endArray();
        }
        Integer n = this.getMinSdkVersionForDexing(value);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            out.name("minSdkVersionForDexing").value((Number)it);
        }
        out.endObject();
    }

    @NotNull
    public abstract T instantiate(int var1, ArtifactTypeT var2, @NotNull String var3, @NotNull String var4, @NotNull List<? extends ElementT> var5, @Nullable String var6, @Nullable List<BaselineProfileDetails> var7, @Nullable Integer var8);

    @NotNull
    public final T read(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        reader.beginObject();
        Integer version = null;
        Object artifactType = null;
        String applicationId = null;
        String variantName = null;
        List elements = new ArrayList();
        String elementType = null;
        List baselineProfiles = null;
        Integer minSdkVersionForDexing = null;
        block30: while (reader.hasNext()) {
            block52: {
                String string = reader.nextName();
                if (string == null) break block52;
                int n = -1;
                switch (string.hashCode()) {
                    case -672214996: {
                        if (string.equals("artifactType")) {
                            n = 1;
                        }
                        break;
                    }
                    case 1743213892: {
                        if (string.equals("minSdkVersionForDexing")) {
                            n = 2;
                        }
                        break;
                    }
                    case -8339209: {
                        if (string.equals("elements")) {
                            n = 3;
                        }
                        break;
                    }
                    case -2051546801: {
                        if (string.equals("baselineProfiles")) {
                            n = 4;
                        }
                        break;
                    }
                    case -1011352949: {
                        if (string.equals("applicationId")) {
                            n = 5;
                        }
                        break;
                    }
                    case -1601424208: {
                        if (string.equals("variantName")) {
                            n = 6;
                        }
                        break;
                    }
                    case 351608024: {
                        if (string.equals("version")) {
                            n = 7;
                        }
                        break;
                    }
                    case 673924182: {
                        if (string.equals("elementType")) {
                            n = 8;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 7: {
                        version = reader.nextInt();
                        continue block30;
                    }
                    case 1: {
                        artifactType = this.getArtifactTypeTypeAdapter().read(reader);
                        continue block30;
                    }
                    case 5: {
                        applicationId = reader.nextString();
                        continue block30;
                    }
                    case 6: {
                        variantName = reader.nextString();
                        continue block30;
                    }
                    case 3: {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            elements.add(this.getElementTypeAdapter().read(reader));
                        }
                        reader.endArray();
                        continue block30;
                    }
                    case 8: {
                        elementType = reader.nextString();
                        continue block30;
                    }
                    case 4: {
                        baselineProfiles = new ArrayList();
                        reader.beginArray();
                        while (reader.hasNext()) {
                            reader.beginObject();
                            Integer minApi = null;
                            Integer maxApi = null;
                            Set baselineProfileFiles = new LinkedHashSet();
                            while (reader.hasNext()) {
                                String attributeName = reader.nextName();
                                if (attributeName == null) continue;
                                tmp = -1;
                                switch (attributeName.hashCode()) {
                                    case -1074077080: {
                                        if (attributeName.equals("minApi")) {
                                            tmp = 1;
                                        }
                                        break;
                                    }
                                    case -1081167338: {
                                        if (attributeName.equals("maxApi")) {
                                            tmp = 2;
                                        }
                                        break;
                                    }
                                    case -2051546801: {
                                        if (attributeName.equals("baselineProfiles")) {
                                            tmp = 3;
                                        }
                                        break;
                                    }
                                }
                                switch (tmp) {
                                    case 1: {
                                        minApi = reader.nextInt();
                                        break;
                                    }
                                    case 2: {
                                        maxApi = reader.nextInt();
                                        break;
                                    }
                                    case 3: {
                                        reader.beginArray();
                                        while (reader.hasNext()) {
                                            File baselineProfileFile = this.projectPath.resolve(reader.nextString()).normalize().toFile();
                                            Intrinsics.checkNotNull((Object)baselineProfileFile);
                                            baselineProfileFiles.add(baselineProfileFile);
                                        }
                                        reader.endArray();
                                    }
                                }
                            }
                            reader.endObject();
                            Integer n2 = minApi;
                            if (n2 == null) {
                                throw new IllegalStateException("minApi is required".toString());
                            }
                            Integer n3 = maxApi;
                            if (n3 == null) {
                                throw new IllegalStateException("maxApi is required".toString());
                            }
                            baselineProfiles.add(new BaselineProfileDetails(n2, n3, baselineProfileFiles));
                        }
                        reader.endArray();
                        continue block30;
                    }
                    case 2: {
                        minSdkVersionForDexing = reader.nextInt();
                        continue block30;
                    }
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        Integer n = version;
        if (n == null) {
            throw new IOException("version is required");
        }
        Object object = artifactType;
        if (object == null) {
            throw new IOException("artifactType is required");
        }
        String string = applicationId;
        if (string == null) {
            throw new IOException("applicationId is required");
        }
        String string2 = variantName;
        if (string2 == null) {
            throw new IOException("variantName is required");
        }
        return this.instantiate(n, object, string, string2, elements, elementType, baselineProfiles, minSdkVersionForDexing);
    }
}

