/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.gradle.VersionRange;
import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.ide.common.repository.NetworkCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 92\u00020\u0001:\u0003789B3\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\rJ*\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\bJ,\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0016H\u0002J.\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\b2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u0019H\u0002J*\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u00192\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b\u0018\u00010\u0019H\u0002J2\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\bJ:\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0016\b\u0002\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b\u0018\u00010\u00192\b\b\u0002\u0010\u0017\u001a\u00020\bJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\u001f2\u0006\u0010\u0010\u001a\u00020\rJ\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rJ$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\"2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0016J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001fJ$\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140&2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0012J,\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140&2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\rJ\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0018\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\u000eR\u00020\u00000-H\u0014JF\u0010.\u001a\u00020/\"\f\b\u0000\u00100*\u00060\u000eR\u00020\u00002\u0006\u00101\u001a\u0002022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H00\f2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H00\u0019H\u0004J\u0012\u00105\u001a\u0004\u0018\u0001022\u0006\u00106\u001a\u00020\rH\u0014R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\u000eR\u00020\u0000\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository;", "Lcom/android/ide/common/repository/NetworkCache;", "cacheDir", "Ljava/nio/file/Path;", "networkTimeoutMs", "", "cacheExpiryHours", "useNetwork", "", "<init>", "(Ljava/nio/file/Path;IIZ)V", "packageMap", "", "", "Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "hasGroupId", "groupId", "findVersion", "Lcom/android/ide/common/gradle/Version;", "dependency", "Lcom/android/ide/common/gradle/Dependency;", "predicate", "Ljava/util/function/Predicate;", "allowPreview", "getDependencyFilter", "Lkotlin/Function1;", "handleWorkManager", "filter", "getSnapshotVersionFilter", "artifactId", "getGroups", "", "getArtifacts", "getVersions", "Lkotlin/sequences/Sequence;", "getAgpVersions", "Lcom/android/ide/common/repository/AgpVersion;", "findCompileDependencies", "", "version", "findDependencies", "requiredScope", "findArtifact", "Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "getPackageMap", "", "readMasterIndex", "", "T", "stream", "Ljava/io/InputStream;", "map", "factory", "readDefaultData", "relative", "ArtifactInfo", "PackageInfo", "Companion", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nGoogleMavenRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleMavenRepository.kt\ncom/android/ide/common/repository/GoogleMavenRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,426:1\n1#2:427\n*E\n"})
public abstract class GoogleMavenRepository
extends NetworkCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<String, PackageInfo> packageMap;
    @NotNull
    public static final String MAVEN_GOOGLE_CACHE_DIR_KEY = "maven.google";

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours, boolean useNetwork) {
        super(GoogleMavenRepositoryKt.GMAVEN_BASE_URL, cacheDir, networkTimeoutMs, cacheExpiryHours, useNetwork);
    }

    public /* synthetic */ GoogleMavenRepository(Path path, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            path = null;
        }
        if ((n3 & 2) != 0) {
            n = 3000;
        }
        if ((n3 & 4) != 0) {
            n2 = (int)TimeUnit.DAYS.toHours(1L);
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        this(path, n, n2, bl);
    }

    public final boolean hasGroupId(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.getPackageMap().get(groupId) != null;
    }

    @Nullable
    public final Version findVersion(@NotNull Dependency dependency, @Nullable Predicate<Version> predicate, boolean allowPreview) {
        Version version;
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Function1<Version, Boolean> filter2 = this.getDependencyFilter(dependency, predicate);
        String string = dependency.getGroup();
        if (string == null) {
            return null;
        }
        String group = string;
        if (Intrinsics.areEqual((Object)group, (Object)"androidx.work") && (version = this.handleWorkManager(dependency, allowPreview, filter2)) != null) {
            Version it = version;
            boolean bl = false;
            return it;
        }
        return this.findVersion(group, dependency.getName(), filter2, allowPreview);
    }

    public static /* synthetic */ Version findVersion$default(GoogleMavenRepository googleMavenRepository, Dependency dependency, Predicate predicate, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(dependency, predicate, bl);
    }

    private final Function1<Version, Boolean> getDependencyFilter(Dependency dependency, Predicate<Version> predicate) {
        Function1 filter2 = dependency.getHasExplicitDistinctUpperBound() ? (Function1)new Function1<Version, Boolean>(dependency, predicate){
            final /* synthetic */ Dependency $dependency;
            final /* synthetic */ Predicate<Version> $predicate;
            {
                this.$dependency = $dependency;
                this.$predicate = $predicate;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(Version v) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                if (GoogleMavenRepository.access$getDependencyFilter$predicate(this.$predicate, v)) {
                    RichVersion richVersion = this.$dependency.getVersion();
                    if (richVersion != null ? richVersion.contains(v) : true) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        } : (Function1)new Function1<Version, Boolean>(dependency, predicate){
            final /* synthetic */ Dependency $dependency;
            final /* synthetic */ Predicate<Version> $predicate;
            {
                this.$dependency = $dependency;
                this.$predicate = $predicate;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(Version v) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                if (GoogleMavenRepository.access$getDependencyFilter$predicate(this.$predicate, v)) {
                    RichVersion richVersion = this.$dependency.getVersion();
                    if (richVersion != null ? richVersion.accepts(v) : true) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        return this.getSnapshotVersionFilter((Function1<? super Version, Boolean>)filter2);
    }

    private final Version handleWorkManager(Dependency dependency, boolean allowPreview, Function1<? super Version, Boolean> filter2) {
        Range range = Range.closedOpen((Comparable)Version.Companion.parse("2.7"), (Comparable)Version.Companion.parse("2.7.0"));
        Intrinsics.checkNotNull((Object)range);
        VersionRange excludedRange = new VersionRange((Range<Version>)range);
        RichVersion richVersion = dependency.getVersion();
        boolean bl = richVersion != null ? richVersion.accepts(Version.Companion.prefixInfimum("2.7.0")) : false;
        if (bl) {
            ArtifactInfo artifactInfo = this.findArtifact("androidx.work", dependency.getName());
            if (artifactInfo == null) {
                return null;
            }
            ArtifactInfo artifactInfo2 = artifactInfo;
            Function1<Version, Boolean> snapshotFilter = this.getSnapshotVersionFilter(null);
            Version version = (Version)SequencesKt.maxOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter(artifactInfo2.getVersions(), (Function1)((Function1)new Function1<Version, Boolean>(excludedRange, filter2){
                final /* synthetic */ VersionRange $excludedRange;
                final /* synthetic */ Function1<Version, Boolean> $filter;
                {
                    this.$excludedRange = $excludedRange;
                    this.$filter = $filter;
                    super(1);
                }

                public final Boolean invoke(Version v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return !this.$excludedRange.contains(v) && (Boolean)this.$filter.invoke((Object)v) != false;
                }
            })), (Function1)((Function1)new Function1<Version, Boolean>(allowPreview){
                final /* synthetic */ boolean $allowPreview;
                {
                    this.$allowPreview = $allowPreview;
                    super(1);
                }

                public final Boolean invoke(Version it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$allowPreview || !it.isPreview();
                }
            })), (Function1)((Function1)new Function1<Version, Boolean>(snapshotFilter){
                final /* synthetic */ Function1<Version, Boolean> $snapshotFilter;
                {
                    this.$snapshotFilter = $snapshotFilter;
                    super(1);
                }

                public final Boolean invoke(Version it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (Boolean)this.$snapshotFilter.invoke((Object)it);
                }
            })));
            if (version != null) {
                Version it = version;
                boolean bl2 = false;
                return it;
            }
        }
        return null;
    }

    private final Function1<Version, Boolean> getSnapshotVersionFilter(Function1<? super Version, Boolean> filter2) {
        return (Function1)new Function1<Version, Boolean>(filter2){
            final /* synthetic */ Function1<Version, Boolean> $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            public final Boolean invoke(Version candidate) {
                Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
                return !candidate.isSnapshot() && (this.$filter == null || (Boolean)this.$filter.invoke((Object)candidate) != false);
            }
        };
    }

    @Nullable
    public final Version findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<Version> filter2, boolean allowPreview) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        return this.findVersion(groupId, artifactId, (Function1<? super Version, Boolean>)((Function1)new Function1<Version, Boolean>(filter2){
            final /* synthetic */ Predicate<Version> $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            public final Boolean invoke(Version it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Predicate<Version> predicate = this.$filter;
                return !(predicate != null ? !predicate.test(it) : false);
            }
        }), allowPreview);
    }

    public static /* synthetic */ Version findVersion$default(GoogleMavenRepository googleMavenRepository, String string, String string2, Predicate predicate, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(string, string2, predicate, bl);
    }

    @Nullable
    public final Version findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Function1<? super Version, Boolean> filter2, boolean allowPreview) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        ArtifactInfo artifactInfo = this.findArtifact(groupId, artifactId);
        if (artifactInfo == null) {
            return null;
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return artifactInfo2.findVersion(filter2, allowPreview);
    }

    public static /* synthetic */ Version findVersion$default(GoogleMavenRepository googleMavenRepository, String string, String string2, Function1 function1, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(string, string2, (Function1<? super Version, Boolean>)function1, bl);
    }

    @NotNull
    public final Set<String> getGroups() {
        return CollectionsKt.toSet((Iterable)this.getPackageMap().keySet());
    }

    @NotNull
    public final Set<String> getArtifacts(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        Set set = packageInfo != null ? packageInfo.artifacts() : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<Version> getVersions(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        ArtifactInfo artifactInfo = this.findArtifact(groupId, artifactId);
        if (artifactInfo == null) {
            return SetsKt.emptySet();
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return SequencesKt.toSet(artifactInfo2.getVersions());
    }

    @NotNull
    public final Sequence<Version> getVersions(@NotNull Dependency dependency, @Nullable Predicate<Version> predicate) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        String string = dependency.getGroup();
        if (string == null) {
            return SequencesKt.emptySequence();
        }
        String groupId = string;
        ArtifactInfo artifactInfo = this.findArtifact(groupId, dependency.getName());
        if (artifactInfo == null) {
            return SequencesKt.emptySequence();
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        Function1<Version, Boolean> filter2 = this.getDependencyFilter(dependency, predicate);
        return SequencesKt.filter(artifactInfo2.getVersions(), (Function1)((Function1)new Function1<Version, Boolean>(filter2){
            final /* synthetic */ Function1<Version, Boolean> $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            public final Boolean invoke(Version it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$filter.invoke((Object)it);
            }
        }));
    }

    @NotNull
    public final Set<AgpVersion> getAgpVersions() {
        ArtifactInfo artifactInfo = this.findArtifact("com.android.tools.build", "gradle");
        if (artifactInfo == null) {
            return SetsKt.emptySet();
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return SequencesKt.toSet(artifactInfo2.getAgpVersions());
    }

    @NotNull
    public final List<Dependency> findCompileDependencies(@NotNull String groupId, @NotNull String artifactId, @NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.findDependencies(groupId, artifactId, version, "compile");
    }

    @NotNull
    public final List<Dependency> findDependencies(@NotNull String groupId, @NotNull String artifactId, @NotNull Version version, @NotNull String requiredScope) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)requiredScope, (String)"requiredScope");
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        if (packageInfo == null) {
            return CollectionsKt.emptyList();
        }
        PackageInfo packageInfo2 = packageInfo;
        ArtifactInfo artifactInfo = packageInfo2.findArtifact(artifactId);
        Object object = artifactInfo;
        if (object == null || (object = ((ArtifactInfo)object).findDependencies(version, packageInfo2, requiredScope)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final ArtifactInfo findArtifact(String groupId, String artifactId) {
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        if (packageInfo == null) {
            return null;
        }
        PackageInfo packageInfo2 = packageInfo;
        return packageInfo2.findArtifact(artifactId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, PackageInfo> getPackageMap() {
        if (this.packageMap == null) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)28);
            InputStream inputStream = NetworkCache.findData$default(this, "master-index.xml", false, 2, null);
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)map);
                    this.readMasterIndex(it, map, (Function1)new Function1<String, PackageInfo>(this){
                        final /* synthetic */ GoogleMavenRepository this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final PackageInfo invoke(String tag) {
                            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                            return this.this$0.new PackageInfo(tag);
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            this.packageMap = map;
        }
        Map<String, PackageInfo> map = this.packageMap;
        Intrinsics.checkNotNull(map);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T extends PackageInfo> void readMasterIndex(@NotNull InputStream stream, @NotNull Map<String, T> map, @NotNull Function1<? super String, ? extends T> factory) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        try {
            Closeable closeable = stream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                KXmlParser parser = new KXmlParser();
                parser.setInput(it, "UTF-8");
                while (parser.next() != 1) {
                    int eventType = parser.getEventType();
                    if (eventType == 3 && parser.getDepth() > 1) {
                        String tag = parser.getName();
                        Intrinsics.checkNotNull((Object)tag);
                        PackageInfo packageInfo = (PackageInfo)factory.invoke((Object)tag);
                        map.put(tag, packageInfo);
                        continue;
                    }
                    if (eventType == 2) continue;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        catch (IOException e) {
            this.error(e, null);
        }
    }

    @Override
    @Nullable
    protected InputStream readDefaultData(@NotNull String relative) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        return GoogleMavenRepository.class.getResourceAsStream("/versions-offline/" + relative);
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours) {
        this(cacheDir, networkTimeoutMs, cacheExpiryHours, false, 8, null);
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs) {
        this(cacheDir, networkTimeoutMs, 0, false, 12, null);
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir) {
        this(cacheDir, 0, 0, false, 14, null);
    }

    @JvmOverloads
    public GoogleMavenRepository() {
        this(null, 0, 0, false, 15, null);
    }

    private static final boolean getDependencyFilter$predicate(Predicate<Version> $predicate, Version version) {
        Predicate<Version> predicate = $predicate;
        return predicate != null ? predicate.test(version) : true;
    }

    public static final /* synthetic */ boolean access$getDependencyFilter$predicate(Predicate $predicate, Version version) {
        return GoogleMavenRepository.getDependencyFilter$predicate($predicate, version);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\f0\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013J(\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u0019J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\f2\n\u0010\u001d\u001a\u00060\u001eR\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u0003J*\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\f2\n\u0010\u001d\u001a\u00060\u001eR\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0002J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00192\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR-\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "", "id", "", "versions", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getVersions", "dependencyInfo", "Ljava/util/HashMap;", "Lcom/android/ide/common/gradle/Version;", "", "Lcom/android/ide/common/gradle/Dependency;", "getDependencyInfo", "()Ljava/util/HashMap;", "dependencyInfo$delegate", "Lkotlin/Lazy;", "Lkotlin/sequences/Sequence;", "getAgpVersions", "Lcom/android/ide/common/repository/AgpVersion;", "findVersion", "filter", "Lkotlin/Function1;", "", "allowPreview", "findDependencies", "version", "packageInfo", "Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "requiredScope", "loadDependencies", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "sdk-common"})
    protected static final class ArtifactInfo {
        @NotNull
        private final String id;
        @NotNull
        private final String versions;
        @NotNull
        private final Lazy dependencyInfo$delegate;

        public ArtifactInfo(@NotNull String id, @NotNull String versions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)versions, (String)"versions");
            this.id = id;
            this.versions = versions;
            this.dependencyInfo$delegate = LazyKt.lazy((Function0)dependencyInfo.2.INSTANCE);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getVersions() {
            return this.versions;
        }

        private final HashMap<Version, List<Dependency>> getDependencyInfo() {
            Lazy lazy = this.dependencyInfo$delegate;
            return (HashMap)lazy.getValue();
        }

        @NotNull
        public final Sequence<Version> getVersions() {
            String[] stringArray = new String[]{","};
            return SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)this.versions, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Function1)getVersions.1.INSTANCE);
        }

        @NotNull
        public final Sequence<AgpVersion> getAgpVersions() {
            String[] stringArray = new String[]{","};
            return SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)this.versions, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Function1)getAgpVersions.1.INSTANCE));
        }

        @Nullable
        public final Version findVersion(@Nullable Function1<? super Version, Boolean> filter2, boolean allowPreview) {
            return (Version)SequencesKt.maxOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter(this.getVersions(), (Function1)((Function1)new Function1<Version, Boolean>(filter2){
                final /* synthetic */ Function1<Version, Boolean> $filter;
                {
                    this.$filter = $filter;
                    super(1);
                }

                public final Boolean invoke(Version it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$filter == null || (Boolean)this.$filter.invoke((Object)it) != false;
                }
            })), (Function1)((Function1)new Function1<Version, Boolean>(allowPreview){
                final /* synthetic */ boolean $allowPreview;
                {
                    this.$allowPreview = $allowPreview;
                    super(1);
                }

                public final Boolean invoke(Version it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$allowPreview || !it.isPreview();
                }
            })));
        }

        public static /* synthetic */ Version findVersion$default(ArtifactInfo artifactInfo, Function1 function1, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return artifactInfo.findVersion((Function1<? super Version, Boolean>)function1, bl);
        }

        @NotNull
        public final List<Dependency> findDependencies(@NotNull Version version, @NotNull PackageInfo packageInfo, @NotNull String requiredScope) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)packageInfo, (String)"packageInfo");
            Intrinsics.checkNotNullParameter((Object)requiredScope, (String)"requiredScope");
            List<Dependency> list = this.getDependencyInfo().get(version);
            if (list == null) {
                list = this.loadDependencies(version, packageInfo, requiredScope);
            }
            return list;
        }

        public static /* synthetic */ List findDependencies$default(ArtifactInfo artifactInfo, Version version, PackageInfo packageInfo, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = "compile";
            }
            return artifactInfo.findDependencies(version, packageInfo, string);
        }

        private final List<Dependency> loadDependencies(Version version, PackageInfo packageInfo, String requiredScope) {
            if (this.findVersion((Function1<? super Version, Boolean>)((Function1)new Function1<Version, Boolean>(version){
                final /* synthetic */ Version $version;
                {
                    this.$version = $version;
                    super(1);
                }

                public final Boolean invoke(Version it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$version);
                }
            }), true) == null) {
                return CollectionsKt.emptyList();
            }
            List<Dependency> dependencies = packageInfo.loadDependencies(this.id, version, requiredScope);
            ((Map)this.getDependencyInfo()).put(version, dependencies);
            return dependencies;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.versions;
        }

        @NotNull
        public final ArtifactInfo copy(@NotNull String id, @NotNull String versions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)versions, (String)"versions");
            return new ArtifactInfo(id, versions);
        }

        public static /* synthetic */ ArtifactInfo copy$default(ArtifactInfo artifactInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = artifactInfo.id;
            }
            if ((n & 2) != 0) {
                string2 = artifactInfo.versions;
            }
            return artifactInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ArtifactInfo(id=" + this.id + ", versions=" + this.versions + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.versions.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArtifactInfo)) {
                return false;
            }
            ArtifactInfo artifactInfo = (ArtifactInfo)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)artifactInfo.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.versions, (Object)artifactInfo.versions);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$Companion;", "", "<init>", "()V", "MAVEN_GOOGLE_CACHE_DIR_KEY", "", "sdk-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\b\u0094\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0012H\u0004J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J(\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\"H\u0002J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "", "pkg", "", "<init>", "(Lcom/android/ide/common/repository/GoogleMavenRepository;Ljava/lang/String;)V", "artifacts", "", "Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "getArtifacts", "()Ljava/util/Map;", "artifacts$delegate", "Lkotlin/Lazy;", "readGroupData", "", "stream", "Ljava/io/InputStream;", "map", "", "", "findArtifact", "id", "loadDependencies", "", "Lcom/android/ide/common/gradle/Dependency;", "version", "Lcom/android/ide/common/gradle/Version;", "requiredScope", "readDependenciesFromPomFile", "file", "readDependency", "parser", "Lorg/kxml2/io/KXmlParser;", "boms", "", "check", "item", "name", "sdk-common"})
    @SourceDebugExtension(value={"SMAP\nGoogleMavenRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleMavenRepository.kt\ncom/android/ide/common/repository/GoogleMavenRepository$PackageInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,426:1\n1563#2:427\n1634#2,3:428\n295#2,2:432\n1#3:431\n*S KotlinDebug\n*F\n+ 1 GoogleMavenRepository.kt\ncom/android/ide/common/repository/GoogleMavenRepository$PackageInfo\n*L\n308#1:427\n308#1:428,3\n385#1:432,2\n*E\n"})
    protected class PackageInfo {
        @NotNull
        private final String pkg;
        @NotNull
        private final Lazy artifacts$delegate;

        public PackageInfo(String pkg) {
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            this.pkg = pkg;
            this.artifacts$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ArtifactInfo>>(GoogleMavenRepository.this, this){
                final /* synthetic */ GoogleMavenRepository this$0;
                final /* synthetic */ PackageInfo this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final Map<String, ArtifactInfo> invoke() {
                    InputStream stream;
                    Map map = new LinkedHashMap<K, V>();
                    InputStream inputStream = stream = NetworkCache.findData$default(this.this$0, StringsKt.replace$default((String)PackageInfo.access$getPkg$p(this.this$1), (char)'.', (char)'/', (boolean)false, (int)4, null) + "/group-index.xml", false, 2, null);
                    if (inputStream != null) {
                        Closeable closeable = inputStream;
                        PackageInfo packageInfo = this.this$1;
                        Throwable throwable = null;
                        try {
                            InputStream it = (InputStream)closeable;
                            boolean bl = false;
                            packageInfo.readGroupData(stream, map);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    return map;
                }
            }));
        }

        private final Map<String, ArtifactInfo> getArtifacts() {
            Lazy lazy = this.artifacts$delegate;
            return (Map)lazy.getValue();
        }

        protected final void readGroupData(@NotNull InputStream stream, @NotNull Map<String, ArtifactInfo> map) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            Intrinsics.checkNotNullParameter(map, (String)"map");
            try {
                KXmlParser parser = new KXmlParser();
                parser.setInput(stream, "UTF-8");
                while (parser.next() != 1) {
                    int eventType = parser.getEventType();
                    if (eventType != 2) continue;
                    String artifactId = parser.getName();
                    String versions = parser.getAttributeValue(null, "versions");
                    if (versions == null) continue;
                    Intrinsics.checkNotNull((Object)artifactId);
                    ArtifactInfo artifactInfo = new ArtifactInfo(artifactId, versions);
                    map.put(artifactId, artifactInfo);
                }
            }
            catch (XmlPullParserException parser) {
            }
            catch (Exception e) {
                GoogleMavenRepository.this.error(e, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Set<String> artifacts() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getArtifacts().values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ArtifactInfo artifactInfo = (ArtifactInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        @Nullable
        public ArtifactInfo findArtifact(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return this.getArtifacts().get(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<Dependency> loadDependencies(@NotNull String id, @NotNull Version version, @NotNull String requiredScope) {
            Object object;
            block9: {
                block8: {
                    List<Dependency> list;
                    Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                    Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                    Intrinsics.checkNotNullParameter((Object)requiredScope, (String)"requiredScope");
                    String file = StringsKt.replace$default((String)this.pkg, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + id + "/" + version + "/" + id + "-" + version + ".pom";
                    InputStream stream = NetworkCache.findData$default(GoogleMavenRepository.this, file, false, 2, null);
                    object = stream;
                    if (object == null) break block8;
                    Closeable closeable = (Closeable)object;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl = false;
                        List<Dependency> list2 = this.readDependenciesFromPomFile(stream, file, requiredScope);
                        list = list2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    object = list;
                    if (list != null) break block9;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        private final List<Dependency> readDependenciesFromPomFile(InputStream stream, String file, String requiredScope) {
            List list;
            try {
                List boms = new ArrayList();
                List dependencies = new ArrayList();
                KXmlParser parser = new KXmlParser();
                parser.setInput(stream, "UTF-8");
                while (parser.next() != 1) {
                    Dependency dependency;
                    String name;
                    int eventType = parser.getEventType();
                    if (eventType != 2 || !Intrinsics.areEqual((Object)(name = parser.getName()), (Object)"dependency") || (dependency = this.readDependency(parser, requiredScope, boms)) == null) continue;
                    dependencies.add(dependency);
                }
                list = dependencies;
            }
            catch (XmlPullParserException e) {
                list = CollectionsKt.emptyList();
            }
            catch (Exception e) {
                GoogleMavenRepository.this.error(e, "Problem reading POM file: " + file);
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final Dependency readDependency(KXmlParser parser, String requiredScope, List<Dependency> boms) {
            Object version;
            String artifactId;
            String groupId;
            block20: {
                Dependency bom;
                Object object;
                Object v3;
                block22: {
                    Iterator iterator;
                    block21: {
                        groupId = null;
                        groupId = "";
                        artifactId = null;
                        artifactId = "";
                        version = "";
                        String scope = "";
                        block16: while (parser.next() != 1) {
                            switch (parser.getEventType()) {
                                case 2: {
                                    String string;
                                    if (parser.getDepth() > 5 || (string = parser.getName()) == null) continue block16;
                                    int n = -1;
                                    switch (string.hashCode()) {
                                        case 293428218: {
                                            if (!string.equals("groupId")) break;
                                            n = 1;
                                            break;
                                        }
                                        case 109264468: {
                                            if (!string.equals("scope")) break;
                                            n = 2;
                                            break;
                                        }
                                        case 240640653: {
                                            if (!string.equals("artifactId")) break;
                                            n = 3;
                                            break;
                                        }
                                        case 351608024: {
                                            if (!string.equals("version")) break;
                                            n = 4;
                                            break;
                                        }
                                    }
                                    switch (n) {
                                        case 1: {
                                            groupId = parser.nextText();
                                            break;
                                        }
                                        case 3: {
                                            artifactId = parser.nextText();
                                            break;
                                        }
                                        case 4: {
                                            version = parser.nextText();
                                            break;
                                        }
                                        case 2: {
                                            scope = parser.nextText();
                                            break;
                                        }
                                    }
                                    continue block16;
                                }
                                case 3: {
                                    if (!Intrinsics.areEqual((Object)parser.getName(), (Object)"dependency")) continue block16;
                                    if (Intrinsics.areEqual((Object)scope, (Object)requiredScope)) {
                                        this.check(groupId, "groupId");
                                        this.check(artifactId, "artifactId");
                                        if (!(((CharSequence)version).length() == 0)) break block20;
                                        Iterable $this$firstOrNull$iv = boms;
                                        boolean $i$f$firstOrNull = false;
                                        iterator = $this$firstOrNull$iv.iterator();
                                        break block21;
                                    }
                                    if (parser.getDepth() != 4) return null;
                                    if (((CharSequence)groupId).length() <= 0) return null;
                                    boolean bl = true;
                                    if (!bl) return null;
                                    if (((CharSequence)artifactId).length() <= 0) return null;
                                    boolean bl2 = true;
                                    if (!bl2) return null;
                                    if (((CharSequence)version).length() <= 0) return null;
                                    boolean bl3 = true;
                                    if (!bl3) return null;
                                    boms.add(new Dependency(groupId, artifactId, RichVersion.Companion.parse((String)version), null, null, 24, null));
                                    return null;
                                }
                                default: {
                                    continue block16;
                                }
                            }
                        }
                        throw new RuntimeException("Unexpected end of file");
                    }
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        Dependency it = (Dependency)element$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getGroup(), (Object)groupId) && Intrinsics.areEqual((Object)it.getName(), (Object)artifactId))) continue;
                        v3 = element$iv;
                        break block22;
                    }
                    v3 = null;
                }
                if ((object = (bom = (Dependency)v3)) == null || (object = ((Dependency)object).getVersion()) == null || (object = ((RichVersion)object).getLowerBound()) == null || (object = ((Version)object).toString()) == null) {
                    object = "";
                }
                version = object;
            }
            this.check((String)version, "version");
            Dependency dependency = new Dependency(groupId, artifactId, RichVersion.Companion.parse((String)version), null, null, 24, null);
            return dependency;
        }

        private final void check(String item, String name) {
            if (((CharSequence)item).length() == 0) {
                throw new RuntimeException("Missing " + name + " field");
            }
        }

        public static final /* synthetic */ String access$getPkg$p(PackageInfo $this) {
            return $this.pkg;
        }
    }
}

