/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\b"}, d2={"Lcom/android/ide/common/util/Diffs;", "", "<init>", "()V", "Hunk", "LineType", "DiffLine", "Companion", "sdk-common"})
public final class Diffs {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J*\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J*\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J6\u0010\u0012\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00052\u0006\u0010\u0018\u001a\u00020\u0006\u00a8\u0006\u0019"}, d2={"Lcom/android/ide/common/util/Diffs$Companion;", "", "<init>", "()V", "splitWithLineSeparators", "", "", "diffLines", "Lcom/android/ide/common/util/Diffs$DiffLine;", "originalText", "newText", "originalLines", "newLines", "diff", "windowSize", "", "trimEnds", "", "formatHunks", "numTotalOriginalLines", "numTotalNewLines", "contextLines", "parseDiff", "Lcom/android/ide/common/util/Diffs$Hunk;", "diffText", "sdk-common"})
    @SourceDebugExtension(value={"SMAP\nDiffs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Diffs.kt\ncom/android/ide/common/util/Diffs$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,430:1\n1321#2,2:431\n1#3:433\n*S KotlinDebug\n*F\n+ 1 Diffs.kt\ncom/android/ide/common/util/Diffs$Companion\n*L\n74#1:431,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> splitWithLineSeparators(String $this$splitWithLineSeparators) {
            List list;
            if (((CharSequence)$this$splitWithLineSeparators).length() == 0) {
                return CollectionsKt.listOf((Object)$this$splitWithLineSeparators);
            }
            List $this$splitWithLineSeparators_u24lambda_u241 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            Regex lineSeparatorRegex = new Regex("\r\n|\n|\r");
            int lastEnd = 0;
            Sequence $this$forEach$iv = Regex.findAll$default((Regex)lineSeparatorRegex, (CharSequence)$this$splitWithLineSeparators, (int)0, (int)2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MatchResult matchResult = (MatchResult)element$iv;
                boolean bl2 = false;
                String string = $this$splitWithLineSeparators.substring(lastEnd, matchResult.getRange().getFirst());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$splitWithLineSeparators_u24lambda_u241.add(string + matchResult.getValue());
                lastEnd = matchResult.getRange().getLast() + 1;
            }
            if (lastEnd < $this$splitWithLineSeparators.length()) {
                String string = $this$splitWithLineSeparators.substring(lastEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$splitWithLineSeparators_u24lambda_u241.add(string);
            }
            if ($this$splitWithLineSeparators_u24lambda_u241.isEmpty() && ((CharSequence)$this$splitWithLineSeparators).length() > 0) {
                $this$splitWithLineSeparators_u24lambda_u241.add($this$splitWithLineSeparators);
            }
            return CollectionsKt.build((List)list);
        }

        @NotNull
        public final List<DiffLine> diffLines(@NotNull String originalText, @NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            List<String> originalLines = ((CharSequence)originalText).length() == 0 ? CollectionsKt.emptyList() : this.splitWithLineSeparators(originalText);
            List<String> newLines = ((CharSequence)newText).length() == 0 ? CollectionsKt.emptyList() : this.splitWithLineSeparators(newText);
            return this.diffLines(originalLines, newLines);
        }

        private final List<DiffLine> diffLines(List<String> originalLines, List<String> newLines) {
            int n;
            if (Intrinsics.areEqual(originalLines, newLines)) {
                return CollectionsKt.emptyList();
            }
            int n2 = 0;
            int n3 = originalLines.size() + 1;
            int[][] nArrayArray = new int[n3][];
            while (n2 < n3) {
                n = n2++;
                nArrayArray[n] = new int[newLines.size() + 1];
            }
            int[][] lcsMatrix = nArrayArray;
            n3 = ((Collection)originalLines).size();
            for (int i2 = 0; i2 < n3; ++i2) {
                n = ((Collection)newLines).size();
                for (int j = 0; j < n; ++j) {
                    lcsMatrix[i2 + 1][j + 1] = Intrinsics.areEqual((Object)originalLines.get(i2), (Object)newLines.get(j)) ? lcsMatrix[i2][j] + 1 : Math.max(lcsMatrix[i2 + 1][j], lcsMatrix[i2][j + 1]);
                }
            }
            List diffLines = new ArrayList();
            int i3 = originalLines.size();
            int j = newLines.size();
            while (true) {
                if (i3 <= 0) {
                    if (j <= 0) break;
                }
                if (i3 > 0 && j > 0 && Intrinsics.areEqual((Object)originalLines.get(i3 - 1), (Object)newLines.get(j - 1))) {
                    diffLines.add(new DiffLine(originalLines.get(i3 - 1), LineType.COMMON));
                    --i3;
                    --j;
                    continue;
                }
                if (j > 0 && (i3 == 0 || lcsMatrix[i3][j - 1] >= lcsMatrix[i3 - 1][j])) {
                    diffLines.add(new DiffLine(newLines.get(j - 1), LineType.ADDED));
                    --j;
                    continue;
                }
                if (j != 0 && lcsMatrix[i3][j - 1] >= lcsMatrix[i3 - 1][j]) break;
                diffLines.add(new DiffLine(originalLines.get(i3 - 1), LineType.REMOVED));
                --i3;
            }
            CollectionsKt.reverse((List)diffLines);
            return diffLines;
        }

        @NotNull
        public final String diff(@NotNull String originalText, @NotNull String newText, int windowSize, boolean trimEnds) {
            Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            List<String> originalLines = ((CharSequence)originalText).length() == 0 ? CollectionsKt.emptyList() : this.splitWithLineSeparators(originalText);
            List<String> newLines = ((CharSequence)newText).length() == 0 ? CollectionsKt.emptyList() : this.splitWithLineSeparators(newText);
            List<DiffLine> diffLines = this.diffLines(originalLines, newLines);
            if (diffLines.isEmpty()) {
                return "";
            }
            return this.formatHunks(diffLines, originalLines.size(), newLines.size(), windowSize, trimEnds);
        }

        public static /* synthetic */ String diff$default(Companion companion, String string, String string2, int n, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 3;
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            return companion.diff(string, string2, n, bl);
        }

        private final String formatHunks(List<DiffLine> diffLines, int numTotalOriginalLines, int numTotalNewLines, int contextLines, boolean trimEnds) {
            StringBuilder resultHunks = new StringBuilder();
            int overallProcessedIdx = 0;
            while (overallProcessedIdx < diffLines.size()) {
                Object object;
                Object object2;
                int displayNewStart;
                int firstChangeEndInHunk;
                int firstChangeStartInHunk;
                for (firstChangeStartInHunk = overallProcessedIdx; firstChangeStartInHunk < diffLines.size() && diffLines.get(firstChangeStartInHunk).getType() == LineType.COMMON; ++firstChangeStartInHunk) {
                }
                if (firstChangeStartInHunk == diffLines.size()) break;
                for (firstChangeEndInHunk = firstChangeStartInHunk; firstChangeEndInHunk < diffLines.size() && diffLines.get(firstChangeEndInHunk).getType() != LineType.COMMON; ++firstChangeEndInHunk) {
                }
                int currentHunkEffectiveStart = Math.max(0, firstChangeStartInHunk - contextLines);
                int currentHunkEffectiveEnd = Math.min(diffLines.size(), firstChangeEndInHunk + contextLines);
                int lastConsideredChangeEnd = firstChangeEndInHunk;
                while (true) {
                    int nextChangeBlockActualEnd;
                    int nextChangeBlockContextAllowedStart;
                    int nextChangeBlockActualStart;
                    for (nextChangeBlockActualStart = lastConsideredChangeEnd; nextChangeBlockActualStart < diffLines.size() && diffLines.get(nextChangeBlockActualStart).getType() == LineType.COMMON; ++nextChangeBlockActualStart) {
                    }
                    if (nextChangeBlockActualStart == diffLines.size() || currentHunkEffectiveEnd < (nextChangeBlockContextAllowedStart = nextChangeBlockActualStart - contextLines)) break;
                    for (nextChangeBlockActualEnd = nextChangeBlockActualStart; nextChangeBlockActualEnd < diffLines.size() && diffLines.get(nextChangeBlockActualEnd).getType() != LineType.COMMON; ++nextChangeBlockActualEnd) {
                    }
                    currentHunkEffectiveEnd = Math.min(diffLines.size(), nextChangeBlockActualEnd + contextLines);
                    lastConsideredChangeEnd = nextChangeBlockActualEnd;
                }
                int hunkOriginalFileStartLine = 1;
                int hunkNewFileStartLine = 1;
                block24: for (int k = 0; k < currentHunkEffectiveStart; ++k) {
                    switch (WhenMappings.$EnumSwitchMapping$0[diffLines.get(k).getType().ordinal()]) {
                        case 1: {
                            ++hunkOriginalFileStartLine;
                            ++hunkNewFileStartLine;
                            continue block24;
                        }
                        case 2: {
                            ++hunkOriginalFileStartLine;
                            continue block24;
                        }
                        case 3: {
                            ++hunkNewFileStartLine;
                            continue block24;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                StringBuilder hunkContent = new StringBuilder();
                int hunkOriginalNumEffectiveLines = 0;
                int hunkNewNumEffectiveLines = 0;
                int n = currentHunkEffectiveEnd;
                block25: for (int k = currentHunkEffectiveStart; k < n; ++k) {
                    DiffLine line = diffLines.get(k);
                    switch (WhenMappings.$EnumSwitchMapping$0[line.getType().ordinal()]) {
                        case 1: {
                            com.android.ide.common.util.Diffs$Companion.formatHunks$emitLine(hunkContent, trimEnds, ' ', line.getText());
                            ++hunkOriginalNumEffectiveLines;
                            ++hunkNewNumEffectiveLines;
                            continue block25;
                        }
                        case 2: {
                            com.android.ide.common.util.Diffs$Companion.formatHunks$emitLine(hunkContent, trimEnds, '-', line.getText());
                            ++hunkOriginalNumEffectiveLines;
                            continue block25;
                        }
                        case 3: {
                            com.android.ide.common.util.Diffs$Companion.formatHunks$emitLine(hunkContent, trimEnds, '+', line.getText());
                            ++hunkNewNumEffectiveLines;
                            continue block25;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                int displayOriginalStart = hunkOriginalNumEffectiveLines == 0 ? Math.max(0, hunkOriginalFileStartLine - 1) : hunkOriginalFileStartLine;
                int n2 = displayNewStart = hunkNewNumEffectiveLines == 0 ? Math.max(0, hunkNewFileStartLine - 1) : hunkNewFileStartLine;
                if (numTotalOriginalLines == 0 && hunkOriginalNumEffectiveLines == 0) {
                    displayOriginalStart = 0;
                }
                if (numTotalNewLines == 0 && hunkNewNumEffectiveLines == 0) {
                    displayNewStart = 0;
                }
                switch (hunkOriginalNumEffectiveLines) {
                    case 0: {
                        object2 = displayOriginalStart + ",0";
                        break;
                    }
                    case 1: {
                        object2 = String.valueOf(displayOriginalStart);
                        break;
                    }
                    default: {
                        object2 = displayOriginalStart + "," + hunkOriginalNumEffectiveLines;
                    }
                }
                Object originalRangeStr = object2;
                switch (hunkNewNumEffectiveLines) {
                    case 0: {
                        object = displayNewStart + ",0";
                        break;
                    }
                    case 1: {
                        object = String.valueOf(displayNewStart);
                        break;
                    }
                    default: {
                        object = displayNewStart + "," + hunkNewNumEffectiveLines;
                    }
                }
                Object newRangeStr = object;
                resultHunks.append("@@ -" + (String)originalRangeStr + " +" + (String)newRangeStr + " @@\n");
                resultHunks.append((CharSequence)hunkContent);
                overallProcessedIdx = currentHunkEffectiveEnd;
            }
            String string = resultHunks.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
        }

        @NotNull
        public final List<Hunk> parseDiff(@NotNull String diffText) {
            Intrinsics.checkNotNullParameter((Object)diffText, (String)"diffText");
            List hunks = new ArrayList();
            Regex hunkHeaderRegex = new Regex("^@@\\s*-(\\d+)(?:,(\\d+))?\\s*\\+(\\d+)(?:,(\\d+))?\\s*@@");
            List lines = StringsKt.lines((CharSequence)diffText);
            List currentHunkLines = new ArrayList();
            int originalStart = 0;
            int originalLength = 0;
            int newStart = 0;
            int newLength = 0;
            String currentHeader = "";
            for (String line : lines) {
                MatchResult matchResult = Regex.find$default((Regex)hunkHeaderRegex, (CharSequence)line, (int)0, (int)2, null);
                if (matchResult != null) {
                    CharSequence charSequence;
                    CharSequence charSequence2;
                    if (!((Collection)currentHunkLines).isEmpty()) {
                        hunks.add(new Hunk(originalStart, originalLength, newStart, newLength, currentHeader, CollectionsKt.joinToString$default((Iterable)currentHunkLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
                        currentHunkLines = new ArrayList();
                    }
                    currentHeader = line;
                    originalStart = Integer.parseInt((String)matchResult.getGroupValues().get(1));
                    CharSequence charSequence3 = (CharSequence)matchResult.getGroupValues().get(2);
                    if (charSequence3.length() == 0) {
                        boolean bl = false;
                        charSequence2 = "1";
                    } else {
                        charSequence2 = charSequence3;
                    }
                    originalLength = Integer.parseInt((String)charSequence2);
                    newStart = Integer.parseInt((String)matchResult.getGroupValues().get(3));
                    charSequence3 = (CharSequence)matchResult.getGroupValues().get(4);
                    if (charSequence3.length() == 0) {
                        boolean bl = false;
                        charSequence = "1";
                    } else {
                        charSequence = charSequence3;
                    }
                    newLength = Integer.parseInt((String)charSequence);
                    continue;
                }
                if (!(((CharSequence)currentHeader).length() > 0)) continue;
                currentHunkLines.add(line);
            }
            if (!((Collection)currentHunkLines).isEmpty() && ((CharSequence)currentHeader).length() > 0) {
                hunks.add(new Hunk(originalStart, originalLength, newStart, newLength, currentHeader, CollectionsKt.joinToString$default((Iterable)currentHunkLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
            }
            return hunks;
        }

        private static final void formatHunks$emitLine(StringBuilder hunkContent, boolean $trimEnds, char typeChar, String line) {
            StringBuilder stringBuilder;
            int lineEnds;
            for (lineEnds = line.length(); lineEnds > 0 && (line.charAt(lineEnds - 1) == '\n' || line.charAt(lineEnds - 1) == '\r'); --lineEnds) {
            }
            if (lineEnds == 0 && typeChar == ' ') {
                hunkContent.append('\n');
                return;
            }
            hunkContent.append(typeChar);
            if ($trimEnds) {
                stringBuilder = hunkContent.append(((Object)StringsKt.trimEnd((CharSequence)line)).toString()).append('\n');
            } else {
                String string = line.substring(0, lineEnds);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                stringBuilder = hunkContent.append(string).append('\n');
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LineType.values().length];
                try {
                    nArray[LineType.COMMON.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineType.REMOVED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineType.ADDED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/ide/common/util/Diffs$DiffLine;", "", "text", "", "type", "Lcom/android/ide/common/util/Diffs$LineType;", "<init>", "(Ljava/lang/String;Lcom/android/ide/common/util/Diffs$LineType;)V", "getText", "()Ljava/lang/String;", "getType", "()Lcom/android/ide/common/util/Diffs$LineType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "sdk-common"})
    public static final class DiffLine {
        @NotNull
        private final String text;
        @NotNull
        private final LineType type;

        public DiffLine(@NotNull String text, @NotNull LineType type) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.text = text;
            this.type = type;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final LineType getType() {
            return this.type;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final LineType component2() {
            return this.type;
        }

        @NotNull
        public final DiffLine copy(@NotNull String text, @NotNull LineType type) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new DiffLine(text, type);
        }

        public static /* synthetic */ DiffLine copy$default(DiffLine diffLine, String string, LineType lineType, int n, Object object) {
            if ((n & 1) != 0) {
                string = diffLine.text;
            }
            if ((n & 2) != 0) {
                lineType = diffLine.type;
            }
            return diffLine.copy(string, lineType);
        }

        @NotNull
        public String toString() {
            return "DiffLine(text=" + this.text + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiffLine)) {
                return false;
            }
            DiffLine diffLine = (DiffLine)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)diffLine.text)) {
                return false;
            }
            return this.type == diffLine.type;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/android/ide/common/util/Diffs$Hunk;", "", "originalFileStartLine", "", "originalFileLines", "newFileStartLine", "newFileLines", "header", "", "content", "<init>", "(IIIILjava/lang/String;Ljava/lang/String;)V", "getOriginalFileStartLine", "()I", "getOriginalFileLines", "getNewFileStartLine", "getNewFileLines", "getHeader", "()Ljava/lang/String;", "getContent", "sdk-common"})
    public static final class Hunk {
        private final int originalFileStartLine;
        private final int originalFileLines;
        private final int newFileStartLine;
        private final int newFileLines;
        @NotNull
        private final String header;
        @NotNull
        private final String content;

        public Hunk(int originalFileStartLine, int originalFileLines, int newFileStartLine, int newFileLines, @NotNull String header, @NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.originalFileStartLine = originalFileStartLine;
            this.originalFileLines = originalFileLines;
            this.newFileStartLine = newFileStartLine;
            this.newFileLines = newFileLines;
            this.header = header;
            this.content = content;
        }

        public final int getOriginalFileStartLine() {
            return this.originalFileStartLine;
        }

        public final int getOriginalFileLines() {
            return this.originalFileLines;
        }

        public final int getNewFileStartLine() {
            return this.newFileStartLine;
        }

        public final int getNewFileLines() {
            return this.newFileLines;
        }

        @NotNull
        public final String getHeader() {
            return this.header;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/ide/common/util/Diffs$LineType;", "", "<init>", "(Ljava/lang/String;I)V", "COMMON", "ADDED", "REMOVED", "sdk-common"})
    public static final class LineType
    extends Enum<LineType> {
        public static final /* enum */ LineType COMMON = new LineType();
        public static final /* enum */ LineType ADDED = new LineType();
        public static final /* enum */ LineType REMOVED = new LineType();
        private static final /* synthetic */ LineType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LineType[] values() {
            return (LineType[])$VALUES.clone();
        }

        public static LineType valueOf(String value) {
            return Enum.valueOf(LineType.class, value);
        }

        @NotNull
        public static EnumEntries<LineType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lineTypeArray = new LineType[]{LineType.COMMON, LineType.ADDED, LineType.REMOVED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

