/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.SdkConstants;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolListVisitor;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolTableBuilder;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.resources.ResourceType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u001a$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e\u001a\u001e\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001eH\u0002\u001a\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u001a\u000e\u0010#\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0017\u001a6\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020&0*2\u0006\u0010+\u001a\u00020&2\b\b\u0002\u0010,\u001a\u00020-\u001a\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0/2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u00100\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0017\u001a\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\u0006\u00102\u001a\u00020\u0017\u001a\u0016\u00103\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0001\u001a\u001c\u00107\u001a\u00020\u00192\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0001092\u0006\u0010:\u001a\u00020;\u001a\u000e\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u0001\u001a\u000e\u0010>\u001a\u00020\u00192\u0006\u0010:\u001a\u00020;\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"ANDROID_UNDERSCORE_PREFIX", "", "KEEP_RULE_PREFIX", "KEEP_RULE_SUFFIX", "NORMALIZED_VALUE_NAME_CHARS", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "VALUE_ID_SPLITTER", "Lcom/google/common/base/Splitter;", "canonicalizeValueResourceName", "name", "failParseArrayLiteral", "", "size", "", "valuesString", "generateKeepRules", "", "manifest", "Lcom/android/ide/common/xml/ManifestData;", "isMainDex", "", "mergedResources", "Ljava/io/File;", "generateKeepRulesFromLayoutXmlFile", "", "layout", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "rules", "Ljava/util/SortedSet;", "generateKeepRulesFromXmlNode", "node", "Lorg/w3c/dom/Element;", "generateMinifyKeepRules", "getPackageNameFromManifest", "manifestFile", "mergeAndRenumberSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "mainPackageName", "librarySymbols", "dependencySymbols", "", "platformSymbols", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "parseArrayLiteral", "Lcom/google/common/collect/ImmutableList;", "parseManifest", "parseMinifiedKeepRules", "proguardRulesFile", "rTxtToSymbolTable", "inputStream", "Ljava/io/InputStream;", "packageName", "readAarRTxt", "lines", "", "visitor", "Lcom/android/ide/common/symbols/SymbolListVisitor;", "valueStringToInt", "valueString", "visitEmptySymbolTable", "sdk-common"})
@JvmName(name="SymbolUtils")
@SourceDebugExtension(value={"SMAP\nSymbolUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolUtils.kt\ncom/android/ide/common/symbols/SymbolUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,616:1\n1863#2:617\n1863#2:618\n1864#2:626\n1864#2:627\n381#3,7:619\n*S KotlinDebug\n*F\n+ 1 SymbolUtils.kt\ncom/android/ide/common/symbols/SymbolUtils\n*L\n87#1:617\n88#1:618\n88#1:626\n87#1:627\n100#1:619,7\n*E\n"})
public final class SymbolUtils {
    private static final CharMatcher NORMALIZED_VALUE_NAME_CHARS = CharMatcher.anyOf((CharSequence)".:").precomputed();
    @NotNull
    private static final String ANDROID_UNDERSCORE_PREFIX = "android_";
    @NotNull
    private static final String KEEP_RULE_PREFIX = "-keep class ";
    @NotNull
    private static final String KEEP_RULE_SUFFIX = " { <init>(...); }";
    private static final Splitter VALUE_ID_SPLITTER = Splitter.on((char)',').trimResults();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SymbolTable mergeAndRenumberSymbols(@NotNull String mainPackageName, @NotNull SymbolTable librarySymbols, @NotNull Collection<? extends SymbolTable> dependencySymbols, @NotNull SymbolTable platformSymbols, @NotNull IdProvider idProvider) {
        Intrinsics.checkNotNullParameter((Object)mainPackageName, (String)"mainPackageName");
        Intrinsics.checkNotNullParameter((Object)librarySymbols, (String)"librarySymbols");
        Intrinsics.checkNotNullParameter(dependencySymbols, (String)"dependencySymbols");
        Intrinsics.checkNotNullParameter((Object)platformSymbols, (String)"platformSymbols");
        Intrinsics.checkNotNullParameter((Object)idProvider, (String)"idProvider");
        ArrayList<? extends SymbolTable> tables = new ArrayList<SymbolTable>(dependencySymbols.size() + 1);
        tables.add(librarySymbols);
        tables.addAll(dependencySymbols);
        HashMultimap newSymbolMap = HashMultimap.create();
        HashMap<Object, Object> arrayToAttrs = new HashMap<Object, Object>();
        Iterable $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SymbolTable table = (SymbolTable)element$iv;
            boolean bl = false;
            ImmutableCollection immutableCollection = table.getSymbols().values();
            Intrinsics.checkNotNullExpressionValue((Object)immutableCollection, (String)"values(...)");
            Iterable $this$forEach$iv2 = (Iterable)immutableCollection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Symbol symbol = (Symbol)element$iv2;
                boolean bl2 = false;
                Symbol symbol2 = symbol;
                if (symbol2 instanceof Symbol.AttributeSymbol) {
                    newSymbolMap.put((Object)ResourceType.ATTR, (Object)symbol.getCanonicalName());
                    continue;
                }
                if (symbol2 instanceof Symbol.NormalSymbol) {
                    newSymbolMap.put((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName());
                    continue;
                }
                if (symbol2 instanceof Symbol.StyleableSymbol) {
                    Object object;
                    void $this$getOrPut$iv;
                    Map map = arrayToAttrs;
                    String key$iv = symbol.getCanonicalName();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        Set answer$iv = new HashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).addAll((Collection)symbol.getChildren());
                    continue;
                }
                throw new IOException("Unexpected symbol " + symbol);
            }
        }
        SymbolTable.Builder tableBuilder = SymbolTable.Companion.builder().tablePackage(mainPackageName);
        HashMap<String, Symbol.AttributeSymbol> attrToValue = new HashMap<String, Symbol.AttributeSymbol>();
        for (ResourceType resourceType : newSymbolMap.keySet()) {
            ArrayList symbolNames = Lists.newArrayList((Iterable)newSymbolMap.get((Object)resourceType));
            Intrinsics.checkNotNull((Object)symbolNames);
            CollectionsKt.sort((List)symbolNames);
            for (String symbolName : symbolNames) {
                Intrinsics.checkNotNull((Object)resourceType);
                int value = idProvider.next(resourceType);
                Symbol newSymbol = null;
                if (resourceType == ResourceType.ATTR) {
                    Intrinsics.checkNotNull((Object)symbolName);
                    newSymbol = Symbol.Companion.attributeSymbol$default(Symbol.Companion, symbolName, value, false, null, null, 24, null);
                    ((Map)attrToValue).put(symbolName, newSymbol);
                } else {
                    Intrinsics.checkNotNull((Object)symbolName);
                    newSymbol = Symbol.Companion.normalSymbol$default(Symbol.Companion, resourceType, symbolName, value, null, symbolName, 8, null);
                }
                tableBuilder.add(newSymbol);
            }
        }
        arrayToAttrs.forEach((arg_0, arg_1) -> SymbolUtils.mergeAndRenumberSymbols$lambda$3((Function2)new Function2<String, Set<String>, Unit>(platformSymbols, attrToValue, tableBuilder){
            final /* synthetic */ SymbolTable $platformSymbols;
            final /* synthetic */ HashMap<String, Symbol.AttributeSymbol> $attrToValue;
            final /* synthetic */ SymbolTable.Builder $tableBuilder;
            {
                this.$platformSymbols = $platformSymbols;
                this.$attrToValue = $attrToValue;
                this.$tableBuilder = $tableBuilder;
                super(2);
            }

            public final void invoke(String arrayName, Set<String> children) {
                Intrinsics.checkNotNullParameter((Object)arrayName, (String)"arrayName");
                Intrinsics.checkNotNullParameter(children, (String)"children");
                List attributes = CollectionsKt.sorted((Iterable)children);
                ImmutableList.Builder attributeValues = ImmutableList.builder();
                for (String attribute : attributes) {
                    Symbol.AttributeSymbol symbol;
                    if (StringsKt.startsWith$default((String)attribute, (String)"android:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)attribute, (String)"android_", (boolean)false, (int)2, null)) {
                        String name;
                        Intrinsics.checkNotNullExpressionValue((Object)attribute.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN), (String)"substring(...)");
                        Symbol platformSymbol = (Symbol)this.$platformSymbols.getSymbols().get((Object)ResourceType.ATTR, (Object)name);
                        if (platformSymbol != null) {
                            attributeValues.add((Object)platformSymbol.getIntValue());
                            continue;
                        }
                    }
                    if ((symbol = this.$attrToValue.get(attribute)) != null) {
                        attributeValues.add((Object)symbol.getIntValue());
                        continue;
                    }
                    attributeValues.add((Object)0);
                }
                ImmutableList immutableList = attributeValues.build();
                Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
                ImmutableList immutableList2 = ImmutableList.copyOf((Collection)attributes);
                Intrinsics.checkNotNullExpressionValue((Object)immutableList2, (String)"copyOf(...)");
                this.$tableBuilder.add(Symbol.Companion.styleableSymbol$default(Symbol.Companion, arrayName, immutableList, immutableList2, null, arrayName, 8, null));
            }
        }, arg_0, arg_1));
        return tableBuilder.build();
    }

    public static /* synthetic */ SymbolTable mergeAndRenumberSymbols$default(String string, SymbolTable symbolTable, Collection collection, SymbolTable symbolTable2, IdProvider idProvider, int n, Object object) {
        if ((n & 0x10) != 0) {
            idProvider = IdProvider.Companion.sequential();
        }
        return SymbolUtils.mergeAndRenumberSymbols(string, symbolTable, collection, symbolTable2, idProvider);
    }

    @NotNull
    public static final String getPackageNameFromManifest(@NotNull File manifestFile) throws IOException {
        ManifestData manifestData;
        Intrinsics.checkNotNullParameter((Object)manifestFile, (String)"manifestFile");
        try {
            manifestData = AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath() + "'", e);
        }
        catch (IOException e) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath() + "'", e);
        }
        ManifestData manifestData2 = manifestData;
        String string = manifestData2.getPackage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackage(...)");
        return string;
    }

    @NotNull
    public static final String getPackageNameFromManifest(@NotNull ManifestData manifest) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        String string = manifest.getPackage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackage(...)");
        return string;
    }

    @NotNull
    public static final Set<String> generateMinifyKeepRules(@NotNull ManifestData manifest, @Nullable File mergedResources) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        return SymbolUtils.generateKeepRules(manifest, false, mergedResources);
    }

    @VisibleForTesting
    @NotNull
    public static final Set<String> generateKeepRules(@NotNull ManifestData manifest, boolean isMainDex, @Nullable File mergedResources) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        SortedSet rules = SetsKt.sortedSetOf((Object[])new String[0]);
        rules.add("# Generated by the gradle plugin");
        ManifestData.KeepClass[] keepClassArray = manifest.getKeepClasses();
        Intrinsics.checkNotNullExpressionValue((Object)keepClassArray, (String)"getKeepClasses(...)");
        for (ManifestData.KeepClass keepClass : keepClassArray) {
            if (isMainDex) {
                String type;
                Intrinsics.checkNotNullExpressionValue((Object)keepClass.getType(), (String)"getType(...)");
                String process = keepClass.getProcess();
                if (!(!Intrinsics.areEqual((Object)type, (Object)"activity") && !Intrinsics.areEqual((Object)type, (Object)"service") && !Intrinsics.areEqual((Object)type, (Object)"provider") && !Intrinsics.areEqual((Object)type, (Object)"receiver") || process != null && !(((CharSequence)process).length() == 0) && !StringsKt.startsWith$default((String)process, (String)":", (boolean)false, (int)2, null))) continue;
            }
            rules.add(KEEP_RULE_PREFIX + keepClass.getName() + KEEP_RULE_SUFFIX);
        }
        if (mergedResources != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                File[] fileArray = mergedResources.listFiles();
                Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
                for (File typeDir : fileArray) {
                    File[] fileArray2;
                    if (!typeDir.isDirectory()) continue;
                    String string = typeDir.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)"layout", (boolean)false, (int)2, null)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)typeDir.listFiles(), (String)"listFiles(...)");
                    for (File layoutXml : fileArray2) {
                        if (!layoutXml.isFile()) continue;
                        Intrinsics.checkNotNull((Object)layoutXml);
                        Intrinsics.checkNotNull((Object)documentBuilder);
                        SymbolUtils.generateKeepRulesFromLayoutXmlFile(layoutXml, documentBuilder, rules);
                    }
                }
            }
            catch (ParserConfigurationException e) {
                throw new IOException("Failed to read merged resources", e);
            }
        }
        return rules;
    }

    public static final void generateKeepRulesFromLayoutXmlFile(@NotNull File layout, @NotNull DocumentBuilder documentBuilder, @NotNull SortedSet<String> rules) throws IOException {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)documentBuilder, (String)"documentBuilder");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        try {
            Document xmlDocument = documentBuilder.parse(layout);
            Element root = xmlDocument.getDocumentElement();
            if (root != null) {
                SymbolUtils.generateKeepRulesFromXmlNode(root, rules);
            }
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse XML resource file " + layout.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new IOException("Failed to parse XML resource file " + layout.getAbsolutePath(), e);
        }
    }

    private static final void generateKeepRulesFromXmlNode(Element node, SortedSet<String> rules) {
        String tag = node.getTagName();
        Intrinsics.checkNotNull((Object)tag);
        if (StringsKt.contains$default((CharSequence)tag, (CharSequence)".", (boolean)false, (int)2, null)) {
            rules.add(KEEP_RULE_PREFIX + tag + KEEP_RULE_SUFFIX);
        }
        for (Node current = node.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            SymbolUtils.generateKeepRulesFromXmlNode((Element)current, rules);
        }
    }

    @NotNull
    public static final SortedSet<String> parseMinifiedKeepRules(@NotNull File proguardRulesFile) throws IOException {
        Intrinsics.checkNotNullParameter((Object)proguardRulesFile, (String)"proguardRulesFile");
        TreeSet keepClasses = SetsKt.sortedSetOf((Object[])new String[0]);
        if (!proguardRulesFile.isFile()) {
            throw new IOException("Failed to parse proguard rules at path: " + proguardRulesFile.getAbsolutePath());
        }
        FilesKt.forEachLine$default((File)proguardRulesFile, null, (Function1)((Function1)new Function1<String, Unit>((TreeSet<String>)keepClasses){
            final /* synthetic */ TreeSet<String> $keepClasses;
            {
                this.$keepClasses = $keepClasses;
                super(1);
            }

            public final void invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (StringsKt.startsWith$default((String)it, (String)"-keep class ", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)" { <init>(...); }", (boolean)false, (int)2, null)) {
                    this.$keepClasses.add(it);
                }
            }
        }), (int)1, null);
        return keepClasses;
    }

    @NotNull
    public static final ManifestData parseManifest(@NotNull File manifestFile) throws IOException {
        ManifestData manifestData;
        Intrinsics.checkNotNullParameter((Object)manifestFile, (String)"manifestFile");
        try {
            manifestData = AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
            Intrinsics.checkNotNull((Object)manifestData);
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
        return manifestData;
    }

    @NotNull
    public static final String canonicalizeValueResourceName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = NORMALIZED_VALUE_NAME_CHARS.replaceFrom((CharSequence)name, '_');
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceFrom(...)");
        return string;
    }

    public static final int valueStringToInt(@NotNull String valueString) {
        int n;
        Intrinsics.checkNotNullParameter((Object)valueString, (String)"valueString");
        if (StringsKt.startsWith$default((String)valueString, (String)"0x", (boolean)false, (int)2, null)) {
            String string = valueString.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            n = Integer.parseUnsignedInt(string, 16);
        } else {
            n = Integer.parseInt(valueString);
        }
        return n;
    }

    @NotNull
    public static final ImmutableList<Integer> parseArrayLiteral(int size, @NotNull String valuesString) {
        Intrinsics.checkNotNullParameter((Object)valuesString, (String)"valuesString");
        if (size == 0) {
            if (!StringsKt.isBlank((CharSequence)valuesString.subSequence(1, valuesString.length() - 1))) {
                SymbolUtils.failParseArrayLiteral(size, valuesString);
                throw new KotlinNothingValueException();
            }
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
            return immutableList;
        }
        ImmutableList.Builder ints = ImmutableList.builder();
        Iterator values = VALUE_ID_SPLITTER.split(valuesString.subSequence(1, valuesString.length() - 1)).iterator();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!values.hasNext()) {
                SymbolUtils.failParseArrayLiteral(size, valuesString);
                throw new KotlinNothingValueException();
            }
            String value = (String)values.next();
            Intrinsics.checkNotNull((Object)value);
            if (StringsKt.startsWith$default((String)value, (String)"android", (boolean)false, (int)2, null)) {
                ints.add((Object)0);
                continue;
            }
            ints.add((Object)SymbolUtils.valueStringToInt(value));
        }
        if (values.hasNext()) {
            SymbolUtils.failParseArrayLiteral(size, valuesString);
            throw new KotlinNothingValueException();
        }
        ImmutableList immutableList = ints.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return immutableList;
    }

    @NotNull
    public static final Void failParseArrayLiteral(int size, @NotNull String valuesString) {
        Intrinsics.checkNotNullParameter((Object)valuesString, (String)"valuesString");
        throw new IOException("Values string " + valuesString + " should have " + size + " item(s).");
    }

    public static final void readAarRTxt(@NotNull Iterator<String> lines, @NotNull SymbolListVisitor visitor) throws IOException {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        visitor.visit();
        Object styleableChildPrefix = null;
        while (lines.hasNext()) {
            int end;
            int middle;
            int start;
            String line = lines.next();
            if (styleableChildPrefix != null && StringsKt.startsWith$default((String)line, styleableChildPrefix, (boolean)false, (int)2, null)) {
                start = ((String)styleableChildPrefix).length() + 1;
                int end2 = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)((String)styleableChildPrefix).length(), (boolean)false, (int)4, null);
                if (end2 == -1) continue;
                String string = line.substring(start, end2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                visitor.child(string);
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"int styleable ", (boolean)false, (int)2, null) || (start = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)0, (boolean)false, (int)6, null) + 1) == 0 || (middle = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)start, (boolean)false, (int)4, null) + 1) == 0 || (end = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)middle, (boolean)false, (int)4, null) + 1) == 0) continue;
            visitor.symbol(line.subSequence(start, middle - 1), line.subSequence(middle, end - 1));
            if (StringsKt.startsWith$default((String)line, (String)"int[] ", (boolean)false, (int)2, null)) {
                String string = line.substring(middle, end - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                styleableChildPrefix = "int styleable " + string;
                continue;
            }
            styleableChildPrefix = null;
        }
        visitor.visitEnd();
    }

    public static final void visitEmptySymbolTable(@NotNull SymbolListVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        visitor.visit();
        visitor.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SymbolTable rTxtToSymbolTable(@NotNull InputStream inputStream, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        SymbolTableBuilder symbolTableBuilder = new SymbolTableBuilder(packageName);
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            Iterator<String> iterator = it.lines().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            SymbolUtils.readAarRTxt(iterator, symbolTableBuilder);
            reader = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return symbolTableBuilder.getSymbolTable();
    }

    private static final void mergeAndRenumberSymbols$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

