/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFileJsonTypeAdapter;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourceFilePositionJsonSerializer;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.SourcePositionJsonTypeAdapter;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class MergingLogPersistUtil {
    private static final SourceFileJsonTypeAdapter mSourceFileJsonTypeAdapter = new SourceFileJsonTypeAdapter();
    private static final SourcePositionJsonTypeAdapter mSourcePositionJsonTypeAdapter = new SourcePositionJsonTypeAdapter();
    private static final SourceFilePositionJsonSerializer mSourceFilePositionJsonTypeAdapter = new SourceFilePositionJsonSerializer();
    private static final SourcePositionsSerializer.JsonTypeAdapter mSourcePositionsJsonTypeAdapter = new SourcePositionsSerializer.JsonTypeAdapter();
    private static final String KEY_OUTPUT_FILE = "outputFile";
    private static final String KEY_FROM = "from";
    private static final String KEY_TO = "to";
    private static final String KEY_MERGED = "merged";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_MAP = "map";
    private static final String KEY_LOGS = "logs";
    private static final String INDENT_STRING = "    ";
    private static final String START_LINES = "startLines";
    private static final String START_COLUMNS = "startColumns";
    private static final String START_OFFSETS = "startOffsets";
    private static final String END_LINES = "endLines";
    private static final String END_COLUMNS = "endColumns";
    private static final String END_OFFSETS = "endOffsets";

    private static File getMultiFile(File folder, String shard) {
        return new File(new File(folder, "multi-v2"), shard + ".json");
    }

    private static File getSingleFile(File folder, String shard) {
        return new File(new File(folder, "single"), shard + ".json");
    }

    static void saveToMultiFileVersion2(File folder, String shard, Map<SourceFile, Map<SourcePosition, SourceFilePosition>> map) throws IOException {
        File file = MergingLogPersistUtil.getMultiFile(folder, shard);
        file.getParentFile().mkdir();
        try (JsonWriter out = new JsonWriter((Writer)Files.newWriter((File)file, (Charset)Charsets.UTF_8));){
            out.setIndent(INDENT_STRING);
            out.beginObject().name(KEY_LOGS);
            out.beginArray();
            for (Map.Entry<SourceFile, Map<SourcePosition, SourceFilePosition>> entry : map.entrySet()) {
                out.beginObject().name(KEY_OUTPUT_FILE);
                mSourceFileJsonTypeAdapter.write(out, entry.getKey());
                out.name(KEY_MAP);
                out.beginArray();
                Map<SourcePosition, SourceFilePosition> mappings = entry.getValue();
                Map<SourceFile, Pair<SourcePositionsSerializer, SourcePositionsSerializer>> sourceFileListMap = MergingLogPersistUtil.normalize(mappings);
                for (Map.Entry<SourceFile, Pair<SourcePositionsSerializer, SourcePositionsSerializer>> sourceFileListEntry : sourceFileListMap.entrySet()) {
                    out.beginObject();
                    out.name(KEY_SOURCE).value(sourceFileListEntry.getKey().getSourcePath());
                    Pair<SourcePositionsSerializer, SourcePositionsSerializer> serializerPair = sourceFileListEntry.getValue();
                    mSourcePositionsJsonTypeAdapter.write(out, (SourcePositionsSerializer)serializerPair.getFirst());
                    if (!((SourcePositionsSerializer)serializerPair.getFirst()).equals(serializerPair.getSecond())) {
                        mSourcePositionsJsonTypeAdapter.write(out, (SourcePositionsSerializer)serializerPair.getSecond());
                    }
                    out.endObject();
                }
                out.endArray();
                out.endObject();
            }
            out.endArray();
            out.endObject();
        }
    }

    private static Map<SourceFile, Pair<SourcePositionsSerializer, SourcePositionsSerializer>> normalize(Map<SourcePosition, SourceFilePosition> mappings) {
        HashMap<SourceFile, Pair<SourcePositionsSerializer, SourcePositionsSerializer>> perSourcePositions = new HashMap<SourceFile, Pair<SourcePositionsSerializer, SourcePositionsSerializer>>();
        mappings.entrySet().forEach(entry -> {
            SourceFile sourceFile = ((SourceFilePosition)entry.getValue()).getFile();
            if (!perSourcePositions.containsKey(sourceFile)) {
                perSourcePositions.put(sourceFile, Pair.of((Object)new SourcePositionsSerializer(SourcePositionsSerializer.Kind.FROM), (Object)new SourcePositionsSerializer(SourcePositionsSerializer.Kind.TO)));
            }
            Pair serializers = (Pair)perSourcePositions.get(sourceFile);
            ((SourcePositionsSerializer)serializers.getFirst()).append(((SourceFilePosition)entry.getValue()).getPosition());
            ((SourcePositionsSerializer)serializers.getSecond()).append((SourcePosition)entry.getKey());
        });
        return perSourcePositions;
    }

    static Map<SourceFile, Map<SourcePosition, SourceFilePosition>> loadFromMultiFileVersion2(File folder, String shard, boolean relativeResFilepathEnabled) {
        JsonReader reader;
        ConcurrentMap map = Maps.newConcurrentMap();
        File file = MergingLogPersistUtil.getMultiFile(folder, shard);
        if (!file.exists()) {
            return map;
        }
        try {
            reader = new JsonReader((Reader)Files.newReader((File)file, (Charset)Charsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            return map;
        }
        try {
            reader.beginObject();
            String name = reader.nextName();
            if (!name.equals(KEY_LOGS)) {
                throw new IOException(String.format("Malformed log file : %s", name));
            }
            reader.beginArray();
            while (reader.peek() != JsonToken.END_ARRAY) {
                reader.beginObject();
                SourceFile toFile = SourceFile.UNKNOWN;
                LinkedHashMap innerMap = Maps.newLinkedHashMap();
                while (reader.peek() != JsonToken.END_OBJECT) {
                    name = reader.nextName();
                    if (name.equals(KEY_OUTPUT_FILE)) {
                        String pathname = reader.nextString();
                        toFile = new SourceFile(new File(pathname));
                        if (!relativeResFilepathEnabled) continue;
                        toFile.setOverrideSourcePath(pathname);
                        continue;
                    }
                    if (name.equals(KEY_MAP)) {
                        reader.beginArray();
                        while (reader.peek() != JsonToken.END_ARRAY) {
                            reader.beginObject();
                            HashMap<String, List<Integer>> toKeyValuePairs = new HashMap<String, List<Integer>>();
                            HashMap<String, List<Integer>> fromKeyValuePairs = new HashMap<String, List<Integer>>();
                            SourceFile fromFile = SourceFile.UNKNOWN;
                            while (reader.peek() != JsonToken.END_OBJECT) {
                                String propertyName = reader.nextName();
                                if (propertyName.equals(KEY_SOURCE)) {
                                    fromFile = new SourceFile(new File(reader.nextString()));
                                }
                                if (propertyName.equals(KEY_FROM)) {
                                    MergingLogPersistUtil.readCondensedPositions(reader, fromKeyValuePairs);
                                    continue;
                                }
                                if (!propertyName.equals(KEY_TO)) continue;
                                MergingLogPersistUtil.readCondensedPositions(reader, toKeyValuePairs);
                            }
                            reader.endObject();
                            for (int i2 = 0; i2 < ((List)fromKeyValuePairs.get(START_LINES)).size(); ++i2) {
                                SourcePosition fromPosition = MergingLogPersistUtil.extractSourcePosition(fromKeyValuePairs, i2);
                                SourcePosition toPosition = toKeyValuePairs.get(START_LINES) != null ? MergingLogPersistUtil.extractSourcePosition(toKeyValuePairs, i2) : fromPosition;
                                innerMap.put(toPosition, new SourceFilePosition(fromFile, fromPosition));
                            }
                        }
                        reader.endArray();
                        continue;
                    }
                    throw new IOException(String.format("Unexpected properties %s", name));
                }
                reader.endObject();
                map.put(toFile, innerMap);
            }
            reader.endArray();
            reader.endObject();
            ConcurrentMap concurrentMap = map;
            return concurrentMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static void readCondensedPositions(JsonReader reader, Map<String, List<Integer>> positions) throws IOException {
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT) {
            String attrNames = reader.nextName();
            List numbers = StreamSupport.stream(Splitter.on((char)',').split((CharSequence)reader.nextString()).spliterator(), false).map(Integer::valueOf).collect(Collectors.toList());
            positions.put(attrNames, numbers);
        }
        reader.endObject();
    }

    private static SourcePosition extractSourcePosition(Map<String, List<Integer>> positions, int index) {
        return new SourcePosition(positions.get(START_LINES).get(index).intValue(), positions.get(START_COLUMNS).get(index).intValue(), positions.get(START_OFFSETS).get(index).intValue(), (positions.containsKey(END_LINES) ? positions.get(END_LINES).get(index) : positions.get(START_LINES).get(index)).intValue(), (positions.containsKey(END_COLUMNS) ? positions.get(END_COLUMNS).get(index) : positions.get(START_COLUMNS).get(index)).intValue(), (positions.containsKey(END_OFFSETS) ? positions.get(END_OFFSETS).get(index) : positions.get(START_OFFSETS).get(index)).intValue());
    }

    static void saveToSingleFile(File folder, String shard, Map<SourceFile, SourceFile> map) throws IOException {
        File file = MergingLogPersistUtil.getSingleFile(folder, shard);
        file.getParentFile().mkdir();
        try (JsonWriter out = new JsonWriter((Writer)Files.newWriter((File)file, (Charset)Charsets.UTF_8));){
            out.setIndent(INDENT_STRING);
            out.beginArray();
            for (Map.Entry<SourceFile, SourceFile> entry : map.entrySet()) {
                out.beginObject();
                out.name(KEY_MERGED);
                mSourceFileJsonTypeAdapter.write(out, entry.getKey());
                out.name(KEY_SOURCE);
                mSourceFileJsonTypeAdapter.write(out, entry.getValue());
                out.endObject();
            }
            out.endArray();
        }
    }

    static Map<SourceFile, SourceFile> loadFromSingleFile(File folder, String shard) {
        ConcurrentMap concurrentMap;
        ConcurrentMap fileMap = Maps.newConcurrentMap();
        File file = MergingLogPersistUtil.getSingleFile(folder, shard);
        if (!file.exists()) {
            return fileMap;
        }
        JsonReader reader = new JsonReader((Reader)Files.newReader((File)file, (Charset)Charsets.UTF_8));
        try {
            reader.beginArray();
            while (reader.peek() != JsonToken.END_ARRAY) {
                reader.beginObject();
                SourceFile merged = SourceFile.UNKNOWN;
                SourceFile source = SourceFile.UNKNOWN;
                while (reader.peek() != JsonToken.END_OBJECT) {
                    String name = reader.nextName();
                    if (name.equals(KEY_MERGED)) {
                        merged = mSourceFileJsonTypeAdapter.read(reader);
                        continue;
                    }
                    if (name.equals(KEY_SOURCE)) {
                        source = mSourceFileJsonTypeAdapter.read(reader);
                        continue;
                    }
                    throw new IOException(String.format("Unexpected property: %s", name));
                }
                reader.endObject();
                fileMap.put(merged, source);
            }
            reader.endArray();
            concurrentMap = fileMap;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return fileMap;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return concurrentMap;
    }

    protected static final class SourcePositionsSerializer {
        private final Kind kind;
        private final StringBuilder startLines = new StringBuilder();
        private final StringBuilder startColumns = new StringBuilder();
        private final StringBuilder startOffsets = new StringBuilder();
        private final StringBuilder endLines = new StringBuilder();
        private final StringBuilder endColumns = new StringBuilder();
        private final StringBuilder endOffsets = new StringBuilder();

        SourcePositionsSerializer(Kind kind) {
            this.kind = kind;
        }

        void append(SourcePosition sourcePosition) {
            SourcePositionsSerializer.append(this.startLines, sourcePosition.getStartLine());
            SourcePositionsSerializer.append(this.startColumns, sourcePosition.getStartColumn());
            SourcePositionsSerializer.append(this.startOffsets, sourcePosition.getStartOffset());
            SourcePositionsSerializer.append(this.endLines, sourcePosition.getEndLine());
            SourcePositionsSerializer.append(this.endColumns, sourcePosition.getEndColumn());
            SourcePositionsSerializer.append(this.endOffsets, sourcePosition.getEndOffset());
        }

        public int hashCode() {
            return Objects.hash(this.startLines, this.startColumns, this.startOffsets, this.endLines, this.endColumns, this.endOffsets);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourcePositionsSerializer other = (SourcePositionsSerializer)o;
            return this.startLines.toString().equals(other.startLines.toString()) && this.startColumns.toString().equals(other.startColumns.toString()) && this.startOffsets.toString().equals(other.startOffsets.toString()) && this.endLines.toString().equals(other.endLines.toString()) && this.endColumns.toString().equals(other.endColumns.toString()) && this.endOffsets.toString().equals(other.endOffsets.toString());
        }

        private static void append(StringBuilder stringBuilder, int value) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(value);
        }

        static enum Kind {
            FROM,
            TO;

        }

        private static final class JsonTypeAdapter
        extends TypeAdapter<SourcePositionsSerializer> {
            private JsonTypeAdapter() {
            }

            public void write(JsonWriter writer, SourcePositionsSerializer value) throws IOException {
                String persistedEndOffsets;
                String persistedEndColums;
                writer.name(value.kind.name().toLowerCase(Locale.US));
                writer.beginObject();
                String persistedStartLines = value.startLines.toString();
                writer.name(MergingLogPersistUtil.START_LINES).value(persistedStartLines);
                String persistedStartColumns = value.startColumns.toString();
                writer.name(MergingLogPersistUtil.START_COLUMNS).value(persistedStartColumns);
                String persistedStartOffsets = value.startOffsets.toString();
                writer.name(MergingLogPersistUtil.START_OFFSETS).value(persistedStartOffsets);
                String persisteEndLines = value.endLines.toString();
                if (!persisteEndLines.equals(persistedStartLines)) {
                    writer.name(MergingLogPersistUtil.END_LINES).value(persisteEndLines);
                }
                if (!(persistedEndColums = value.endColumns.toString()).equals(persistedStartColumns)) {
                    writer.name(MergingLogPersistUtil.END_COLUMNS).value(value.endColumns.toString());
                }
                if (!(persistedEndOffsets = value.endOffsets.toString()).equals(persistedStartOffsets)) {
                    writer.name(MergingLogPersistUtil.END_OFFSETS).value(value.endOffsets.toString());
                }
                writer.endObject();
            }

            public SourcePositionsSerializer read(JsonReader in) throws IOException {
                throw new IOException("SourcePositionsSerializer is not meant to be read from Json");
            }
        }
    }
}

