/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.SettingsController;
import com.android.repository.io.FileOp;
import com.android.sdklib.repository.legacy.LegacyTaskMonitor;
import com.android.sdklib.repository.legacy.remote.internal.DownloadCache;
import com.android.utils.Pair;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;

public class LegacyDownloader
implements Downloader {
    private DownloadCache mDownloadCache;
    private FileOp mFileOp;
    private SettingsController mSettingsController;

    public LegacyDownloader(FileOp fop, SettingsController settings) {
        this.mDownloadCache = DownloadCache.inUserHome(fop, DownloadCache.Strategy.FRESH_CACHE, settings);
        this.mFileOp = fop;
        this.mSettingsController = settings;
    }

    public InputStream downloadAndStream(URL url, ProgressIndicator indicator) throws IOException {
        return this.mDownloadCache.openCachedUrl(this.getUrl(url), new LegacyTaskMonitor(indicator));
    }

    public Path downloadFully(URL url, ProgressIndicator indicator) throws IOException {
        File target = File.createTempFile("LegacyDownloader", null);
        this.downloadFully(url, target, null, indicator);
        return target.toPath();
    }

    public void downloadFully(URL url, File target, String checksum, ProgressIndicator indicator) throws IOException {
        if (this.mFileOp.exists(target) && checksum != null) {
            try (BufferedInputStream in = new BufferedInputStream(this.mFileOp.newFileInputStream(target));){
                if (checksum.equals(Downloader.hash((InputStream)in, (long)this.mFileOp.length(target), (ProgressIndicator)indicator))) {
                    return;
                }
            }
        }
        this.mFileOp.mkdirs(target.getParentFile());
        OutputStream out = this.mFileOp.newFileOutputStream(target);
        Pair<InputStream, Integer> downloadedResult = this.mDownloadCache.openDirectUrl(this.getUrl(url), new LegacyTaskMonitor(indicator));
        if ((Integer)downloadedResult.getSecond() == 200) {
            ByteStreams.copy((InputStream)((InputStream)downloadedResult.getFirst()), (OutputStream)out);
            out.close();
        }
    }

    private String getUrl(URL url) {
        String urlStr = url.toString();
        if (this.mSettingsController.getForceHttp()) {
            urlStr = urlStr.replaceAll("^https://", "http://");
        }
        return urlStr;
    }
}

