/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool;

import com.android.prefs.AndroidLocation;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.sdklib.util.CommandLineParser;
import com.android.utils.ILogger;
import com.android.utils.IReaderLogger;
import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class AvdManagerCli
extends CommandLineParser {
    private static final String VERB_LIST = "list";
    private static final String VERB_CREATE = "create";
    private static final String VERB_MOVE = "move";
    private static final String VERB_DELETE = "delete";
    private static final String OBJECT_AVDS = "avds";
    private static final String OBJECT_AVD = "avd";
    private static final String OBJECT_TARGET = "target";
    private static final String OBJECT_TARGETS = "targets";
    private static final String OBJECT_DEVICE = "device";
    private static final String OBJECT_DEVICES = "devices";
    private static final String KEY_IMAGE_PACKAGE = "package";
    private static final String KEY_NAME = "name";
    private static final String KEY_PATH = "path";
    private static final String KEY_SDCARD = "sdcard";
    private static final String KEY_FORCE = "force";
    private static final String KEY_RENAME = "rename";
    private static final String KEY_SNAPSHOT = "snapshot";
    private static final String KEY_COMPACT = "compact";
    private static final String KEY_EOL_NULL = "null";
    private static final String KEY_TAG = "tag";
    private static final String KEY_ABI = "abi";
    private static final String KEY_CLEAR_CACHE = "clear-cache";
    private static final String KEY_DEVICE = "device";
    private static final String TOOLSDIR = "com.android.sdkmanager.toolsdir";
    private static final String WORKDIR = "com.android.sdkmanager.workdir";
    private static final String[] BOOLEAN_YES_REPLIES = new String[]{"yes", "y"};
    private static final String[] BOOLEAN_NO_REPLIES = new String[]{"no", "n"};
    private static final Pattern RE_AVD_NAME = Pattern.compile("[a-zA-Z0-9._-]+");
    private static final String CHARS_AVD_NAME = "a-z A-Z 0-9 . _ -";
    private InputStream mInput;
    private String mOsSdkFolder;
    private final ILogger mSdkLog;
    private AndroidSdkHandler mSdkHandler;
    private AvdManager mAvdManager;
    private String mAvdFolder;
    private static final String[][] ACTIONS = new String[][]{{"list", "", "Lists existing targets or virtual devices."}, {"list", "avd", "Lists existing Android Virtual Devices.", "avds"}, {"list", "target", "Lists existing targets.", "targets"}, {"list", "device", "Lists existing devices.", "devices"}, {"create", "avd", "Creates a new Android Virtual Device."}, {"move", "avd", "Moves or renames an Android Virtual Device."}, {"delete", "avd", "Deletes an Android Virtual Device."}};

    public static void main(String[] args) {
        try {
            AtomicReference<AvdManagerCli> reference = new AtomicReference<AvdManagerCli>();
            ILogger logger = AvdManagerCli.createLogger(reference);
            AvdManagerCli instance = new AvdManagerCli(logger);
            reference.set(instance);
            instance.run(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    void run(String[] args) {
        this.init();
        this.parseArgs(args);
        if (this.mSdkHandler == null) {
            this.mSdkHandler = AndroidSdkHandler.getInstance(new File(this.mOsSdkFolder));
        }
        this.doAction();
    }

    private static ILogger createLogger(final AtomicReference<AvdManagerCli> cli) {
        return new IReaderLogger(){

            public void error(Throwable t, String errorFormat, Object ... args) {
                if (errorFormat != null) {
                    System.err.printf("Error: " + errorFormat, args);
                    if (!errorFormat.endsWith("\n")) {
                        System.err.printf("\n", new Object[0]);
                    }
                }
                if (t != null) {
                    System.err.printf("Error: %s\n", t.getMessage());
                }
            }

            public void warning(String warningFormat, Object ... args) {
                if (((AvdManagerCli)cli.get()).isVerbose()) {
                    System.out.printf("Warning: " + warningFormat, args);
                    if (!warningFormat.endsWith("\n")) {
                        System.out.printf("\n", new Object[0]);
                    }
                }
            }

            public void info(String msgFormat, Object ... args) {
                System.out.printf(msgFormat, args);
            }

            public void verbose(String msgFormat, Object ... args) {
                System.out.printf(msgFormat, args);
            }

            public int readLine(byte[] inputBuffer) throws IOException {
                return System.in.read(inputBuffer);
            }
        };
    }

    private void init() {
        String workDirProp;
        if (this.mAvdFolder == null) {
            try {
                this.mAvdFolder = AndroidLocation.getAvdFolder();
            }
            catch (AndroidLocation.AndroidLocationException androidLocationException) {
                // empty catch block
            }
        }
        if (this.mOsSdkFolder == null) {
            String toolsDirProp = System.getProperty(TOOLSDIR);
            if (toolsDirProp == null) {
                toolsDirProp = System.getenv(TOOLSDIR);
            }
            if (toolsDirProp != null) {
                File tools;
                if (toolsDirProp.length() > 0) {
                    try {
                        tools = new File(toolsDirProp).getCanonicalFile();
                        this.mOsSdkFolder = tools.getParent();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.mOsSdkFolder == null) {
                    try {
                        tools = new File(".").getCanonicalFile();
                        this.mOsSdkFolder = tools.getParent();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (this.mOsSdkFolder == null) {
                String cmdName = "avdmanager" + (this.mSdkHandler.getFileOp().isWindows() ? ".bat" : "");
                this.errorAndExit("The tools directory property is not set, please make sure you are executing %1$s", cmdName);
            }
        }
        if (this.mInput == null) {
            this.mInput = System.in;
        }
        if ((workDirProp = System.getProperty(WORKDIR)) == null) {
            workDirProp = System.getenv(WORKDIR);
        }
        if (workDirProp != null) {
            File workDir = new File(workDirProp);
            try {
                workDir = workDir.getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                workDir = null;
            }
            if (workDir == null || !workDir.isDirectory()) {
                this.errorAndExit("The working directory does not seem to be valid: '%1$s", workDirProp);
            }
        }
    }

    private AvdManager getAvdManager() throws AndroidLocation.AndroidLocationException {
        if (this.mAvdManager == null) {
            this.mAvdManager = (AvdManager)Verify.verifyNotNull((Object)AvdManager.getInstance(this.mSdkHandler, new File(this.mAvdFolder), this.mSdkLog));
        }
        return this.mAvdManager;
    }

    private void doAction() {
        String verb = this.getVerb();
        String directObject = this.getDirectObject();
        if (VERB_LIST.equals(verb)) {
            if (OBJECT_AVD.equals(directObject)) {
                this.displayAvdList();
            } else if ("device".equals(directObject)) {
                this.displayDeviceList();
            } else if (OBJECT_TARGET.equals(directObject)) {
                this.displayTargetList();
            } else {
                this.displayAvdList();
                this.displayDeviceList();
                this.displayTargetList();
            }
        } else if (VERB_CREATE.equals(verb)) {
            if (OBJECT_AVD.equals(directObject)) {
                this.createAvd();
            }
        } else if (VERB_DELETE.equals(verb) && OBJECT_AVD.equals(directObject)) {
            this.deleteAvd();
        } else if (VERB_MOVE.equals(verb) && OBJECT_AVD.equals(directObject)) {
            this.moveAvd();
        } else {
            this.printHelpAndExit(null, new Object[0]);
        }
    }

    private void displayTagAbiList(Collection<? extends ISystemImage> systemImages, String message) {
        this.mSdkLog.info(message, new Object[0]);
        if (!systemImages.isEmpty()) {
            boolean first = true;
            for (ISystemImage iSystemImage : systemImages) {
                if (!first) {
                    this.mSdkLog.info(", ", new Object[0]);
                } else {
                    first = false;
                }
                this.mSdkLog.info("%s/%s", new Object[]{iSystemImage.getTag().getId(), iSystemImage.getAbiType()});
            }
            this.mSdkLog.info("\n", new Object[0]);
        } else {
            this.mSdkLog.info("no ABIs.\n", new Object[0]);
        }
    }

    private void displayAvdList(AvdManager avdManager) {
        AvdInfo[] avds = avdManager.getValidAvds();
        Arrays.sort(avds, (a1, a2) -> a1.getName().compareToIgnoreCase(a2.getName()));
        if (this.getFlagCompact()) {
            char eol = this.getFlagEolNull() ? (char)'\u0000' : '\n';
            for (AvdInfo info : avds) {
                this.mSdkLog.info("%1$s%2$c", new Object[]{info.getName(), Character.valueOf(eol)});
            }
            return;
        }
        this.mSdkLog.info("Available Android Virtual Devices:\n", new Object[0]);
        for (int index = 0; index < avds.length; ++index) {
            String snapshot;
            String sdcard;
            AvdInfo info = avds[index];
            if (index > 0) {
                this.mSdkLog.info("---------\n", new Object[0]);
            }
            this.mSdkLog.info("    Name: %s\n", new Object[]{info.getName()});
            String deviceName = info.getProperties().get("hw.device.name");
            String deviceMfctr = info.getProperties().get("hw.device.manufacturer");
            if (deviceName != null) {
                this.mSdkLog.info("  Device: %s", new Object[]{deviceName});
                if (deviceMfctr != null) {
                    this.mSdkLog.info(" (%s)", new Object[]{deviceMfctr});
                }
                this.mSdkLog.info("\n", new Object[0]);
            }
            this.mSdkLog.info("    Path: %s\n", new Object[]{info.getDataFolderPath()});
            SystemImage img = (SystemImage)info.getSystemImage();
            DetailsTypes.ApiDetailsType details = (DetailsTypes.ApiDetailsType)img.getPackage().getTypeDetails();
            String versionWithCodename = SdkVersionInfo.getVersionWithCodename(details.getAndroidVersion());
            if (details instanceof DetailsTypes.PlatformDetailsType) {
                this.mSdkLog.info("  API: %s", new Object[]{versionWithCodename});
            } else if (details instanceof DetailsTypes.SysImgDetailsType) {
                IdDisplay vendor = ((DetailsTypes.SysImgDetailsType)details).getVendor();
                String vendorStr = "";
                if (vendor != null) {
                    vendorStr = " (" + vendor.getDisplay() + ")";
                }
                this.mSdkLog.info("  Target: %s%s\n", new Object[]{img.getTag().getDisplay(), vendorStr});
                this.mSdkLog.info("          Based on: %s", new Object[]{versionWithCodename});
            } else if (details instanceof DetailsTypes.AddonDetailsType) {
                this.mSdkLog.info("  Target: %s (%s)\n", new Object[]{img.getPackage().getDisplayName(), ((DetailsTypes.AddonDetailsType)details).getVendor().getDisplay()});
                this.mSdkLog.info("          Based on: %s\n", new Object[]{versionWithCodename});
            }
            this.mSdkLog.info(" Tag/ABI: %s/%s\n", new Object[]{info.getTag().getId(), info.getAbiType()});
            Map<String, String> properties = info.getProperties();
            String skin = properties.get("skin.name");
            if (skin != null) {
                this.mSdkLog.info("    Skin: %s\n", new Object[]{skin});
            }
            if ((sdcard = properties.get("sdcard.size")) == null) {
                sdcard = properties.get("sdcard.path");
            }
            if (sdcard != null) {
                this.mSdkLog.info("  Sdcard: %s\n", new Object[]{sdcard});
            }
            if ((snapshot = properties.get("snapshot.present")) == null) continue;
            this.mSdkLog.info("Snapshot: %s\n", new Object[]{snapshot});
        }
        List badAvds = Arrays.asList(avdManager.getAllAvds()).stream().filter(avd -> avd.getStatus() != AvdInfo.AvdStatus.OK).collect(Collectors.toList());
        if (badAvds.isEmpty()) {
            return;
        }
        this.mSdkLog.info("\nThe following Android Virtual Devices could not be loaded:\n", new Object[0]);
        boolean needSeparator = false;
        for (AvdInfo info : badAvds) {
            if (needSeparator) {
                this.mSdkLog.info("---------\n", new Object[0]);
            }
            this.mSdkLog.info("    Name: %s\n", new Object[]{info.getName()});
            this.mSdkLog.info("    Path: %s\n", new Object[]{info.getDataFolderPath()});
            String error = info.getErrorMessage();
            this.mSdkLog.info("   Error: %s\n", new Object[]{error == null ? "Uknown error" : error});
            needSeparator = true;
        }
    }

    private void displayAvdList() {
        try {
            AvdManager avdManager = this.getAvdManager();
            this.displayAvdList(avdManager);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    void displayTargetList() {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator(){

            public void logVerbose(String s) {
            }
        };
        Collection<IAndroidTarget> targets = this.mSdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargets((ProgressIndicator)progress);
        if (this.getFlagCompact()) {
            char eol = this.getFlagEolNull() ? (char)'\u0000' : '\n';
            for (IAndroidTarget target : targets) {
                this.mSdkLog.info("%1$s%2$c", new Object[]{target.hashString(), Character.valueOf(eol)});
            }
            return;
        }
        this.mSdkLog.info("Available Android targets:\n", new Object[0]);
        int index = 1;
        for (IAndroidTarget target : targets) {
            this.mSdkLog.info("----------\n", new Object[0]);
            this.mSdkLog.info("id: %1$d or \"%2$s\"\n", new Object[]{index, target.hashString()});
            this.mSdkLog.info("     Name: %s\n", new Object[]{target.getName()});
            if (target.isPlatform()) {
                this.mSdkLog.info("     Type: Platform\n", new Object[0]);
                this.mSdkLog.info("     API level: %s\n", new Object[]{target.getVersion().getApiString()});
                this.mSdkLog.info("     Revision: %d\n", new Object[]{target.getRevision()});
            } else {
                this.mSdkLog.info("     Type: Add-On\n", new Object[0]);
                this.mSdkLog.info("     Vendor: %s\n", new Object[]{target.getVendor()});
                this.mSdkLog.info("     Revision: %d\n", new Object[]{target.getRevision()});
                if (target.getDescription() != null) {
                    this.mSdkLog.info("     Description: %s\n", new Object[]{target.getDescription()});
                }
                this.mSdkLog.info("     Based on Android %s (API level %s)\n", new Object[]{target.getVersionName(), target.getVersion().getApiString()});
                List<IAndroidTarget.OptionalLibrary> libraries = target.getAdditionalLibraries();
                if (!libraries.isEmpty()) {
                    this.mSdkLog.info("     Libraries:\n", new Object[0]);
                    for (IAndroidTarget.OptionalLibrary library : libraries) {
                        this.mSdkLog.info("      * %1$s (%2$s)\n", new Object[]{library.getName(), library.getJar().getName()});
                        this.mSdkLog.info("          %1$s\n", new Object[]{library.getDescription()});
                    }
                }
            }
            File targetLocation = new File(target.getLocation());
            ISystemImage image = this.mSdkHandler.getSystemImageManager((ProgressIndicator)progress).getImageAt(targetLocation);
            if (image != null) {
                this.displayTagAbiList((Collection<? extends ISystemImage>)ImmutableList.of((Object)image), " Tag/ABIs : ");
            }
            ++index;
        }
    }

    private void displayDeviceList() {
        ArrayList<Device> devices = new ArrayList<Device>(this.createDeviceManager().getDevices(DeviceManager.ALL_DEVICES));
        Collections.sort(devices, Device.getDisplayComparator());
        if (this.getFlagCompact()) {
            char eol = this.getFlagEolNull() ? (char)'\u0000' : '\n';
            for (Device device : devices) {
                this.mSdkLog.info("%1$s%2$c", new Object[]{device.getId(), Character.valueOf(eol)});
            }
            return;
        }
        this.mSdkLog.info("Available devices definitions:\n", new Object[0]);
        for (int index = 0; index < devices.size(); ++index) {
            Device device = (Device)devices.get(index);
            if (index > 0) {
                this.mSdkLog.info("---------\n", new Object[0]);
            }
            this.mSdkLog.info("id: %1$d or \"%2$s\"\n", new Object[]{index, device.getId()});
            this.mSdkLog.info("    Name: %s\n", new Object[]{device.getDisplayName()});
            this.mSdkLog.info("    OEM : %s\n", new Object[]{device.getManufacturer()});
            String tag = device.getTagId();
            if (tag == null) continue;
            this.mSdkLog.info("    Tag : %s\n", new Object[]{tag});
        }
    }

    private DeviceManager createDeviceManager() {
        File androidFolder;
        try {
            androidFolder = new File(AndroidLocation.getFolder());
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.mSdkLog.warning(e.getMessage(), new Object[0]);
            androidFolder = null;
        }
        return DeviceManager.createInstance(new File(this.mOsSdkFolder), androidFolder, this.mSdkLog, this.mSdkHandler.getFileOp());
    }

    private String getValidImagePaths() {
        return this.mSdkHandler.getSystemImageManager((ProgressIndicator)new ProgressIndicatorAdapter(){}).getImages().stream().map(image -> image.getPackage().getPath()).collect(Collectors.joining("\n"));
    }

    private void createAvd() {
        LocalPackage imagePkg;
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator(){

            public void logVerbose(String s) {
            }
        };
        String packagePath = this.getParamPkgPath();
        if (packagePath == null) {
            this.errorAndExit("Package path (-k) not specified. Valid system image paths are:\n" + this.getValidImagePaths(), new Object[0]);
        }
        if ((imagePkg = this.mSdkHandler.getLocalPackage(packagePath, (ProgressIndicator)progress)) == null) {
            this.errorAndExit("Package path is not valid. Valid system image paths are:\n" + this.getValidImagePaths(), new Object[0]);
        }
        assert (imagePkg != null);
        Collection sysImgs = this.mSdkHandler.getSystemImageManager((ProgressIndicator)progress).getImageMap().get((Object)imagePkg);
        if (sysImgs.isEmpty()) {
            this.errorAndExit("Package %1$s (%2$s) contains no system images. Valid system image paths are:\n%3$s", imagePkg.getDisplayName(), imagePkg.getPath(), this.getValidImagePaths());
        }
        try {
            AvdInfo newAvdInfo;
            String paramFolderPath;
            boolean removePrevious = this.getFlagForce();
            AvdManager avdManager = this.getAvdManager();
            String avdName = this.getParamName();
            if (!RE_AVD_NAME.matcher(avdName).matches()) {
                this.errorAndExit("AVD name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", avdName, CHARS_AVD_NAME);
                return;
            }
            AvdInfo info = avdManager.getAvd(avdName, false);
            if (info != null) {
                if (removePrevious) {
                    this.mSdkLog.warning("Android Virtual Device '%s' already exists and will be replaced.", new Object[]{avdName});
                } else {
                    this.errorAndExit("Android Virtual Device '%s' already exists.\nUse --force if you want to replace it.", avdName);
                    return;
                }
            }
            File avdFolder = (paramFolderPath = this.getParamLocationPath()) != null ? new File(paramFolderPath) : AvdInfo.getDefaultAvdFolder(avdManager, avdName, this.mSdkHandler.getFileOp(), false);
            IdDisplay tag = SystemImage.DEFAULT_TAG;
            String abiType = this.getParamAbi();
            String cmdTag = this.getParamTag();
            if (cmdTag == null) {
                DetailsTypes.SysImgDetailsType details = (DetailsTypes.SysImgDetailsType)imagePkg.getTypeDetails();
                tag = details.getTag();
            }
            if (abiType != null && abiType.indexOf(47) != -1) {
                String[] segments = abiType.split("/");
                if (segments.length == 2) {
                    if (cmdTag == null) {
                        cmdTag = segments[0];
                    } else if (!cmdTag.equals(segments[0])) {
                        this.errorAndExit("--%1$s %2$s conflicts with --%3$s %4$s.", KEY_TAG, cmdTag, KEY_ABI, abiType);
                    }
                    abiType = segments[1];
                } else {
                    this.errorAndExit("Invalid --%1$s %2$s: expected format 'abi' or 'tag/abi'.", KEY_ABI, abiType);
                }
            }
            if (cmdTag == null || cmdTag.length() == 0) {
                cmdTag = tag.getId();
            }
            HashSet<String> tags = new HashSet<String>();
            for (Object systemImage : sysImgs) {
                tags.add(systemImage.getTag().getId());
            }
            if (!tags.contains(cmdTag)) {
                this.errorAndExit("Invalid --%1$s %2$s for the selected package. Valid tags are:\n%3$s", KEY_TAG, cmdTag, Joiner.on((String)"\n").join(tags));
            }
            SystemImage img = null;
            if (abiType == null || abiType.length() == 0) {
                if (sysImgs.size() == 1) {
                    abiType = ((SystemImage)sysImgs.iterator().next()).getAbiType();
                    img = (SystemImage)sysImgs.iterator().next();
                    this.mSdkLog.info("Auto-selecting single ABI %1$s\n", new Object[]{abiType});
                } else {
                    this.displayTagAbiList(sysImgs, "Valid ABIs: ");
                    this.errorAndExit("This package has more than one ABI. Please specify one using --%1$s.", KEY_ABI);
                }
            } else {
                for (SystemImage systemImage : sysImgs) {
                    if (!systemImage.getAbiType().equals(abiType)) continue;
                    img = systemImage;
                    break;
                }
                if (img == null) {
                    this.displayTagAbiList(sysImgs, "Valid ABIs: ");
                    this.errorAndExit("Invalid --%1$s %2$s for the selected package.", KEY_ABI, abiType);
                }
            }
            assert (img != null);
            Device device = null;
            String deviceParam = this.getParamDevice();
            if (deviceParam != null) {
                ArrayList<Device> devices = new ArrayList<Device>(this.createDeviceManager().getDevices(DeviceManager.ALL_DEVICES));
                Collections.sort(devices, Device.getDisplayComparator());
                int index = -1;
                try {
                    index = Integer.parseInt(deviceParam);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (index >= 0 && index < devices.size()) {
                    device = (Device)devices.get(index);
                } else {
                    for (Device d : devices) {
                        if (!deviceParam.equals(d.getId())) continue;
                        device = d;
                        break;
                    }
                }
                if (device == null) {
                    this.errorAndExit("No device found matching --%1$s %2$s.", "device", deviceParam);
                }
            }
            Map<Object, Object> hardwareConfig = new TreeMap();
            if (device != null) {
                hardwareConfig = DeviceManager.getHardwareProperties(device);
            } else {
                try {
                    Map<String, String> prompted = this.promptForHardware();
                    if (prompted != null) {
                        hardwareConfig.putAll(prompted);
                    }
                }
                catch (IOException e) {
                    this.errorAndExit(e.getMessage(), new Object[0]);
                }
            }
            if (this.getParamSdCard() != null) {
                hardwareConfig.put("hw.sdCard", "yes");
            }
            if ((newAvdInfo = avdManager.createAvd(avdFolder, avdName, img, null, null, this.getParamSdCard(), hardwareConfig, device == null ? null : device.getBootProps(), false, this.getFlagSnapshot(), removePrevious, false, this.mSdkLog)) == null) {
                this.errorAndExit("AVD not created.", new Object[0]);
            }
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private void deleteAvd() {
        try {
            String avdName = this.getParamName();
            AvdManager avdManager = this.getAvdManager();
            AvdInfo info = avdManager.getAvd(avdName, false);
            if (info == null) {
                this.errorAndExit("There is no Android Virtual Device named '%s'.", avdName);
                return;
            }
            avdManager.deleteAvd(info, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private void moveAvd() {
        try {
            File originalFolder;
            String paramFolderPath;
            String avdName = this.getParamName();
            AvdManager avdManager = this.getAvdManager();
            AvdInfo info = avdManager.getAvd(avdName, true);
            if (info == null) {
                this.errorAndExit("There is no valid Android Virtual Device named '%s'.", avdName);
                return;
            }
            String newName = this.getParamMoveNewName();
            if (newName != null && newName.equals(info.getName())) {
                newName = null;
            }
            if ((paramFolderPath = this.getParamLocationPath()) != null) {
                try {
                    File f1 = new File(paramFolderPath).getCanonicalFile();
                    File f2 = new File(info.getDataFolderPath()).getCanonicalFile();
                    if (f1.equals(f2)) {
                        paramFolderPath = null;
                    }
                }
                catch (IOException e) {
                    this.errorAndExit(e.getMessage(), new Object[0]);
                    return;
                }
            }
            if (newName == null && paramFolderPath == null) {
                this.mSdkLog.warning("Move operation aborted: same AVD name, same canonical data path", new Object[0]);
                return;
            }
            if (newName != null && paramFolderPath == null && (originalFolder = new File(AndroidLocation.getFolder() + OBJECT_AVD, info.getName() + ".avd")).equals(new File(info.getDataFolderPath()))) {
                try {
                    File f = new File(AndroidLocation.getFolder() + OBJECT_AVD, newName + ".avd");
                    paramFolderPath = f.getCanonicalPath();
                }
                catch (IOException e) {
                    this.errorAndExit(e.getMessage(), new Object[0]);
                }
            }
            if (newName != null) {
                if (avdManager.getAvd(newName, false) != null) {
                    this.errorAndExit("There is already an AVD named '%s'.", newName);
                    return;
                }
                File ini = info.getIniFile();
                if (ini.equals(AvdInfo.getDefaultIniFile(avdManager, newName))) {
                    this.errorAndExit("The AVD file '%s' is in the way.", ini.getCanonicalPath());
                    return;
                }
            }
            if (paramFolderPath != null && new File(paramFolderPath).exists()) {
                this.errorAndExit("There is already a file or directory at '%s'.\nUse --path to specify a different data folder.", paramFolderPath);
            }
            if (newName != null) {
                HashMap<String, String> properties = new HashMap<String, String>(info.getProperties());
                properties.put("avd.ini.displayname", newName);
                avdManager.updateAvd(info, properties);
            }
            avdManager.moveAvd(info, newName, paramFolderPath, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException | IOException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private Map<String, String> promptForHardware() throws IOException {
        byte[] readLineBuffer = new byte[256];
        String defaultAnswer = "no";
        this.mSdkLog.info("Do you wish to create a custom hardware profile? [%s] ", new Object[]{defaultAnswer});
        String result = this.readLine(readLineBuffer).trim();
        if (result.length() == 0) {
            result = defaultAnswer;
        }
        if (!AvdManagerCli.getBooleanReply(result)) {
            return null;
        }
        this.mSdkLog.info("\n", new Object[0]);
        LocalPackage emulatorPackage = this.mSdkHandler.getLocalPackage("emulator", (ProgressIndicator)new ProgressIndicatorAdapter(){});
        if (emulatorPackage == null) {
            this.errorAndExit("\"emulator\" package must be installed!", new Object[0]);
        }
        File libDir = new File(emulatorPackage.getLocation(), "lib");
        File hardwareDefs = new File(libDir, "hardware-properties.ini");
        Map<String, HardwareProperties.HardwareProperty> hwMap = HardwareProperties.parseHardwareDefinitions(hardwareDefs, null);
        HashMap<String, String> map = new HashMap<String, String>();
        HardwareProperties.HardwareProperty[] hwProperties = hwMap.values().toArray(new HardwareProperties.HardwareProperty[hwMap.size()]);
        int i = 0;
        while (i < hwProperties.length) {
            HardwareProperties.HardwareProperty property = hwProperties[i];
            String description = property.getDescription();
            if (description != null) {
                this.mSdkLog.info("%s: %s\n", new Object[]{property.getAbstract(), description});
            } else {
                this.mSdkLog.info("%s\n", new Object[]{property.getAbstract()});
            }
            String defaultValue = property.getDefault();
            if (defaultValue != null) {
                this.mSdkLog.info("%s [%s]:", new Object[]{property.getName(), defaultValue});
            } else {
                this.mSdkLog.info("%s (%s):", new Object[]{property.getName(), property.getType()});
            }
            result = this.readLine(readLineBuffer);
            if (result.length() == 0) {
                if (defaultValue == null) continue;
                this.mSdkLog.info("\n", new Object[0]);
                ++i;
                continue;
            }
            switch (property.getType()) {
                case BOOLEAN: {
                    try {
                        if (AvdManagerCli.getBooleanReply(result)) {
                            map.put(property.getName(), "yes");
                            ++i;
                            break;
                        }
                        map.put(property.getName(), "no");
                        ++i;
                    }
                    catch (IOException e) {
                        this.mSdkLog.info("\n%s\n", new Object[]{e.getMessage()});
                    }
                    break;
                }
                case INTEGER: {
                    try {
                        Integer.parseInt(result);
                        map.put(property.getName(), result);
                        ++i;
                    }
                    catch (NumberFormatException e) {
                        this.mSdkLog.info("\n%s\n", new Object[]{e.getMessage()});
                    }
                    break;
                }
                case STRING: {
                    map.put(property.getName(), result);
                    ++i;
                    break;
                }
                case DISKSIZE: {
                    map.put(property.getName(), result);
                    ++i;
                    break;
                }
                case INTEGER_ENUM: {
                    this.errorAndExit("Program error: INTEGER_ENUM is not supported", new Object[0]);
                    break;
                }
                case STRING_ENUM: {
                    this.errorAndExit("Program error: STRING_ENUM is not supported", new Object[0]);
                }
            }
            this.mSdkLog.info("\n", new Object[0]);
        }
        return map;
    }

    private String readLine(byte[] buffer) throws IOException {
        int count = this.mInput.read(buffer);
        if (count == buffer.length && buffer[count - 1] != 10) {
            byte[] tempBuffer = new byte[256];
            String secondHalf = this.readLine(tempBuffer);
            return new String(buffer, 0, count) + secondHalf;
        }
        while (count > 0 && (buffer[count - 1] == 13 || buffer[count - 1] == 10)) {
            --count;
        }
        return new String(buffer, 0, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String promptPassword(String prompt) throws IOException {
        AtomicBoolean keepErasing = new AtomicBoolean(true);
        Thread eraser = new Thread(() -> {
            while (keepErasing.get()) {
                System.err.print("\b ");
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }, "eraser");
        try {
            System.err.print(prompt);
            eraser.start();
            byte[] buffer = new byte[256];
            String string = this.readLine(buffer);
            return string;
        }
        finally {
            keepErasing.set(false);
            try {
                eraser.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static boolean getBooleanReply(String reply) throws IOException {
        for (String valid : BOOLEAN_YES_REPLIES) {
            if (!valid.equalsIgnoreCase(reply)) continue;
            return true;
        }
        for (String valid : BOOLEAN_NO_REPLIES) {
            if (!valid.equalsIgnoreCase(reply)) continue;
            return false;
        }
        throw new IOException(String.format("%s is not a valid reply", reply));
    }

    private void errorAndExit(String format, Object ... args) {
        this.mSdkLog.error(null, format, args);
        throw new RuntimeException();
    }

    AvdManagerCli(ILogger logger, AndroidSdkHandler sdkHandler, String sdkRoot, String avdRoot, InputStream input) {
        this(logger);
        this.mSdkHandler = sdkHandler;
        this.mOsSdkFolder = sdkRoot;
        this.mInput = input;
        this.mAvdFolder = avdRoot;
    }

    private AvdManagerCli(ILogger logger) {
        super(logger, ACTIONS);
        this.mSdkLog = logger;
        this.define(CommandLineParser.Mode.BOOLEAN, false, "@@internal@@", "", "", KEY_CLEAR_CACHE, "Clear the SDK Manager repository manifest cache.", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, OBJECT_AVD, "c", KEY_COMPACT, "Compact output (suitable for scripts)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, OBJECT_AVD, "0", KEY_EOL_NULL, "Terminates lines with \\0 instead of \\n (e.g. for xargs -0). Only used by --compact.", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, OBJECT_TARGET, "c", KEY_COMPACT, "Compact output (suitable for scripts)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, OBJECT_TARGET, "0", KEY_EOL_NULL, "Terminates lines with \\0 instead of \\n (e.g. for xargs -0) Only used by --compact.", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "device", "c", KEY_COMPACT, "Compact output (suitable for scripts)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_LIST, "device", "0", KEY_EOL_NULL, "Terminates lines with \\0 instead of \\n (e.g. for xargs -0) Only used by --compact.", false);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "p", KEY_PATH, "Directory where the new AVD will be created.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_CREATE, OBJECT_AVD, "n", KEY_NAME, "Name of the new AVD.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "k", KEY_IMAGE_PACKAGE, "Package path of the system image for this AVD (e.g. 'system-images;android-19;google_apis;x86').", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "c", KEY_SDCARD, "Path to a shared SD card image, or size of a new sdcard for the new AVD.", null);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_CREATE, OBJECT_AVD, "f", KEY_FORCE, "Forces creation (overwrites an existing AVD)", false);
        this.define(CommandLineParser.Mode.BOOLEAN, false, VERB_CREATE, OBJECT_AVD, "a", KEY_SNAPSHOT, "Place a snapshots file in the AVD, to enable persistence.", false);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "b", KEY_ABI, "The ABI to use for the AVD. The default is to auto-select the ABI if the platform has only one ABI for its system images.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "g", KEY_TAG, "The sys-img tag to use for the AVD. The default is to auto-select if the platform has only one tag for its system images.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "d", "device", "The optional device definition to use. Can be a device index or id.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_DELETE, OBJECT_AVD, "n", KEY_NAME, "Name of the AVD to delete.", null);
        this.define(CommandLineParser.Mode.STRING, true, VERB_MOVE, OBJECT_AVD, "n", KEY_NAME, "Name of the AVD to move or rename.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_MOVE, OBJECT_AVD, "r", KEY_RENAME, "New name of the AVD.", null);
        this.define(CommandLineParser.Mode.STRING, false, VERB_MOVE, OBJECT_AVD, "p", KEY_PATH, "Path to the AVD's new directory.", null);
    }

    @Override
    public boolean acceptLackOfVerb() {
        return true;
    }

    private String getParamLocationPath() {
        return (String)this.getValue(null, null, KEY_PATH);
    }

    private String getParamPkgPath() {
        return (String)this.getValue(null, null, KEY_IMAGE_PACKAGE);
    }

    private String getParamName() {
        return (String)this.getValue(null, null, KEY_NAME);
    }

    private String getParamSdCard() {
        return (String)this.getValue(null, null, KEY_SDCARD);
    }

    private boolean getFlagForce() {
        return (Boolean)this.getValue(null, null, KEY_FORCE);
    }

    private boolean getFlagSnapshot() {
        return (Boolean)this.getValue(null, null, KEY_SNAPSHOT);
    }

    private String getParamMoveNewName() {
        return (String)this.getValue(VERB_MOVE, null, KEY_RENAME);
    }

    private String getParamAbi() {
        return (String)this.getValue(null, null, KEY_ABI);
    }

    private String getParamTag() {
        return (String)this.getValue(null, null, KEY_TAG);
    }

    private String getParamDevice() {
        return (String)this.getValue(null, null, "device");
    }

    private boolean getFlagCompact() {
        return (Boolean)this.getValue(null, null, KEY_COMPACT);
    }

    private boolean getFlagEolNull() {
        return (Boolean)this.getValue(null, null, KEY_EOL_NULL);
    }
}

