/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.targets;

import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.AddonTarget;
import com.android.sdklib.repository.targets.PlatformTarget;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class AndroidTargetManager {
    private Map<LocalPackage, IAndroidTarget> mTargets;
    private final AndroidSdkHandler mSdkHandler;
    private Map<String, String> mLoadErrors;
    private static final Comparator<LocalPackage> TARGET_COMPARATOR = Comparator.comparing(localPackage -> ((DetailsTypes.ApiDetailsType)localPackage.getTypeDetails()).getAndroidVersion()).thenComparing(RepoPackage::getPath).thenComparing(localPackage -> localPackage.getTypeDetails().getClass().getName());

    public AndroidTargetManager(AndroidSdkHandler handler) {
        this.mSdkHandler = handler;
    }

    public Collection<IAndroidTarget> getTargets(ProgressIndicator progress) {
        return this.getTargetMap(progress).values();
    }

    private Map<LocalPackage, IAndroidTarget> getTargetMap(ProgressIndicator progress) {
        if (this.mTargets == null) {
            TypeDetails details;
            HashMap newErrors = Maps.newHashMap();
            RepoManager manager = this.mSdkHandler.getSdkManager(progress);
            HashMap platformTargets = Maps.newHashMap();
            HashBiMap tempTargetToPackage = HashBiMap.create();
            for (LocalPackage p : manager.getPackages().getLocalPackages().values()) {
                details = p.getTypeDetails();
                if (!(details instanceof DetailsTypes.PlatformDetailsType)) continue;
                try {
                    PlatformTarget target = new PlatformTarget(p, this.mSdkHandler, progress);
                    AndroidVersion androidVersion = target.getVersion();
                    PlatformTarget existing = (PlatformTarget)platformTargets.get(androidVersion);
                    if (existing != null && !p.getPath().equals(DetailsTypes.getPlatformPath(androidVersion))) continue;
                    if (existing != null) {
                        tempTargetToPackage.remove((Object)existing);
                    }
                    platformTargets.put(androidVersion, target);
                    tempTargetToPackage.put((Object)target, (Object)p);
                }
                catch (IllegalArgumentException e) {
                    newErrors.put(p.getPath(), e.getMessage());
                }
            }
            for (LocalPackage p : manager.getPackages().getLocalPackages().values()) {
                AndroidVersion addonVersion;
                PlatformTarget baseTarget;
                details = p.getTypeDetails();
                if (!(details instanceof DetailsTypes.AddonDetailsType) || (baseTarget = (PlatformTarget)platformTargets.get(addonVersion = ((DetailsTypes.AddonDetailsType)details).getAndroidVersion())) == null) continue;
                tempTargetToPackage.put((Object)new AddonTarget(p, baseTarget, progress), (Object)p);
            }
            TreeMap result = Maps.newTreeMap(TARGET_COMPARATOR);
            result.putAll(tempTargetToPackage.inverse());
            for (LocalPackage p : manager.getPackages().getLocalPackagesForPrefix("sources")) {
                PlatformTarget target;
                TypeDetails details2 = p.getTypeDetails();
                if (!(details2 instanceof DetailsTypes.ApiDetailsType) || (target = (PlatformTarget)platformTargets.get(((DetailsTypes.ApiDetailsType)details2).getAndroidVersion())) == null) continue;
                target.setSources(p.getLocation());
            }
            this.mTargets = result;
            this.mLoadErrors = newErrors;
        }
        return this.mTargets;
    }

    public IAndroidTarget getTargetFromHashString(String hash, ProgressIndicator progress) {
        if (hash != null) {
            for (IAndroidTarget target : this.getTargets(progress)) {
                if (target == null || !hash.equals(AndroidTargetHash.getTargetHashString(target))) continue;
                return target;
            }
        }
        return null;
    }

    public IAndroidTarget getTargetOfAtLeastApiLevel(int minimumApiLevel, ProgressIndicator progress) {
        for (IAndroidTarget target : this.getTargets(progress)) {
            if (target.getVersion().getApiLevel() < minimumApiLevel) continue;
            return target;
        }
        return null;
    }

    public String getErrorForPackage(String path) {
        if (this.mLoadErrors == null) {
            this.getTargetMap((ProgressIndicator)new ConsoleProgressIndicator());
        }
        return this.mLoadErrors.get(path);
    }

    public IAndroidTarget getTargetFromPackage(LocalPackage p, ProgressIndicator progress) {
        return this.getTargetMap(progress).get(p);
    }
}

