/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.utils.ILogger;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HardwareProperties {
    public static final String HW_MAINKEYS = "hw.mainKeys";
    public static final String HW_TRACKBALL = "hw.trackBall";
    public static final String HW_KEYBOARD = "hw.keyboard";
    public static final String HW_DPAD = "hw.dPad";
    public static final String HW_GPS = "hw.gps";
    public static final String HW_BATTERY = "hw.battery";
    public static final String HW_ACCELEROMETER = "hw.accelerometer";
    public static final String HW_ORIENTATION_SENSOR = "hw.sensors.orientation";
    public static final String HW_AUDIO_INPUT = "hw.audioInput";
    public static final String HW_SDCARD = "hw.sdCard";
    public static final String HW_LCD_DENSITY = "hw.lcd.density";
    public static final String HW_LCD_WIDTH = "hw.lcd.width";
    public static final String HW_LCD_HEIGHT = "hw.lcd.height";
    public static final String HW_KEYBOARD_LID = "hw.keyboard.lid";
    public static final String HW_LCD_FOLDED_X_OFFSET = "hw.displayRegion.0.1.xOffset";
    public static final String HW_LCD_FOLDED_Y_OFFSET = "hw.displayRegion.0.1.yOffset";
    public static final String HW_LCD_FOLDED_WIDTH = "hw.displayRegion.0.1.width";
    public static final String HW_LCD_FOLDED_HEIGHT = "hw.displayRegion.0.1.height";
    public static final String HW_LCD_FOLDED_X_OFFSET_2 = "hw.displayRegion.0.2.xOffset";
    public static final String HW_LCD_FOLDED_Y_OFFSET_2 = "hw.displayRegion.0.2.yOffset";
    public static final String HW_LCD_FOLDED_WIDTH_2 = "hw.displayRegion.0.2.width";
    public static final String HW_LCD_FOLDED_HEIGHT_2 = "hw.displayRegion.0.2.height";
    public static final String HW_LCD_FOLDED_X_OFFSET_3 = "hw.displayRegion.0.3.xOffset";
    public static final String HW_LCD_FOLDED_Y_OFFSET_3 = "hw.displayRegion.0.3.yOffset";
    public static final String HW_LCD_FOLDED_WIDTH_3 = "hw.displayRegion.0.3.width";
    public static final String HW_LCD_FOLDED_HEIGHT_3 = "hw.displayRegion.0.3.height";
    public static final String HW_PROXIMITY_SENSOR = "hw.sensors.proximity";
    public static final String HW_INITIAL_ORIENTATION = "hw.initialOrientation";
    private static final Pattern PATTERN_PROP = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    private static final String HW_PROP_NAME = "name";
    private static final String HW_PROP_TYPE = "type";
    private static final String HW_PROP_DEFAULT = "default";
    private static final String HW_PROP_ABSTRACT = "abstract";
    private static final String HW_PROP_DESC = "description";
    private static final String HW_PROP_ENUM = "enum";
    public static final String BOOLEAN_YES = "yes";
    public static final String BOOLEAN_NO = "no";
    public static final Pattern DISKSIZE_PATTERN = Pattern.compile("\\d+[MK]B");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, HardwareProperty> parseHardwareDefinitions(IAbstractFile propFile, ILogger log) {
        TreeMap<String, HardwareProperty> treeMap;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(propFile.getContents(), "UTF-8"));
            TreeMap<String, HardwareProperty> map = new TreeMap<String, HardwareProperty>();
            String line = null;
            HardwareProperty prop = null;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                Matcher m = PATTERN_PROP.matcher(line);
                if (m.matches()) {
                    String s;
                    int i;
                    String key = m.group(1);
                    String value = m.group(2);
                    if (HW_PROP_NAME.equals(key)) {
                        prop = new HardwareProperty();
                        prop.mName = value;
                        map.put(prop.mName, prop);
                    }
                    if (prop == null) {
                        log.warning("Error parsing '%1$s': missing '%2$s'", new Object[]{propFile.getOsLocation(), HW_PROP_NAME});
                        Map<String, HardwareProperty> map2 = null;
                        return map2;
                    }
                    if (HW_PROP_TYPE.equals(key)) {
                        prop.mType = HardwarePropertyType.getEnum(value, false);
                        if ($assertionsDisabled || prop.mType != null) continue;
                        throw new AssertionError();
                    }
                    if (HW_PROP_DEFAULT.equals(key)) {
                        prop.mDefault = value;
                        continue;
                    }
                    if (HW_PROP_ABSTRACT.equals(key)) {
                        prop.mAbstract = value;
                        continue;
                    }
                    if (HW_PROP_DESC.equals(key)) {
                        prop.mDescription = value;
                        continue;
                    }
                    if (!HW_PROP_ENUM.equals(key)) continue;
                    if (!prop.mType.isEnum()) {
                        prop.mType = HardwarePropertyType.getEnum(prop.mType.getName(), true);
                        assert (prop.mType != null);
                    }
                    String[] v = value.split(",");
                    int n = 0;
                    for (i = 0; i < v.length; ++i) {
                        v[i] = v[i].trim();
                        s = v[i];
                        if (s.isEmpty()) continue;
                        ++n;
                    }
                    HardwareProperty.access$502(prop, new String[n]);
                    n = 0;
                    for (i = 0; i < v.length; ++i) {
                        s = v[i];
                        if (s.isEmpty()) continue;
                        ((HardwareProperty)prop).mEnum[n++] = s;
                    }
                    continue;
                }
                log.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", new Object[]{propFile.getOsLocation(), line});
                Map<String, HardwareProperty> map3 = null;
                return map3;
            }
            treeMap = map;
        }
        catch (StreamException e) {
            log.warning("Error parsing '%1$s': %2$s.", new Object[]{propFile.getOsLocation(), e.getMessage()});
            return null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            log.warning("Error parsing '%1$s': %2$s.", new Object[]{propFile.getOsLocation(), e.getMessage()});
            return null;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return treeMap;
    }

    public static String getBooleanValue(int index) {
        if (index == 0) {
            return BOOLEAN_YES;
        }
        if (index == 1) {
            return BOOLEAN_NO;
        }
        throw new IndexOutOfBoundsException("HardwareProperty boolean index must 0 (true) or 1 (false) but was " + index);
    }

    public static int getBooleanValueIndex(String value) {
        if (BOOLEAN_YES.equals(value)) {
            return 0;
        }
        if (BOOLEAN_NO.equals(value)) {
            return 1;
        }
        return -1;
    }

    public static final class HardwareProperty {
        private String mName = "";
        private HardwarePropertyType mType;
        private String mDefault = "";
        private String[] mEnum;
        private String mAbstract = "";
        private String mDescription = "";

        public String getName() {
            return this.mName;
        }

        public HardwarePropertyType getType() {
            return this.mType;
        }

        public String getDefault() {
            return this.mDefault;
        }

        public String getAbstract() {
            return this.mAbstract;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String[] getEnum() {
            return this.mEnum;
        }

        public boolean isValidForUi() {
            return this.mType != HardwarePropertyType.STRING || this.mType.isEnum();
        }

        static /* synthetic */ String[] access$502(HardwareProperty x0, String[] x1) {
            x0.mEnum = x1;
            return x1;
        }
    }

    public static enum HardwarePropertyType {
        INTEGER("integer", false),
        BOOLEAN("boolean", false),
        DISKSIZE("diskSize", false),
        STRING("string", false),
        INTEGER_ENUM("integer", true),
        STRING_ENUM("string", true);

        private String mName;
        private boolean mIsEnum;

        private HardwarePropertyType(String name, boolean isEnum) {
            this.mName = name;
            this.mIsEnum = isEnum;
        }

        public String getName() {
            return this.mName;
        }

        public boolean isEnum() {
            return this.mIsEnum;
        }

        public static HardwarePropertyType getEnum(String name, boolean isEnum) {
            for (HardwarePropertyType type : HardwarePropertyType.values()) {
                if (!type.mName.equals(name) || type.mIsEnum != isEnum) continue;
                return type;
            }
            return null;
        }
    }
}

