/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRound;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Hinge;
import com.android.sdklib.devices.Meta;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Device {
    public static final double MINIMUM_TABLET_SIZE = 7.0;
    public static final double MINIMUM_TV_SIZE = 15.0;
    private final String mName;
    private final String mId;
    private final String mManufacturer;
    private final boolean mHasPlayStore;
    private final ImmutableList<Software> mSoftware;
    private final ImmutableList<State> mState;
    private final Meta mMeta;
    private final State mDefaultState;
    private final String mTagId;
    private final ImmutableMap<String, String> mBootProps;
    private final boolean mIsDeprecated;
    private static Pattern PATTERN = Pattern.compile("(\\d+\\.?\\d*)(?:in|\") (.+?)( \\(.*Nexus.*\\))?");

    @Deprecated
    public String getName() {
        return this.mName;
    }

    public String getDisplayName() {
        return this.mName;
    }

    public String getId() {
        return this.mId;
    }

    public boolean hasPlayStore() {
        return this.mHasPlayStore;
    }

    public String getManufacturer() {
        return this.mManufacturer;
    }

    public List<Software> getAllSoftware() {
        return this.mSoftware;
    }

    public List<State> getAllStates() {
        return this.mState;
    }

    public Hardware getDefaultHardware() {
        return this.mDefaultState.getHardware();
    }

    public Meta getMeta() {
        return this.mMeta;
    }

    public State getDefaultState() {
        return this.mDefaultState;
    }

    public Software getSoftware(int apiVersion) {
        for (Software s : this.mSoftware) {
            if (apiVersion < s.getMinSdkLevel() || apiVersion > s.getMaxSdkLevel()) continue;
            return s;
        }
        return null;
    }

    public State getState(String name) {
        for (State s : this.getAllStates()) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public Dimension getScreenSize(ScreenOrientation orientation) {
        int screenHeight;
        int screenWidth;
        int y;
        int x;
        Screen screen = this.getDefaultHardware().getScreen();
        if (screen == null) {
            return null;
        }
        Hinge hinge = this.getDefaultHardware().getHinge();
        if (hinge != null && hinge.getChangeOrientationOnFold()) {
            if (orientation == ScreenOrientation.PORTRAIT) {
                orientation = ScreenOrientation.LANDSCAPE;
            } else if (orientation == ScreenOrientation.LANDSCAPE) {
                orientation = ScreenOrientation.PORTRAIT;
            }
        }
        if ((x = screen.getXDimension()) > (y = screen.getYDimension())) {
            if (orientation == ScreenOrientation.LANDSCAPE) {
                screenWidth = x;
                screenHeight = y;
            } else {
                screenWidth = y;
                screenHeight = x;
            }
        } else if (orientation == ScreenOrientation.LANDSCAPE) {
            screenWidth = y;
            screenHeight = x;
        } else {
            screenWidth = x;
            screenHeight = y;
        }
        return new Dimension(screenWidth, screenHeight);
    }

    public String getTagId() {
        return this.mTagId;
    }

    public Map<String, String> getBootProps() {
        return this.mBootProps;
    }

    public boolean isScreenRound() {
        return this.getDefaultHardware().getScreen().getScreenRound() == ScreenRound.ROUND;
    }

    public int getChinSize() {
        return this.getDefaultHardware().getScreen().getChin();
    }

    public boolean getIsDeprecated() {
        return this.mIsDeprecated;
    }

    private Device(Builder b) {
        this.mName = b.mName;
        this.mId = b.mId;
        this.mManufacturer = b.mManufacturer;
        this.mHasPlayStore = b.mHasPlayStore;
        this.mSoftware = ImmutableList.copyOf(b.mSoftware);
        this.mState = ImmutableList.copyOf(b.mState);
        this.mMeta = b.mMeta;
        this.mDefaultState = b.mDefaultState;
        this.mTagId = b.mTagId;
        this.mBootProps = ImmutableMap.copyOf(b.mBootProps);
        this.mIsDeprecated = b.mDeprecated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Device)) {
            return false;
        }
        Device d = (Device)o;
        return this.mName.equals(d.getDisplayName()) && Objects.equals(this.mId, d.getId()) && Objects.equals(this.mManufacturer, d.getManufacturer()) && Objects.equals(this.mSoftware, d.getAllSoftware()) && Objects.equals(this.mState, d.getAllStates()) && Objects.equals(this.mMeta, d.getMeta()) && Objects.equals(this.mDefaultState, d.getDefaultState()) && this.mIsDeprecated == d.mIsDeprecated && this.mHasPlayStore == d.mHasPlayStore && Objects.equals(this.mTagId, d.mTagId) && Objects.equals(this.mBootProps, d.mBootProps);
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mId, this.mManufacturer, this.mSoftware, this.mState, this.mMeta, this.mDefaultState, this.mIsDeprecated, this.mHasPlayStore, this.mTagId, this.mBootProps);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Device [mName=");
        sb.append(this.mName);
        sb.append(", mId=");
        sb.append(this.mId);
        sb.append(", mManufacturer=");
        sb.append(this.mManufacturer);
        sb.append(", mSoftware=");
        sb.append(this.mSoftware);
        sb.append(", mState=");
        sb.append(this.mState);
        sb.append(", mMeta=");
        sb.append(this.mMeta);
        sb.append(", mDefaultState=");
        sb.append(this.mDefaultState);
        sb.append(", mTagId=");
        sb.append(this.mTagId);
        sb.append(", mBootProps=");
        sb.append(this.mBootProps);
        sb.append("]");
        return sb.toString();
    }

    private String getSortableName() {
        Object sortableName = this.mName;
        Matcher matcher = PATTERN.matcher((CharSequence)sortableName);
        if (matcher.matches()) {
            Object size = matcher.group(1);
            String n = matcher.group(2);
            int dot = ((String)size).indexOf(46);
            if (dot == -1) {
                size = (String)size + ".0";
                dot = ((String)size).length() - 2;
            }
            if (dot < 3) {
                size = "000".substring(dot) + (String)size;
            }
            sortableName = (String)size + "\" " + n;
        }
        return sortableName;
    }

    public static Comparator<Device> getDisplayComparator() {
        return new Comparator<Device>(){

            @Override
            public int compare(Device d1, Device d2) {
                String s1 = d1.getSortableName();
                String s2 = d2.getSortableName();
                if (s1.length() > 1 && s2.length() > 1) {
                    int i2;
                    int i1 = Character.isDigit(s1.charAt(0)) ? 1 : 0;
                    int n = i2 = Character.isDigit(s2.charAt(0)) ? 1 : 0;
                    if (i1 != i2) {
                        return i1 - i2;
                    }
                }
                return s1.compareTo(s2);
            }
        };
    }

    public static boolean isRollable(String deviceId) {
        return deviceId.equals("7.4in Rollable");
    }

    public static boolean isPhone(Device device) {
        return device.getTagId() == null && !Device.hasTabletScreen(device);
    }

    public static boolean isTablet(Device device) {
        return device.getTagId() == null && Device.hasTabletScreen(device);
    }

    private static boolean hasTabletScreen(Device device) {
        Screen screen = device.getDefaultHardware().getScreen();
        return screen.getDiagonalLength() >= 7.0 && !screen.isFoldable();
    }

    public static boolean isWear(Device device) {
        return device != null && "android-wear".equals(device.getTagId());
    }

    public static boolean isThings(Device device) {
        return device != null && "android-things".equals(device.getTagId());
    }

    public static boolean isTv(Device device) {
        return device != null && ("android-tv".equals(device.getTagId()) || "google-tv".equals(device.getTagId()));
    }

    public static boolean isAutomotive(Device device) {
        return device != null && ("android-automotive".equals(device.getTagId()) || "android-automotive-playstore".equals(device.getTagId()) || "android-automotive-distantdisplay".equals(device.getTagId()));
    }

    public static boolean isAutomotiveDistantDisplay(Device device) {
        return device != null && "android-automotive-distantdisplay".equals(device.getTagId());
    }

    public static boolean isDesktop(Device device) {
        return device != null && "android-desktop".equals(device.getTagId());
    }

    public static boolean isXr(Device device) {
        String tagId = device != null ? device.getTagId() : null;
        return tagId != null && tagId.startsWith("android-xr");
    }

    public static boolean isXrHeadset(Device device) {
        return SystemImageTags.XR_HEADSET_TAG.getId().equals(device != null ? device.getTagId() : null);
    }

    public static boolean isXrGlasses(Device device) {
        return SystemImageTags.XR_GLASSES_TAG.getId().equals(device != null ? device.getTagId() : null);
    }

    public static boolean isMobile(Device device) {
        return !Device.isTv(device) && !Device.isWear(device) && !Device.isThings(device) && !Device.isAutomotive(device) && !Device.isDesktop(device) && !Device.isXr(device);
    }

    public static class Builder {
        private String mName;
        private String mId;
        private String mManufacturer;
        private boolean mHasPlayStore;
        private final List<Software> mSoftware = new ArrayList<Software>();
        private final List<State> mState = new ArrayList<State>();
        private Meta mMeta;
        private State mDefaultState;
        private String mTagId;
        private final Map<String, String> mBootProps = new TreeMap<String, String>();
        private boolean mDeprecated;

        public Builder() {
        }

        public Builder(Device d) {
            this.mTagId = d.getTagId();
            this.mName = d.getDisplayName();
            this.mId = d.getId();
            this.mManufacturer = d.getManufacturer();
            this.mHasPlayStore = d.hasPlayStore();
            for (Software software : d.getAllSoftware()) {
                this.mSoftware.add(software.deepCopy());
            }
            for (State state : d.getAllStates()) {
                this.mState.add(state.deepCopy());
            }
            this.mMeta = d.getMeta();
            this.mDeprecated = d.mIsDeprecated;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public void setId(String id) {
            this.mId = id;
        }

        public void setTagId(String tagId) {
            this.mTagId = tagId;
            if (SystemImageTags.WEAR_TAG.getId().equals(this.mTagId)) {
                this.mHasPlayStore = true;
            }
        }

        public void addBootProp(String propName, String propValue) {
            this.mBootProps.put(propName, propValue);
        }

        public void setManufacturer(String manufacturer) {
            this.mManufacturer = manufacturer;
        }

        public void setPlayStore(boolean hasPlayStore) {
            this.mHasPlayStore = hasPlayStore;
            if (SystemImageTags.WEAR_TAG.getId().equals(this.mTagId)) {
                this.mHasPlayStore = true;
            }
        }

        public void addSoftware(Software sw) {
            this.mSoftware.add(sw);
        }

        public void addAllSoftware(Collection<? extends Software> sw) {
            this.mSoftware.addAll(sw);
        }

        public void addState(State state) {
            this.mState.add(state);
        }

        public void addAllState(Collection<? extends State> states) {
            this.mState.addAll(states);
        }

        public boolean removeState(String stateName) {
            for (int i = 0; i < this.mState.size(); ++i) {
                if (stateName == null || !stateName.equals(this.mState.get(i).getName())) continue;
                this.mState.remove(i);
                return true;
            }
            return false;
        }

        List<State> getAllStates() {
            return this.mState;
        }

        public void setMeta(Meta meta) {
            this.mMeta = meta;
        }

        public void setDeprecated(boolean deprecated) {
            this.mDeprecated = deprecated;
        }

        public Device build() {
            if (this.mName == null) {
                throw this.generateBuildException("Device missing name");
            }
            if (this.mManufacturer == null) {
                throw this.generateBuildException("Device missing manufacturer");
            }
            if (this.mSoftware.size() <= 0) {
                throw this.generateBuildException("Device software not configured");
            }
            if (this.mState.size() <= 0) {
                throw this.generateBuildException("Device states not configured");
            }
            if (this.mId == null) {
                this.mId = this.mName;
            }
            if (this.mMeta == null) {
                this.mMeta = new Meta();
            }
            boolean deviceIsRound = false;
            for (State s : this.mState) {
                Screen screen;
                if (s.isDefaultState()) {
                    this.mDefaultState = s;
                }
                if ((screen = s.getHardware().getScreen()) == null || !ScreenRound.ROUND.equals((Object)screen.getScreenRound())) continue;
                deviceIsRound = true;
            }
            if (deviceIsRound) {
                this.mBootProps.put("ro.emulator.circular", "true");
            }
            if (this.mDefaultState == null) {
                throw this.generateBuildException("Device missing default state");
            }
            return new Device(this);
        }

        private IllegalStateException generateBuildException(String err) {
            Object device = "";
            if (this.mManufacturer != null) {
                device = this.mManufacturer + " ";
            }
            device = this.mName != null ? (String)device + this.mName : "Unknown " + (String)device + "Device";
            return new IllegalStateException("Error building " + (String)device + ": " + err);
        }
    }
}

