/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.sdklib.devices.Device;
import com.android.sdklib.internal.avd.GenericSkin;
import com.android.sdklib.internal.avd.OnDiskSkin;
import com.android.sdklib.internal.avd.Skin;
import java.awt.Dimension;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\u0003*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"GENERIC_SKIN_PATTERN", "Lkotlin/text/Regex;", "skinFromConfig", "Lcom/android/sdklib/internal/avd/Skin;", "config", "", "", "defaultGenericSkin", "Lcom/android/sdklib/devices/Device;", "sdklib"})
@JvmName(name="Skins")
public final class Skins {
    @NotNull
    private static final Regex GENERIC_SKIN_PATTERN = new Regex("(\\d+)x(\\d+)(x\\d+)?");

    @Nullable
    public static final Skin skinFromConfig(@NotNull Map<String, String> config) {
        MatchResult match;
        Intrinsics.checkNotNullParameter(config, (String)"config");
        String name = config.get("skin.name");
        String path = config.get("skin.path");
        if (name != null && (path == null || Intrinsics.areEqual((Object)name, (Object)path)) && (match = GENERIC_SKIN_PATTERN.matchEntire((CharSequence)name)) != null) {
            return new GenericSkin(Integer.parseInt((String)match.getGroupValues().get(1)), Integer.parseInt((String)match.getGroupValues().get(2)));
        }
        if (path != null && !Intrinsics.areEqual((Object)path, (Object)"_no_skin")) {
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            return new OnDiskSkin(path2);
        }
        return null;
    }

    @Nullable
    public static final Skin defaultGenericSkin(@NotNull Device $this$defaultGenericSkin) {
        GenericSkin genericSkin;
        Intrinsics.checkNotNullParameter((Object)$this$defaultGenericSkin, (String)"<this>");
        Dimension dimension = $this$defaultGenericSkin.getScreenSize($this$defaultGenericSkin.getDefaultState().getOrientation());
        if (dimension != null) {
            Dimension it = dimension;
            boolean bl = false;
            genericSkin = new GenericSkin(it.width, it.height);
        } else {
            genericSkin = null;
        }
        return genericSkin;
    }
}

