/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.repository.Revision;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.repository.IdDisplay;
import java.nio.file.Path;
import java.util.List;

public interface ISystemImage
extends Comparable<ISystemImage> {
    public static final String WEAR_CN_DIRECTORY = "android-wear-cn";

    public Path getLocation();

    @Deprecated
    default public IdDisplay getTag() {
        return this.getTags().stream().findFirst().orElse(SystemImageTags.DEFAULT_TAG);
    }

    public List<IdDisplay> getTags();

    public IdDisplay getAddonVendor();

    public String getAbiType();

    public Path[] getSkins();

    public Revision getRevision();

    public AndroidVersion getAndroidVersion();

    public boolean obsolete();

    default public boolean hasGoogleApis() {
        return SystemImageTags.hasGoogleApi(this.getTags());
    }

    default public boolean hasPlayStore() {
        if (this.getTags().contains(SystemImageTags.PLAY_STORE_TAG)) {
            return true;
        }
        if (SystemImageTags.AUTOMOTIVE_PLAY_STORE_TAG.equals(this.getTag())) {
            return true;
        }
        return SystemImageTags.WEAR_TAG.equals(this.getTag()) && this.getAndroidVersion().getApiLevel() >= 25 && !this.getPackage().getPath().contains(WEAR_CN_DIRECTORY);
    }

    public RepoPackage getPackage();

    public static enum LocationType {
        IN_LEGACY_FOLDER,
        IN_IMAGES_SUBFOLDER,
        IN_SYSTEM_IMAGE;

    }
}

