/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.SdkConstants;
import com.android.annotations.concurrency.Slow;
import com.android.io.CancellableFileIo;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.prefs.AndroidLocationsException;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdBuilder;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdNames;
import com.android.sdklib.internal.avd.AvdNamesKt;
import com.android.sdklib.internal.avd.EmulatorPackage;
import com.android.sdklib.internal.avd.EmulatorPackages;
import com.android.sdklib.internal.avd.GenericSkin;
import com.android.sdklib.internal.avd.InternalSdCard;
import com.android.sdklib.internal.avd.OnDiskSkin;
import com.android.sdklib.internal.avd.SdCard;
import com.android.sdklib.internal.avd.SdCards;
import com.android.sdklib.internal.avd.Skin;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.FileUtils;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import com.android.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalLong;
import java.util.Scanner;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AvdManager {
    private static final Pattern INI_LINE_PATTERN = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    public static final String AVD_FOLDER_EXTENSION = ".avd";
    public static final Pattern NUMERIC_SKIN_SIZE = Pattern.compile("([0-9]{2,})x([0-9]{2,})");
    public static final String DATA_FOLDER = "data";
    public static final String USERDATA_IMG = "userdata.img";
    public static final String USERDATA_QEMU_IMG = "userdata-qemu.img";
    public static final String SNAPSHOTS_DIRECTORY = "snapshots";
    public static final String USER_SETTINGS_INI = "user-settings.ini";
    private static final String BOOT_PROP = "boot.prop";
    static final String CONFIG_INI = "config.ini";
    private static final String HARDWARE_QEMU_INI = "hardware-qemu.ini";
    private static final String SDCARD_IMG = "sdcard.img";
    static final String INI_EXTENSION = ".ini";
    private static final Pattern INI_NAME_PATTERN = Pattern.compile("(.+)\\.ini$", 2);
    private static final Pattern IMAGE_NAME_PATTERN = Pattern.compile("(.+)\\.img$", 2);
    public static final String HARDWARE_INI = "hardware.ini";
    private final AndroidSdkHandler mSdkHandler;
    private final Path mBaseAvdFolder;
    private final ILogger mLog;
    private final DeviceManager mDeviceManager;
    private final ArrayList<AvdInfo> mAllAvdList = new ArrayList();
    private ImmutableList<AvdInfo> mValidAvdList;

    private AvdManager(AndroidSdkHandler sdkHandler, Path baseAvdFolder, DeviceManager deviceManager, ILogger log) {
        if (sdkHandler.getLocation() == null) {
            throw new IllegalArgumentException("Local SDK path not set!");
        }
        this.mSdkHandler = sdkHandler;
        this.mBaseAvdFolder = baseAvdFolder;
        this.mLog = log;
        this.mDeviceManager = deviceManager;
        try {
            this.buildAvdList(this.mAllAvdList);
        }
        catch (AndroidLocationsException e) {
            this.mLog.warning("Constructing AvdManager: %s", new Object[]{e.getMessage()});
        }
    }

    public static AvdManager createInstance(AndroidSdkHandler sdkHandler, Path baseAvdFolder, DeviceManager deviceManager, ILogger log) {
        return new AvdManager(sdkHandler, baseAvdFolder, deviceManager, log);
    }

    public Path getBaseAvdFolder() {
        return this.mBaseAvdFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getAllAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            return this.mAllAvdList.toArray(new AvdInfo[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<AvdInfo> getValidAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mValidAvdList == null) {
                this.mValidAvdList = (ImmutableList)this.mAllAvdList.stream().filter(avd -> avd.getStatus() == AvdInfo.AvdStatus.OK).collect(ImmutableList.toImmutableList());
            }
            return this.mValidAvdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo getAvd(String name, boolean validAvdOnly) {
        boolean ignoreCase;
        boolean bl = ignoreCase = SdkConstants.currentPlatform() == 2;
        if (validAvdOnly) {
            for (AvdInfo info : this.getValidAvds()) {
                String name2 = info.getName();
                if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                return info;
            }
        } else {
            ArrayList<AvdInfo> arrayList = this.mAllAvdList;
            synchronized (arrayList) {
                for (AvdInfo info : this.mAllAvdList) {
                    String name2 = info.getName();
                    if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                    return info;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo findAvdWithDisplayName(String displayName) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            for (AvdInfo avd : this.mAllAvdList) {
                if (!avd.getDisplayName().equals(displayName)) continue;
                return avd;
            }
        }
        return null;
    }

    @Slow
    public boolean isAvdRunning(AvdInfo info) {
        String pid;
        try {
            pid = this.getAvdPid(info);
        }
        catch (IOException e) {
            this.mLog.error((Throwable)e, "IOException while getting PID", new Object[0]);
            return true;
        }
        if (pid != null) {
            String command = SdkConstants.currentPlatform() == 2 ? "cmd /c \"tasklist /FI \"PID eq " + pid + "\" | findstr " + pid + "\"" : "kill -0 " + pid;
            try {
                Process p = Runtime.getRuntime().exec(command);
                return p.waitFor() == 0;
            }
            catch (IOException e) {
                this.mLog.warning("Got IOException while checking running processes:\n%s", new Object[]{Arrays.toString(e.getStackTrace())});
                return true;
            }
            catch (InterruptedException e) {
                this.mLog.warning("Got InterruptedException while checking running processes:\n%s", new Object[]{Arrays.toString(e.getStackTrace())});
                return true;
            }
        }
        return false;
    }

    @Slow
    public void logRunningAvdInfo(AvdInfo info) {
        int numTermChars;
        String command;
        String pid;
        try {
            pid = this.getAvdPid(info);
        }
        catch (IOException ex) {
            this.mLog.error((Throwable)ex, "AVD not launched but got IOException while getting PID", new Object[0]);
            return;
        }
        if (pid == null) {
            this.mLog.warning("AVD not launched but PID is null. Should not have indicated that the AVD is running.", new Object[0]);
            return;
        }
        this.mLog.warning("AVD not launched because an instance appears to be running on PID " + pid, new Object[0]);
        if (SdkConstants.currentPlatform() == 2) {
            command = "cmd /c \"tasklist /FI \"PID eq " + pid + "\" /FO csv /V /NH\"";
            numTermChars = 2;
        } else {
            command = "ps -o pid= -o user= -o pcpu= -o tty= -o stat= -o time= -o etime= -o cmd= -p " + pid;
            numTermChars = 1;
        }
        try {
            Process proc = Runtime.getRuntime().exec(command);
            if (proc.waitFor() != 0) {
                this.mLog.warning("Could not get info for that AVD process", new Object[0]);
            } else {
                InputStream procInfoStream = proc.getInputStream();
                int strMax = 256;
                byte[] procInfo = new byte[256];
                int nRead = procInfoStream.read(procInfo, 0, 256);
                if (nRead <= numTermChars) {
                    this.mLog.warning("Info for that AVD process is null", new Object[0]);
                } else {
                    this.mLog.warning("AVD process info: [" + new String(procInfo, 0, nRead - numTermChars) + "]", new Object[0]);
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            this.mLog.warning("Got exception when getting info on that AVD process:\n%s", new Object[]{Arrays.toString(ex.getStackTrace())});
        }
    }

    @Slow
    public void stopAvd(AvdInfo info) {
        try {
            String pid = this.getAvdPid(info);
            if (pid != null) {
                String command = SdkConstants.currentPlatform() == 2 ? "cmd /c \"taskkill /PID " + pid + "\"" : "kill " + pid;
                try {
                    Process p = Runtime.getRuntime().exec(command);
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Slow
    public OptionalLong getPid(AvdInfo avd) {
        OptionalLong pid = this.getPid(avd, "hardware-qemu.ini.lock");
        if (pid.isPresent()) {
            return pid;
        }
        return this.getPid(avd, "userdata-qemu.img.lock");
    }

    private OptionalLong getPid(AvdInfo avd, String element) {
        Path file = this.resolve(avd, element);
        Scanner scanner = new Scanner(file);
        try {
            scanner.useDelimiter("\u0000");
            OptionalLong optionalLong = OptionalLong.of(scanner.nextLong());
            scanner.close();
            return optionalLong;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NoSuchFileException exception) {
                this.mLog.info("%s not found for %s", new Object[]{file, avd.getName()});
                return OptionalLong.empty();
            }
            catch (IOException | NoSuchElementException exception) {
                this.mLog.error((Throwable)exception, "avd = %s, file = %s", new Object[]{avd.getName(), file});
                return OptionalLong.empty();
            }
        }
    }

    @VisibleForTesting
    Path resolve(AvdInfo avd, String element) {
        Path path = this.mBaseAvdFolder.resolve(avd.getDataFolderPath()).resolve(element);
        if (SdkConstants.currentPlatform() == 2) {
            return path.resolve("pid");
        }
        return path;
    }

    @Deprecated
    private String getAvdPid(AvdInfo info) throws IOException {
        Path dataFolderPath = this.mBaseAvdFolder.resolve(info.getDataFolderPath());
        Path f = dataFolderPath.resolve("hardware-qemu.ini.lock");
        if (SdkConstants.currentPlatform() == 2) {
            f = f.resolve("pid");
        }
        Path alternative = dataFolderPath.resolve("userdata-qemu.img.lock");
        if (SdkConstants.currentPlatform() == 2) {
            alternative = alternative.resolve("pid");
        }
        try {
            return CancellableFileIo.readString((Path)f).trim();
        }
        catch (NoSuchFileException noSuchFileException) {
            try {
                return CancellableFileIo.readString((Path)alternative).trim();
            }
            catch (NoSuchFileException noSuchFileException2) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public void reloadAvds() throws AndroidLocationsException {
        this.mSdkHandler.clearSystemImageManagerCache();
        ArrayList<AvdInfo> allList = new ArrayList<AvdInfo>();
        this.buildAvdList(allList);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.clear();
            this.mAllAvdList.addAll(allList);
            this.mValidAvdList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public AvdInfo reloadAvd(AvdInfo avdInfo) {
        AvdInfo newInfo = this.parseAvdInfo(avdInfo.getIniFile());
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            int index = this.mAllAvdList.indexOf(avdInfo);
            if (index >= 0) {
                this.replaceAvd(avdInfo, newInfo);
            }
        }
        return newInfo;
    }

    public AvdBuilder createAvdBuilder(Device device) {
        String avdName = AvdNamesKt.uniquifyAvdName(this, AvdNames.cleanAvdName(device.getDisplayName()));
        Path avdFolder = AvdInfo.getDefaultAvdFolder(this, avdName, true);
        AvdBuilder builder = new AvdBuilder(this.mBaseAvdFolder.resolve(avdName + INI_EXTENSION), avdFolder, device);
        builder.initializeFromDevice();
        builder.setDisplayName(AvdNamesKt.uniquifyDisplayName(this, device.getDisplayName()));
        return builder;
    }

    @Slow
    public AvdInfo createAvd(AvdBuilder builder) {
        Preconditions.checkArgument((boolean)Files.notExists(builder.getAvdFolder(), new LinkOption[0]), (Object)"AVD already exists");
        return this.createOrEditAvd(builder);
    }

    @Slow
    public AvdInfo editAvd(AvdInfo avdInfo, AvdBuilder builder) {
        if (!(avdInfo.getName().equals(builder.getAvdName()) && avdInfo.getDataFolderPath().equals(builder.getAvdFolder()) || this.moveAvd(avdInfo, builder.getAvdName(), builder.getAvdFolder()))) {
            return null;
        }
        return this.createOrEditAvd(builder);
    }

    private AvdInfo createOrEditAvd(AvdBuilder builder) {
        String avdName = (String)Preconditions.checkNotNull((Object)builder.getAvdName(), (Object)"avdName is required");
        if (!avdName.equals(AvdNames.cleanAvdName(avdName))) {
            throw new IllegalArgumentException("AVD name \"" + avdName + "\" contains invalid characters");
        }
        return this.createAvd((Path)Preconditions.checkNotNull((Object)builder.getAvdFolder(), (Object)"avdFolder is required"), avdName, (ISystemImage)Preconditions.checkNotNull((Object)builder.getSystemImage(), (Object)"systemImage is required"), builder.getSkin(), builder.getSdCard(), builder.configProperties(), builder.getUserSettings(), builder.getDevice().getBootProps(), builder.getDevice().hasPlayStore(), true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Slow
    public AvdInfo createAvd(Path avdFolder, String avdName, ISystemImage systemImage, Skin skin, SdCard sdcard, Map<String, String> hardwareConfig, Map<String, String> userSettings, Map<String, String> bootProps, boolean deviceHasPlayStore, boolean removePrevious, boolean editExisting) {
        block50: {
            block48: {
                block49: {
                    block45: {
                        block46: {
                            block47: {
                                block53: {
                                    block52: {
                                        iniFile = null;
                                        needCleanup = false;
                                        newAvdInfo = null;
                                        configValues = new HashMap<String, String>();
                                        if (CancellableFileIo.exists((Path)avdFolder, (LinkOption[])new LinkOption[0])) break block52;
                                        Files.createDirectories(avdFolder, new FileAttribute[0]);
                                        AvdManager.inhibitCopyOnWrite(avdFolder, this.mLog);
                                        editExisting = false;
                                        ** GOTO lbl50
                                    }
                                    if (!removePrevious) break block53;
                                    try {
                                        this.deleteContentOf(avdFolder);
                                        AvdManager.inhibitCopyOnWrite(avdFolder, this.mLog);
                                    }
                                    catch (SecurityException e) {
                                        this.mLog.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                                    }
                                    ** GOTO lbl50
                                }
                                if (editExisting) ** GOTO lbl50
                                oldAvdFolderPath = avdFolder.toAbsolutePath().toString();
                                newAvdInfo = this.duplicateAvd(avdFolder, avdName, systemImage);
                                if (newAvdInfo != null) break block45;
                                var17_26 = null;
                                if (!needCleanup) break block46;
                                if (iniFile == null) break block47;
                                try {
                                    PathUtils.deleteRecursivelyIfExists((Path)iniFile);
                                }
                                catch (IOException var18_28) {
                                    // empty catch block
                                }
                            }
                            try {
                                PathUtils.deleteRecursivelyIfExists((Path)avdFolder);
                            }
                            catch (Exception e) {
                                this.mLog.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                            }
                        }
                        return var17_26;
                    }
                    avdFolder = this.mBaseAvdFolder.resolve(newAvdInfo.getDataFolderPath());
                    configValues.putAll(newAvdInfo.getProperties());
                    if (hardwareConfig != null && (oldSdCardPath = hardwareConfig.get("sdcard.path")) != null && oldSdCardPath.startsWith(oldAvdFolderPath)) {
                        hardwareConfig.put("sdcard.path", oldSdCardPath.replace(oldAvdFolderPath, newAvdInfo.getDataFolderPath().toString()));
                    }
lbl50:
                    // 7 sources

                    iniFile = this.createAvdIniFile(avdName, avdFolder, removePrevious, systemImage.getAndroidVersion());
                    needCleanup = true;
                    this.createAvdUserdata(systemImage, avdFolder);
                    this.createAvdConfigFile(systemImage, configValues);
                    tag = systemImage.getTag();
                    configValues.put("tag.id", tag.getId());
                    configValues.put("tag.display", tag.getDisplay());
                    tags = systemImage.getTags();
                    configValues.put("tag.ids", tags.stream().map((Function<IdDisplay, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcom/android/sdklib/repository/IdDisplay;)Ljava/lang/String;)()).collect(Collectors.joining(",")));
                    configValues.put("tag.displaynames", tags.stream().map((Function<IdDisplay, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getDisplay(), (Lcom/android/sdklib/repository/IdDisplay;)Ljava/lang/String;)()).collect(Collectors.joining(",")));
                    configValues.put("abi.type", systemImage.getPrimaryAbiType());
                    configValues.put("PlayStore.enabled", Boolean.toString(deviceHasPlayStore != false && systemImage.hasPlayStore() != false));
                    configValues.put("hw.arc", Boolean.toString(SystemImageTags.CHROMEOS_TAG.equals(tag)));
                    if (sdcard != null) {
                        configValues.putAll(sdcard.configEntries());
                    }
                    if (sdcard instanceof InternalSdCard) {
                        this.createAvdSdCard((InternalSdCard)sdcard, editExisting, avdFolder);
                    }
                    this.addSystemImageHardwareConfig(systemImage, configValues);
                    if (skin != null) {
                        this.addSkin(skin, configValues);
                    }
                    if (hardwareConfig != null) {
                        configValues.putAll(hardwareConfig);
                    }
                    this.addCpuArch(systemImage, configValues, this.mLog);
                    this.writeIniFile(avdFolder.resolve("config.ini"), configValues, true);
                    if (userSettings != null) {
                        try {
                            this.writeIniFile(avdFolder.resolve("user-settings.ini"), userSettings, true);
                        }
                        catch (IOException e) {
                            this.mLog.warning("Could not write user settings file (at %1$s): %2$s", new Object[]{avdFolder.resolve("user-settings.ini").toString(), e});
                        }
                    }
                    if (bootProps != null && !bootProps.isEmpty()) {
                        bootPropsFile = avdFolder.resolve("boot.prop");
                        this.writeIniFile(bootPropsFile, bootProps, false);
                    }
                    oldAvdInfo = this.getAvd(avdName, false);
                    if (newAvdInfo == null) {
                        newAvdInfo = this.createAvdInfoObject(systemImage, removePrevious, editExisting, iniFile, avdFolder, oldAvdInfo, configValues, userSettings);
                    }
                    if ((removePrevious || editExisting) && oldAvdInfo != null && !oldAvdInfo.getDataFolderPath().equals(newAvdInfo.getDataFolderPath())) {
                        this.mLog.warning("Removing previous AVD directory at %s", new Object[]{oldAvdInfo.getDataFolderPath()});
                        try {
                            PathUtils.deleteRecursivelyIfExists((Path)this.mBaseAvdFolder.resolve(oldAvdInfo.getDataFolderPath()));
                        }
                        catch (IOException exception) {
                            this.mLog.warning("Failed to delete %1$s: %2$s", new Object[]{oldAvdInfo.getDataFolderPath()});
                        }
                    }
                    needCleanup = false;
                    var19_33 = newAvdInfo;
                    if (!needCleanup) break block48;
                    if (iniFile == null) break block49;
                    try {
                        PathUtils.deleteRecursivelyIfExists((Path)iniFile);
                    }
                    catch (IOException var20_34) {
                        // empty catch block
                    }
                }
                try {
                    PathUtils.deleteRecursivelyIfExists((Path)avdFolder);
                }
                catch (Exception e) {
                    this.mLog.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                }
            }
            return var19_33;
            catch (AvdMgrException newAvdInfo) {
                if (!needCleanup) break block50;
                if (iniFile != null) {
                    try {
                        PathUtils.deleteRecursivelyIfExists(iniFile);
                    }
                    catch (IOException newAvdInfo) {
                        // empty catch block
                    }
                }
                try {
                    PathUtils.deleteRecursivelyIfExists((Path)avdFolder);
                }
                catch (Exception e) {
                    this.mLog.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                }
                break block50;
            }
            catch (AndroidLocationsException | IOException | SecurityException e) {
                block51: {
                    this.mLog.warning("%1$s", new Object[]{e});
                    if (!needCleanup) break block50;
                    if (iniFile == null) break block51;
                    {
                        catch (Throwable var21_36) {
                            if (needCleanup) {
                                if (iniFile != null) {
                                    try {
                                        PathUtils.deleteRecursivelyIfExists(iniFile);
                                    }
                                    catch (IOException var22_37) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    PathUtils.deleteRecursivelyIfExists((Path)avdFolder);
                                }
                                catch (Exception e) {
                                    this.mLog.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                                }
                            }
                            throw var21_36;
                        }
                    }
                    try {
                        PathUtils.deleteRecursivelyIfExists(iniFile);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                try {
                    PathUtils.deleteRecursivelyIfExists((Path)avdFolder);
                }
                catch (Exception e) {
                    this.mLog.warning("Failed to delete %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath(), e});
                }
            }
        }
        return null;
    }

    private AvdInfo duplicateAvd(Path avdFolder, String newAvdName, ISystemImage systemImage) {
        try {
            Path destAvdFolder = avdFolder.getParent().resolve(newAvdName + AVD_FOLDER_EXTENSION);
            AvdManager.inhibitCopyOnWrite(destAvdFolder, this.mLog);
            ConsoleProgressIndicator progInd = new ConsoleProgressIndicator();
            progInd.setText("Copying files");
            progInd.setIndeterminate(true);
            FileOpUtils.recursiveCopy((Path)avdFolder, (Path)destAvdFolder, (boolean)false, path -> !path.toString().endsWith(".lock"), (ProgressIndicator)progInd);
            Path configIni = destAvdFolder.resolve(CONFIG_INI);
            Map<String, String> configVals = AvdManager.parseIniFile(new PathFileWrapper(configIni), this.mLog);
            Map<String, String> userSettingsVals = AvdInfo.parseUserSettingsFile(destAvdFolder, this.mLog);
            configVals.put("AvdId", newAvdName);
            configVals.put("avd.ini.displayname", newAvdName);
            this.writeIniFile(configIni, configVals, true);
            String origAvdName = avdFolder.getFileName().toString().replace(AVD_FOLDER_EXTENSION, "");
            String origAvdFolder = avdFolder.toAbsolutePath().toString();
            String newAvdFolder = destAvdFolder.toAbsolutePath().toString();
            configVals = this.updateNameAndIniPaths(configIni, origAvdName, origAvdFolder, newAvdName, newAvdFolder);
            Path hwQemu = destAvdFolder.resolve(HARDWARE_QEMU_INI);
            this.updateNameAndIniPaths(hwQemu, origAvdName, origAvdFolder, newAvdName, newAvdFolder);
            Path metadataIniFile = this.createAvdIniFile(newAvdName, destAvdFolder, false, systemImage.getAndroidVersion());
            return new AvdInfo(metadataIniFile, destAvdFolder, systemImage, configVals, userSettingsVals);
        }
        catch (AndroidLocationsException | IOException e) {
            this.mLog.warning("Exception while duplicating an AVD: %1$s", new Object[]{e});
            return null;
        }
    }

    private Map<String, String> updateNameAndIniPaths(Path iniFile, String oldName, String oldPath, String newName, String newPath) throws IOException {
        Map<String, String> iniVals = AvdManager.parseIniFile(new PathFileWrapper(iniFile), this.mLog);
        if (iniVals != null) {
            for (Map.Entry<String, String> iniEntry : iniVals.entrySet()) {
                String origIniValue = iniEntry.getValue();
                if (origIniValue.equals(oldName)) {
                    iniVals.put(iniEntry.getKey(), newName);
                }
                if (!origIniValue.startsWith(oldPath)) continue;
                String newIniValue = origIniValue.replace(oldPath, newPath);
                iniVals.put(iniEntry.getKey(), newIniValue);
            }
            this.writeIniFile(iniFile, iniVals, true);
        }
        return iniVals;
    }

    private String getImageRelativePath(ISystemImage systemImage) throws InvalidTargetPathException {
        String[] list;
        String sdkLocation;
        Path folder = systemImage.getLocation();
        Object imageFullPath = folder.toAbsolutePath().toString();
        if (!((String)imageFullPath).startsWith(sdkLocation = this.mSdkHandler.getLocation().toAbsolutePath().toString())) {
            assert (false);
            throw new InvalidTargetPathException("Target location is not inside the SDK.");
        }
        try (Stream contents = CancellableFileIo.list((Path)folder);){
            list = (String[])contents.map(path -> path.getFileName().toString()).filter(path -> IMAGE_NAME_PATTERN.matcher((CharSequence)path).matches()).toArray(String[]::new);
        }
        catch (IOException e) {
            return null;
        }
        if (list.length > 0) {
            String separator;
            if (((String)(imageFullPath = ((String)imageFullPath).substring(sdkLocation.length()))).startsWith(separator = folder.getFileSystem().getSeparator())) {
                imageFullPath = ((String)imageFullPath).substring(separator.length());
            }
            if (!((String)imageFullPath).endsWith(separator)) {
                imageFullPath = (String)imageFullPath + separator;
            }
            return imageFullPath;
        }
        return null;
    }

    private Path createAvdIniFile(String avdName, Path avdFolder, boolean removePrevious, AndroidVersion version) throws AndroidLocationsException, IOException {
        Path iniFile = AvdInfo.getDefaultIniFile(this, avdName);
        if (removePrevious) {
            if (CancellableFileIo.isRegularFile((Path)iniFile, (LinkOption[])new LinkOption[0])) {
                Files.delete(iniFile);
            } else if (CancellableFileIo.isDirectory((Path)iniFile, (LinkOption[])new LinkOption[0])) {
                try {
                    PathUtils.deleteRecursivelyIfExists((Path)iniFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        String absPath = avdFolder.toAbsolutePath().toString();
        String relPath = null;
        Path androidFolder = this.mSdkHandler.getAndroidFolder();
        if (androidFolder == null) {
            throw new AndroidLocationsException("Can't locate Android SDK installation directory for the AVD .ini file.");
        }
        String androidPath = androidFolder.toAbsolutePath() + File.separator;
        if (absPath.startsWith(androidPath)) {
            relPath = absPath.substring(androidPath.length());
        }
        HashMap<String, String> values = new HashMap<String, String>();
        if (relPath != null) {
            values.put("path.rel", relPath);
        }
        values.put("path", absPath);
        values.put("target", AndroidTargetHash.getPlatformHashString(version));
        this.writeIniFile(iniFile, values, true);
        return iniFile;
    }

    private Path createAvdIniFile(AvdInfo info) throws AndroidLocationsException, IOException {
        return this.createAvdIniFile(info.getName(), this.mBaseAvdFolder.resolve(info.getDataFolderPath()), false, info.getAndroidVersion());
    }

    @Slow
    public boolean deleteAvd(AvdInfo avdInfo) {
        try {
            boolean error = false;
            Path f = avdInfo.getIniFile();
            try {
                Files.deleteIfExists(f);
            }
            catch (IOException exception) {
                this.mLog.warning("Failed to delete %1$s\n", new Object[]{f});
                error = true;
            }
            Path path = avdInfo.getDataFolderPath();
            f = this.mBaseAvdFolder.resolve(path);
            try {
                PathUtils.deleteRecursivelyIfExists((Path)f);
            }
            catch (IOException exception) {
                this.mLog.warning("Failed to delete %1$s\n", new Object[]{f});
                StringWriter writer = new StringWriter();
                exception.printStackTrace(new PrintWriter(writer));
                this.mLog.warning(writer.toString(), new Object[0]);
                error = true;
            }
            this.removeAvd(avdInfo);
            if (!error) {
                this.mLog.info("\nAVD '%1$s' deleted.\n", new Object[]{avdInfo.getName()});
                return true;
            }
            this.mLog.info("\nAVD '%1$s' deleted with errors. See errors above.\n", new Object[]{avdInfo.getName()});
        }
        catch (SecurityException e) {
            this.mLog.warning("%1$s", new Object[]{e});
        }
        return false;
    }

    @Slow
    public boolean moveAvd(AvdInfo avdInfo, String newAvdName, Path newAvdFolder) {
        try {
            if (newAvdFolder != null) {
                Path f = this.mBaseAvdFolder.resolve(avdInfo.getDataFolderPath());
                this.mLog.info("Moving '%1$s' to '%2$s'.\n", new Object[]{avdInfo.getDataFolderPath(), newAvdFolder});
                try {
                    Files.move(f, this.mBaseAvdFolder.resolve(newAvdFolder), new CopyOption[0]);
                }
                catch (IOException exception) {
                    this.mLog.error((Throwable)exception, "Failed to move '%1$s' to '%2$s'.\n", new Object[]{avdInfo.getDataFolderPath(), newAvdFolder});
                    return false;
                }
                AvdInfo info = new AvdInfo(avdInfo.getIniFile(), newAvdFolder, avdInfo.getSystemImage(), avdInfo.getProperties(), avdInfo.getUserSettings());
                this.replaceAvd(avdInfo, info);
                this.createAvdIniFile(info);
            }
            if (newAvdName != null) {
                Path oldMetadataIniFile = avdInfo.getIniFile();
                Path newMetadataIniFile = AvdInfo.getDefaultIniFile(this, newAvdName);
                this.mLog.warning("Moving '%1$s' to '%2$s'.", new Object[]{oldMetadataIniFile, newMetadataIniFile});
                try {
                    Files.move(oldMetadataIniFile, newMetadataIniFile, new CopyOption[0]);
                }
                catch (IOException exception) {
                    this.mLog.warning(null, new Object[]{"Failed to move '%1$s' to '%2$s'.", oldMetadataIniFile, newMetadataIniFile});
                    return false;
                }
                AvdInfo info = new AvdInfo(avdInfo.getIniFile(), avdInfo.getDataFolderPath(), avdInfo.getSystemImage(), avdInfo.getProperties(), avdInfo.getUserSettings());
                this.replaceAvd(avdInfo, info);
            }
            this.mLog.info("AVD '%1$s' moved.\n", new Object[]{avdInfo.getName()});
        }
        catch (AndroidLocationsException | IOException e) {
            this.mLog.warning("$1%s", new Object[]{e});
            return false;
        }
        return true;
    }

    private boolean deleteContentOf(Path folder) throws SecurityException {
        boolean success = true;
        try (DirectoryStream<Path> entries = Files.newDirectoryStream(folder);){
            for (Path entry : entries) {
                try {
                    PathUtils.deleteRecursivelyIfExists((Path)entry);
                }
                catch (IOException ignore) {
                    success = false;
                }
            }
        }
        catch (IOException exception) {
            return false;
        }
        return success;
    }

    private Path[] buildAvdFilesList() throws AndroidLocationsException {
        if (CancellableFileIo.isRegularFile((Path)this.mBaseAvdFolder, (LinkOption[])new LinkOption[0])) {
            throw new AndroidLocationsException(String.format("%1$s is a regular file; expected a directory.", this.mBaseAvdFolder.toAbsolutePath()));
        }
        if (CancellableFileIo.notExists((Path)this.mBaseAvdFolder, (LinkOption[])new LinkOption[0])) {
            try {
                Files.createDirectories(this.mBaseAvdFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new AndroidLocationsException("Unable to create AVD home directory: " + this.mBaseAvdFolder.toAbsolutePath(), (Throwable)e);
            }
            return null;
        }
        Path[] avds = new Path[]{};
        try (Stream contents = CancellableFileIo.list((Path)this.mBaseAvdFolder);){
            avds = (Path[])contents.filter(path -> {
                if (INI_NAME_PATTERN.matcher(path.getFileName().toString()).matches()) {
                    return Files.isRegularFile(path, new LinkOption[0]);
                }
                return false;
            }).toArray(Path[]::new);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return avds;
    }

    private void buildAvdList(ArrayList<AvdInfo> allList) throws AndroidLocationsException {
        Path[] avds = this.buildAvdFilesList();
        if (avds != null) {
            for (Path avd : avds) {
                AvdInfo info = this.parseAvdInfo(avd);
                if (info == null || allList.contains(info)) continue;
                allList.add(info);
            }
        }
    }

    @Slow
    @VisibleForTesting
    AvdInfo parseAvdInfo(Path metadataIniFile) {
        String tagId;
        AndroidVersion version;
        String targetHash;
        Map<String, String> metadata = AvdManager.parseIniFile(new PathFileWrapper(metadataIniFile), this.mLog);
        Path avdFolder = null;
        if (metadata != null) {
            String relPath;
            String path = metadata.get("path");
            Path path2 = avdFolder = path == null ? null : metadataIniFile.resolve(path);
            if (!(avdFolder != null && CancellableFileIo.isDirectory((Path)this.mBaseAvdFolder.resolve(avdFolder), (LinkOption[])new LinkOption[0]) || (relPath = metadata.get("path.rel")) == null)) {
                Path f;
                Path androidFolder = this.mSdkHandler.getAndroidFolder();
                Path path3 = f = androidFolder == null ? this.mSdkHandler.toCompatiblePath(relPath) : androidFolder.resolve(relPath);
                if (CancellableFileIo.isDirectory((Path)f, (LinkOption[])new LinkOption[0])) {
                    avdFolder = f;
                }
            }
        }
        if (avdFolder == null || !CancellableFileIo.isDirectory((Path)this.mBaseAvdFolder.resolve(avdFolder), (LinkOption[])new LinkOption[0])) {
            return new AvdInfo(metadataIniFile, metadataIniFile, null, null, null, AvdInfo.AvdStatus.ERROR_CORRUPTED_INI);
        }
        Map<String, String> properties = null;
        LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper(this.mLog){

            @Override
            public void logVerbose(String s) {
            }
        };
        PathFileWrapper configIniFile = new PathFileWrapper(this.mBaseAvdFolder.resolve(avdFolder).resolve(CONFIG_INI));
        if (!configIniFile.exists()) {
            this.mLog.warning("Missing file '%1$s'.", new Object[]{configIniFile.getOsLocation()});
            configIniFile = null;
        } else {
            properties = AvdManager.parseIniFile(configIniFile, this.mLog);
        }
        String imageSysDir = null;
        ISystemImage sysImage = null;
        if (properties != null && (imageSysDir = properties.get("image.sysdir.1")) != null) {
            Path sdkLocation = this.mSdkHandler.getLocation();
            Path imageDir = sdkLocation == null ? this.mBaseAvdFolder.resolve(imageSysDir) : sdkLocation.resolve(imageSysDir);
            sysImage = this.mSdkHandler.getSystemImageManager((ProgressIndicator)progress).getImageAt(imageDir);
        }
        DeviceManager.DeviceStatus deviceStatus = null;
        boolean updateHashV2 = false;
        if (properties != null) {
            String deviceName = properties.get("hw.device.name");
            String deviceMfctr = properties.get("hw.device.manufacturer");
            if (deviceName != null && deviceMfctr != null) {
                Device d = this.mDeviceManager.getDevice(deviceName, deviceMfctr);
                DeviceManager.DeviceStatus deviceStatus2 = deviceStatus = d == null ? DeviceManager.DeviceStatus.MISSING : DeviceManager.DeviceStatus.EXISTS;
                if (d != null) {
                    String hashV1;
                    updateHashV2 = true;
                    String hashV2 = properties.get("hw.device.hash2");
                    if (hashV2 != null) {
                        String newHashV2 = DeviceManager.hasHardwarePropHashChanged(d, hashV2);
                        if (newHashV2 == null) {
                            updateHashV2 = false;
                        } else {
                            properties.put("hw.device.hash2", newHashV2);
                        }
                    }
                    if ((hashV1 = properties.get("hw.device.hash")) != null) {
                        properties.remove("hw.device.hash");
                    }
                }
            }
        }
        AvdInfo.AvdStatus status2 = configIniFile == null ? AvdInfo.AvdStatus.ERROR_CONFIG : (properties == null || imageSysDir == null ? AvdInfo.AvdStatus.ERROR_PROPERTIES : (deviceStatus == DeviceManager.DeviceStatus.MISSING ? AvdInfo.AvdStatus.ERROR_DEVICE_MISSING : (sysImage == null ? AvdInfo.AvdStatus.ERROR_IMAGE_MISSING : AvdInfo.AvdStatus.OK)));
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        if (!properties.containsKey("image.androidVersion.api") && !properties.containsKey("image.androidVersion.codename") && (targetHash = metadata.get("target")) != null && (version = AndroidTargetHash.getVersionFromHash(targetHash)) != null) {
            properties.put("image.androidVersion.api", Integer.toString(version.getApiLevel()));
            if (version.getExtensionLevel() != null) {
                properties.put("image.androidVersion.extension", Integer.toString(version.getExtensionLevel()));
                properties.put("image.androidVersion.isBaseExtension", Boolean.toString(version.isBaseExtension()));
            }
            if (version.getCodename() != null) {
                properties.put("image.androidVersion.codename", version.getCodename());
            }
            if (!version.isBaseExtension() && version.getExtensionLevel() != null) {
                properties.put("image.androidVersion.ext", Integer.toString(version.getExtensionLevel()));
            }
        }
        if (!properties.containsKey("tag.ids") && (tagId = properties.get("tag.id")) != null && !tagId.isEmpty()) {
            properties.put("tag.ids", tagId);
        }
        Map<String, String> userSettings = AvdInfo.parseUserSettingsFile(avdFolder, this.mLog);
        AvdInfo info = new AvdInfo(metadataIniFile, avdFolder, sysImage, properties, userSettings, status2);
        if (updateHashV2) {
            try {
                return this.updateDeviceChanged(info);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return info;
    }

    private void writeIniFile(Path iniFile, Map<String, String> values, boolean addEncoding) throws IOException {
        Charset charset = Charsets.UTF_8;
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(iniFile, new OpenOption[0]), charset);){
            if (addEncoding) {
                values = new HashMap<String, String>(values);
                values.put("avd.ini.encoding", charset.name());
            }
            ArrayList<String> keys = new ArrayList<String>(values.keySet());
            keys.remove("image.androidVersion.api");
            keys.remove("image.androidVersion.extension");
            keys.remove("image.androidVersion.isBaseExtension");
            keys.remove("image.androidVersion.codename");
            Collections.sort(keys);
            for (String key : keys) {
                String value = values.get(key);
                if (value == null) continue;
                writer.write(String.format("%1$s=%2$s\n", key, value));
            }
        }
    }

    @Slow
    public static Map<String, String> parseIniFile(IAbstractFile propFile, ILogger logger) {
        return AvdManager.parseIniFileImpl(propFile, logger, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> parseIniFileImpl(IAbstractFile propFile, ILogger log, Charset charset) {
        reader = null;
        try {
            canChangeCharset = false;
            if (charset == null) {
                canChangeCharset = true;
                charset = Charsets.ISO_8859_1;
            }
            reader = new BufferedReader(new InputStreamReader(propFile.getContents(), charset));
            map = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                block26: {
                    if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                    m = AvdManager.INI_LINE_PATTERN.matcher(line);
                    if (!m.matches()) break block26;
                    key = m.group(1);
                    value = m.group(2);
                    if (canChangeCharset && "avd.ini.encoding".equals(key) && !charset.name().equals(value) && Charset.isSupported(value)) {
                        charset = Charset.forName(value);
                        var10_16 = AvdManager.parseIniFileImpl(propFile, log, charset);
                        ** try [egrp 1[TRYBLOCK] [0 : 167->175)] { 
lbl19:
                        // 1 sources

                    } else {
                        map.put(key, value);
                        continue;
                    }
                }
                if (log != null) {
                    log.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", new Object[]{propFile.getOsLocation(), line});
                }
                var8_12 = null;
                ** try [egrp 3[TRYBLOCK] [1 : 229->237)] { 
lbl28:
                // 1 sources

                ** GOTO lbl-1000
            }
            var7_11 = map;
            ** try [egrp 5[TRYBLOCK] [2 : 249->257)] { 
lbl31:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (FileNotFoundException canChangeCharset) {
            try {
                Closeables.close(reader, (boolean)true);
                return null;
            }
            catch (IOException canChangeCharset) {
                return null;
            }
        }
        catch (StreamException | IOException e) {
            if (log == null) return null;
            log.warning("Error parsing '%1$s': %2$s.", new Object[]{propFile.getOsLocation(), e.getMessage()});
            return null;
        }
        {
            Closeables.close((Closeable)reader, (boolean)true);
            return var10_16;
        }
lbl47:
        // 1 sources

        catch (IOException var11_17) {
            // empty catch block
        }
        return var10_16;
lbl-1000:
        // 1 sources

        {
            Closeables.close((Closeable)reader, (boolean)true);
            return var8_12;
        }
lbl52:
        // 1 sources

        catch (IOException var9_15) {
            // empty catch block
        }
        return var8_12;
lbl-1000:
        // 1 sources

        {
            Closeables.close((Closeable)reader, (boolean)true);
            return var7_11;
        }
lbl57:
        // 1 sources

        catch (IOException var8_13) {
            // empty catch block
        }
        return var7_11;
        finally {
            try {
                Closeables.close(reader, (boolean)true);
            }
            catch (IOException var4_8) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAvd(AvdInfo avdInfo) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mAllAvdList.remove(avdInfo)) {
                this.mValidAvdList = null;
                return true;
            }
        }
        return false;
    }

    @Slow
    public AvdInfo updateAvd(AvdInfo avd, Map<String, String> newProperties) throws IOException {
        Path configIniFile = this.mBaseAvdFolder.resolve(avd.getDataFolderPath()).resolve(CONFIG_INI);
        this.writeIniFile(configIniFile, newProperties, true);
        AvdInfo newAvd = new AvdInfo(avd.getIniFile(), avd.getDataFolderPath(), avd.getSystemImage(), newProperties, avd.getUserSettings());
        this.replaceAvd(avd, newAvd);
        return newAvd;
    }

    @Slow
    public AvdInfo updateDeviceChanged(AvdInfo avd) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>(avd.getProperties());
        Device d = this.mDeviceManager.getDevice(avd);
        if (d == null) {
            this.mLog.warning("Base device information incomplete or missing.", new Object[0]);
            return null;
        }
        Map<String, String> deviceHwProperties = DeviceManager.getHardwareProperties(d);
        deviceHwProperties.remove("hw.ramSize");
        properties.putAll(deviceHwProperties);
        try {
            return this.updateAvd(avd, properties);
        }
        catch (IOException e) {
            this.mLog.warning("%1$s", new Object[]{e});
            return null;
        }
    }

    private boolean setImagePathProperties(ISystemImage image, Map<String, String> properties) {
        properties.remove("image.sysdir.1");
        properties.remove("image.sysdir.2");
        try {
            String property = "image.sysdir.1";
            String imagePath = this.getImageRelativePath(image);
            if (imagePath != null) {
                properties.put(property, imagePath);
                return true;
            }
        }
        catch (InvalidTargetPathException e) {
            this.mLog.warning("%1$s", new Object[]{e});
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvd(AvdInfo oldAvd, AvdInfo newAvd) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.remove(oldAvd);
            this.mAllAvdList.add(newAvd);
            this.mValidAvdList = null;
        }
    }

    private void createAvdUserdata(ISystemImage systemImage, Path avdFolder) throws IOException, AvdMgrException {
        Path imageFolder = systemImage.getLocation();
        Path userdataSrc = imageFolder.resolve(USERDATA_IMG);
        String abiType = systemImage.getPrimaryAbiType();
        if (CancellableFileIo.notExists((Path)userdataSrc, (LinkOption[])new LinkOption[0])) {
            if (CancellableFileIo.isDirectory((Path)imageFolder.resolve(DATA_FOLDER), (LinkOption[])new LinkOption[0])) {
                return;
            }
            this.mLog.warning("Unable to find a '%1$s' file for ABI %2$s to copy into the AVD folder.", new Object[]{USERDATA_IMG, abiType});
            throw new AvdMgrException();
        }
        Path userdataDest = avdFolder.resolve(USERDATA_IMG);
        if (CancellableFileIo.notExists((Path)userdataDest, (LinkOption[])new LinkOption[0])) {
            FileUtils.copyFile((Path)userdataSrc, (Path)userdataDest);
            if (CancellableFileIo.notExists((Path)userdataDest, (LinkOption[])new LinkOption[0])) {
                this.mLog.warning("Unable to create '%1$s' file in the AVD folder.", new Object[]{userdataDest});
                throw new AvdMgrException();
            }
        }
    }

    private void createAvdConfigFile(ISystemImage systemImage, HashMap<String, String> values) throws AvdMgrException {
        if (!this.setImagePathProperties(systemImage, values)) {
            this.mLog.warning("Failed to set image path properties in the AVD folder.", new Object[0]);
            throw new AvdMgrException();
        }
    }

    private void addCpuArch(ISystemImage systemImage, Map<String, String> values, ILogger log) throws AvdMgrException {
        String abiType = systemImage.getPrimaryAbiType();
        Abi abi = Abi.getEnum(abiType);
        if (abi != null) {
            String arch = abi.getCpuArch();
            if (arch.equals("x86") && SystemImageTags.CHROMEOS_TAG.equals(systemImage.getTag())) {
                arch = "x86_64";
            }
            values.put("hw.cpu.arch", arch);
            String model = abi.getCpuModel();
            if (model != null) {
                values.put("hw.cpu.model", model);
            }
        } else {
            log.warning("ABI %1$s is not supported by this version of the SDK Tools", new Object[]{abiType});
            throw new AvdMgrException();
        }
    }

    private void addSkin(Skin skin, Map<String, String> values) throws AvdMgrException {
        String skinPath;
        String skinName = skin.getName();
        if (skin instanceof OnDiskSkin) {
            Map<String, String> skinHardwareConfig;
            Path path = ((OnDiskSkin)skin).getPath();
            if (CancellableFileIo.notExists((Path)path, (LinkOption[])new LinkOption[0])) {
                this.mLog.warning("Skin '%1$s' does not exist at %2$s.", new Object[]{skinName, path});
                throw new AvdMgrException();
            }
            skinPath = path.toString();
            PathFileWrapper skinHardwareFile = new PathFileWrapper(path.resolve(HARDWARE_INI));
            if (skinHardwareFile.exists() && (skinHardwareConfig = ProjectProperties.parsePropertyFile(skinHardwareFile, this.mLog)) != null) {
                values.putAll(skinHardwareConfig);
            }
        } else if (skin instanceof GenericSkin) {
            skinPath = skinName;
        } else {
            throw new IllegalArgumentException("Unknown skin type");
        }
        values.put("skin.name", skinName);
        values.put("skin.path", skinPath);
    }

    private void createAvdSdCard(InternalSdCard sdcard, boolean editExisting, Path avdFolder) throws AvdMgrException {
        if (!this.mBaseAvdFolder.getFileSystem().equals(FileSystems.getDefault())) {
            return;
        }
        Path sdcardFile = avdFolder.resolve(SDCARD_IMG);
        try {
            if (CancellableFileIo.size((Path)sdcardFile) == sdcard.getSize() && editExisting) {
                this.mLog.info("SD Card already present with same size, was not changed.\n", new Object[0]);
                return;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException exception) {
            AvdMgrException wrapper = new AvdMgrException();
            wrapper.initCause(exception);
            throw wrapper;
        }
        String path = sdcardFile.toAbsolutePath().toString();
        LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper(this.mLog){

            @Override
            public void logVerbose(String s) {
            }
        };
        EmulatorPackage p = EmulatorPackages.getEmulatorPackage(this.mSdkHandler, (ProgressIndicator)progress);
        if (p == null) {
            this.mLog.warning("Emulator package is not installed", new Object[0]);
            throw new AvdMgrException();
        }
        Path mkSdCard = p.getMkSdCardBinary();
        if (mkSdCard == null || !CancellableFileIo.isRegularFile((Path)mkSdCard, (LinkOption[])new LinkOption[0])) {
            this.mLog.warning(String.format("Unable to find %1$s in the %2$s component", SdkConstants.mkSdCardCmdName(), "emulator"), new Object[0]);
            throw new AvdMgrException();
        }
        if (!SdCards.createSdCard(this.mLog, mkSdCard.toAbsolutePath().toString(), sdcard.sizeSpec(), path)) {
            this.mLog.warning("Failed to create sdcard in the AVD folder.", new Object[0]);
            throw new AvdMgrException();
        }
    }

    private void addSystemImageHardwareConfig(ISystemImage systemImage, Map<String, String> values) {
        Map<String, String> imageHardwardConfig;
        PathFileWrapper sysImgHardwareFile = new PathFileWrapper(systemImage.getLocation().resolve(HARDWARE_INI));
        if (sysImgHardwareFile.exists() && (imageHardwardConfig = ProjectProperties.parsePropertyFile(sysImgHardwareFile, this.mLog)) != null) {
            values.putAll(imageHardwardConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AvdInfo createAvdInfoObject(ISystemImage systemImage, boolean removePrevious, boolean editExisting, Path metadataIniFile, Path avdFolder, AvdInfo oldAvdInfo, Map<String, String> values, Map<String, String> userSettings) throws AvdMgrException {
        AvdInfo theAvdInfo = new AvdInfo(metadataIniFile, avdFolder, systemImage, values, userSettings);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (oldAvdInfo != null && (removePrevious || editExisting)) {
                this.mAllAvdList.remove(oldAvdInfo);
            }
            this.mAllAvdList.add(theAvdInfo);
            this.mValidAvdList = null;
        }
        return theAvdInfo;
    }

    private static void inhibitCopyOnWrite(Path avdFolder, ILogger log) {
        if (SdkConstants.CURRENT_PLATFORM != 1) {
            return;
        }
        try {
            String[] chattrCommand = new String[]{"chattr", "+C", avdFolder.toAbsolutePath().toString()};
            Process chattrProcess = Runtime.getRuntime().exec(chattrCommand);
            final ArrayList errorOutput = new ArrayList();
            GrabProcessOutput.grabProcessOutput((Process)chattrProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

                public void out(String line) {
                }

                public void err(String line) {
                    if (line != null && !line.startsWith("chattr: Operation not supported")) {
                        errorOutput.add(line);
                    }
                }
            });
            if (!errorOutput.isEmpty()) {
                log.warning("Failed 'chattr' for %1$s:", new Object[]{avdFolder.toAbsolutePath().toString()});
                for (String error : errorOutput) {
                    log.warning(" -- %1$s", new Object[]{error});
                }
            }
        }
        catch (IOException | InterruptedException ee) {
            log.warning("Failed 'chattr' for %1$s: %2$s", new Object[]{avdFolder.toAbsolutePath().toString(), ee});
        }
    }

    private static class AvdMgrException
    extends Exception {
        private AvdMgrException() {
        }
    }

    private static final class InvalidTargetPathException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidTargetPathException(String message) {
            super(message);
        }
    }
}

