/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SystemImageTags {
    public static final IdDisplay DEFAULT_TAG = IdDisplay.create("default", "Default");
    public static final IdDisplay WEAR_TAG = IdDisplay.create("android-wear", "Wear OS");
    public static final IdDisplay DESKTOP_TAG = IdDisplay.create("android-desktop", "Desktop");
    public static final IdDisplay ANDROID_TV_TAG = IdDisplay.create("android-tv", "Android TV");
    public static final IdDisplay GOOGLE_TV_TAG = IdDisplay.create("google-tv", "Google TV");
    public static final IdDisplay AUTOMOTIVE_TAG = IdDisplay.create("android-automotive", "Android Automotive");
    public static final IdDisplay AUTOMOTIVE_PLAY_STORE_TAG = IdDisplay.create("android-automotive-playstore", "Android Automotive with Google Play");
    public static final IdDisplay AUTOMOTIVE_DISTANT_DISPLAY_TAG = IdDisplay.create("android-automotive-distantdisplay", "Android Automotive Distant Display");
    public static final IdDisplay CHROMEOS_TAG = IdDisplay.create("chromeos", "Chrome OS Device");
    public static final IdDisplay GOOGLE_APIS_TAG = IdDisplay.create("google_apis", "Google APIs");
    public static final IdDisplay PLAY_STORE_TAG = IdDisplay.create("google_apis_playstore", "Google Play");
    public static final IdDisplay TABLET_TAG = IdDisplay.create("tablet", "Tablet");
    public static final IdDisplay GOOGLE_APIS_X86_TAG = IdDisplay.create("google_apis_x86", "Google APIs x86");
    public static final Set<IdDisplay> TAGS_WITH_GOOGLE_API = ImmutableSet.of((Object)GOOGLE_APIS_TAG, (Object)GOOGLE_APIS_X86_TAG, (Object)PLAY_STORE_TAG, (Object)ANDROID_TV_TAG, (Object)GOOGLE_TV_TAG, (Object)WEAR_TAG, (Object[])new IdDisplay[]{DESKTOP_TAG, CHROMEOS_TAG, AUTOMOTIVE_TAG, AUTOMOTIVE_PLAY_STORE_TAG, AUTOMOTIVE_DISTANT_DISPLAY_TAG});
    private static final Set<IdDisplay> TV_TAGS = ImmutableSet.of((Object)ANDROID_TV_TAG, (Object)GOOGLE_TV_TAG);

    public static boolean hasGooglePlay(List<IdDisplay> tags, AndroidVersion version, RepoPackage repoPackage) {
        if (tags.contains(PLAY_STORE_TAG)) {
            return true;
        }
        if (tags.size() != 1) {
            return false;
        }
        IdDisplay tag = tags.get(0);
        if (tag.equals(AUTOMOTIVE_PLAY_STORE_TAG)) {
            return true;
        }
        return tag.equals(WEAR_TAG) && version.getApiLevel() >= 25 && !repoPackage.getPath().contains("android-wear-cn");
    }

    public static boolean hasGoogleApi(Collection<IdDisplay> tags) {
        if (tags.contains(GOOGLE_APIS_TAG) || tags.contains(PLAY_STORE_TAG)) {
            return true;
        }
        return tags.size() == 1 && TAGS_WITH_GOOGLE_API.contains(tags.iterator().next());
    }

    public static boolean isWearImage(Collection<IdDisplay> tags) {
        return tags.contains(WEAR_TAG);
    }

    public static boolean isTvImage(Collection<IdDisplay> tags) {
        return tags.stream().anyMatch(TV_TAGS::contains);
    }

    public static boolean isDesktopImage(Collection<IdDisplay> tags) {
        return tags.contains(DESKTOP_TAG);
    }

    public static boolean isAutomotiveImage(Collection<IdDisplay> tags) {
        return tags.contains(AUTOMOTIVE_TAG) || tags.contains(AUTOMOTIVE_PLAY_STORE_TAG) || tags.contains(AUTOMOTIVE_DISTANT_DISPLAY_TAG);
    }

    public static ImmutableList<IdDisplay> getTags(RepoPackage pkg) {
        TypeDetails details = pkg.getTypeDetails();
        if (details instanceof DetailsTypes.SysImgDetailsType) {
            return ImmutableList.copyOf(((DetailsTypes.SysImgDetailsType)details).getTags());
        }
        if (details instanceof DetailsTypes.AddonDetailsType) {
            return ImmutableList.of((Object)((DetailsTypes.AddonDetailsType)details).getTag());
        }
        return ImmutableList.of();
    }
}

