/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils;

import com.android.testutils.JarTestSuite;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.manipulation.Sorter;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class JarTestSuiteRunner
extends Suite {
    public JarTestSuiteRunner(Class<?> suiteClass, RunnerBuilder builder) throws InitializationError, ClassNotFoundException, IOException {
        super(builder, suiteClass, (Class[])JarTestSuiteRunner.getTestClasses(suiteClass));
        String seed = System.getProperty("test.seed");
        if (seed != null) {
            this.randomizeTestOrder(Long.parseLong(seed));
        }
    }

    private void randomizeTestOrder(long seed) {
        HashMap<Description, Integer> values = new HashMap<Description, Integer>();
        Random random = new Random(seed);
        JarTestSuiteRunner.assign(this.getDescription(), random, values);
        super.sort(new Sorter(Comparator.comparingInt(values::get)));
    }

    private static void assign(Description description, Random random, Map<Description, Integer> values) {
        values.put(description, random.nextInt());
        for (Description child : description.getChildren()) {
            JarTestSuiteRunner.assign(child, random, values);
        }
    }

    private static Class<?>[] getTestClasses(Class<?> suiteClass) throws ClassNotFoundException, IOException {
        ArrayList testClasses = new ArrayList();
        HashSet<String> excludeClassNames = new HashSet<String>();
        String name = System.getProperty("test.suite.jar");
        if (name != null) {
            ClassLoader loader = JarTestSuite.class.getClassLoader();
            if (loader instanceof URLClassLoader) {
                ArrayDeque<URL> urls = new ArrayDeque<URL>();
                urls.addAll(Arrays.asList(((URLClassLoader)loader).getURLs()));
                while (!urls.isEmpty()) {
                    URL url = (URL)urls.remove();
                    if (url.getPath().endsWith(name)) {
                        testClasses.addAll(JarTestSuiteRunner.getTestClasses(url, loader));
                    }
                    JarTestSuiteRunner.addManifestClassPath(url, urls);
                }
            }
            excludeClassNames.addAll(JarTestSuiteRunner.classNamesToExclude(suiteClass, testClasses));
        }
        return (Class[])testClasses.stream().filter(c -> !excludeClassNames.contains(c.getCanonicalName())).toArray(Class[]::new);
    }

    private static void addManifestClassPath(URL jarUrl, Queue<URL> urls) throws IOException {
        block29: {
            if (jarUrl.getPath().endsWith(".jar")) {
                File file = new File(jarUrl.getFile());
                try (ZipFile zipFile = new ZipFile(file);){
                    ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
                    if (entry == null) break block29;
                    try (InputStream is = zipFile.getInputStream(entry);){
                        Manifest manifest = new Manifest(is);
                        Attributes attributes = manifest.getMainAttributes();
                        String cp = attributes.getValue("Class-Path");
                        if (cp != null) {
                            String[] paths;
                            for (String path : paths = cp.split(" ")) {
                                try {
                                    URL url = new URL(path);
                                    urls.add(url);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static Set<String> classNamesToExclude(Class<?> suiteClass, List<Class<?>> testClasses) {
        Set testClassNames = testClasses.stream().map(Class::getCanonicalName).collect(Collectors.toSet());
        HashSet<String> excludeClassNames = new HashSet<String>();
        ExcludeClasses annotation = suiteClass.getAnnotation(ExcludeClasses.class);
        if (annotation != null) {
            for (Class<?> classToExclude : annotation.value()) {
                String className = classToExclude.getCanonicalName();
                if (!excludeClassNames.add(className)) {
                    throw new RuntimeException(String.format("on %s, %s value duplicated: %s", suiteClass.getSimpleName(), ExcludeClasses.class.getSimpleName(), className));
                }
                if (testClassNames.contains(className)) continue;
                throw new RuntimeException(String.format("on %s, %s value not found: %s", suiteClass.getSimpleName(), ExcludeClasses.class.getSimpleName(), className));
            }
        }
        return excludeClassNames;
    }

    private static List<Class<?>> getTestClasses(URL url, ClassLoader loader) throws ClassNotFoundException, IOException {
        ArrayList testClasses = new ArrayList();
        File file = new File(url.getFile());
        if (file.exists()) {
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(file));){
                ZipEntry ze;
                while ((ze = zis.getNextEntry()) != null) {
                    String className;
                    Class<?> aClass;
                    if (!ze.getName().endsWith(".class") || !JarTestSuiteRunner.seemsLikeJUnit3(aClass = loader.loadClass(className = ze.getName().replaceAll("/", ".").replaceAll(".class$", ""))) && !JarTestSuiteRunner.seemsLikeJUnit4(aClass)) continue;
                    testClasses.add(aClass);
                }
            }
            catch (ZipException e) {
                System.err.println("Error while opening jar " + file.getName() + " : " + e.getMessage());
            }
        }
        return testClasses;
    }

    private static boolean seemsLikeJUnit3(Class<?> aClass) {
        return (TestCase.class.isAssignableFrom(aClass) || TestSuite.class.isAssignableFrom(aClass)) && !Modifier.isAbstract(aClass.getModifiers());
    }

    private static boolean seemsLikeJUnit4(Class<?> aClass) {
        Predicate<Method> hasTestAnnotation = method -> method.isAnnotationPresent(Test.class);
        return aClass.isAnnotationPresent(RunWith.class) || Arrays.stream(aClass.getMethods()).anyMatch(hasTestAnnotation);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ExcludeClasses {
        public Class<?>[] value();
    }
}

