/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public final class TestClassesGenerator {
    public static byte[] emptyClass(String pkg, String name) throws Exception {
        return TestClassesGenerator.emptyClass(pkg, name, "java/lang/Object");
    }

    public static byte[] emptyClass(String pkg, String name, String superName) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 33, pkg + "/" + name, null, superName, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static byte[] classWithEmptyMethods(String className, String ... namesAndDescriptors) throws Exception {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 33, "test/" + className, null, "java/lang/Object", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        for (String namesAndDescriptor : namesAndDescriptors) {
            int colon = namesAndDescriptor.indexOf(58);
            String methodName = namesAndDescriptor.substring(0, colon);
            String descriptor = namesAndDescriptor.substring(colon + 1, namesAndDescriptor.length());
            mv = cw.visitMethod(1, methodName, descriptor, null, null);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitMaxs(0, 1);
            mv.visitEnd();
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static byte[] classWithFieldsAndMethods(String className, List<String> fields, List<String> methods) throws Exception {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 33, className, null, "java/lang/Object", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        for (String fieldName : fields) {
            FieldVisitor fv = cw.visitField(2, fieldName, "Ljava/lang/String;", null, null);
            fv.visitEnd();
        }
        for (String namesAndDescriptor : methods) {
            int colon = namesAndDescriptor.indexOf(58);
            String methodName = namesAndDescriptor.substring(0, colon);
            String descriptor = namesAndDescriptor.substring(colon + 1, namesAndDescriptor.length());
            mv = cw.visitMethod(1, methodName, descriptor, null, null);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitMaxs(0, 1);
            mv.visitEnd();
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static byte[] classWithStrings(String className, int cntStringsToGenerate) throws Exception {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 33, className, null, "java/lang/Object", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (int i = 0; i < cntStringsToGenerate; ++i) {
            mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
            mv.visitLdcInsn((Object)("generated_string_" + className + "_" + i));
            mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static byte[] rewriteToVersion(int newVersion, InputStream current) throws IOException {
        byte[] bytes = ByteStreams.toByteArray((InputStream)current);
        ByteBuffer.wrap(bytes).putShort(6, (short)newVersion);
        return bytes;
    }
}

