/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils;

import com.android.testutils.TestClassesGenerator;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.Type;

public final class TestInputsGenerator {
    public static void jarWithEmptyClasses(Path path, Collection<String> classNames) throws Exception {
        try (ZipOutputStream outputStream = new ZipOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            for (String fullName : classNames) {
                String className;
                int lastSeparator = fullName.lastIndexOf(47);
                String pkg = "";
                if (lastSeparator != -1) {
                    pkg = fullName.substring(0, lastSeparator);
                    className = fullName.substring(lastSeparator + 1);
                } else {
                    className = fullName;
                }
                byte[] byteCode = TestClassesGenerator.emptyClass(pkg, className);
                TestInputsGenerator.writeToJar(outputStream, byteCode, fullName + ".class");
            }
        }
    }

    public static void dirWithEmptyClasses(Path path, Collection<String> classNames) throws Exception {
        Files.createDirectories(path, new FileAttribute[0]);
        for (String fullName : classNames) {
            String className;
            int lastSeparator = fullName.lastIndexOf(47);
            String pkg = "";
            if (lastSeparator != -1) {
                pkg = fullName.substring(0, lastSeparator);
                className = fullName.substring(lastSeparator + 1);
            } else {
                className = fullName;
            }
            byte[] byteCode = TestClassesGenerator.emptyClass(pkg, className);
            TestInputsGenerator.writeToDir(path, byteCode, fullName + ".class");
        }
    }

    public static void writeJarWithEmptyEntries(Path jar, Iterable<String> entries) throws Exception {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(jar, new OpenOption[0]));){
            for (String name : entries) {
                zipOutputStream.putNextEntry(new ZipEntry(name));
                zipOutputStream.closeEntry();
            }
        }
    }

    public static void pathWithClasses(Path path, Collection<Class<?>> classes) throws IOException {
        if (path.toString().endsWith(".jar")) {
            TestInputsGenerator.jarWithClasses(path, classes);
        } else {
            TestInputsGenerator.dirWithClasses(path, classes);
        }
    }

    private static void jarWithClasses(Path path, Collection<Class<?>> classes) throws IOException {
        try (ZipOutputStream outputStream = new ZipOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            for (Class<?> klass : classes) {
                byte[] data = TestInputsGenerator.getClassInput(klass);
                TestInputsGenerator.writeToJar(outputStream, data, TestInputsGenerator.getPath(klass));
            }
        }
    }

    private static void dirWithClasses(Path path, Collection<Class<?>> classes) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
        for (Class<?> klass : classes) {
            TestInputsGenerator.writeToDir(path, TestInputsGenerator.getClassInput(klass), TestInputsGenerator.getPath(klass));
        }
    }

    public static String getPath(Class<?> klass) {
        return Type.getInternalName(klass) + ".class";
    }

    private static void writeToJar(ZipOutputStream outputStream, byte[] data, String name) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        outputStream.putNextEntry(entry);
        outputStream.write(data);
        outputStream.closeEntry();
    }

    private static void writeToDir(Path path, byte[] data, String name) throws IOException {
        Path srcFile = path.resolve(name);
        Files.createDirectories(srcFile.getParent(), new FileAttribute[0]);
        Files.write(srcFile, data, new OpenOption[0]);
    }

    private static byte[] getClassInput(Class<?> klass) throws IOException {
        try (InputStream stream = klass.getClassLoader().getResourceAsStream(TestInputsGenerator.getPath(klass));){
            byte[] byArray = ByteStreams.toByteArray((InputStream)stream);
            return byArray;
        }
    }
}

