/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils;

import com.android.testutils.OsType;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.junit.Assert;

public class TestUtils {
    private static final Duration DEFAULT_EVENTUALLY_TIMEOUT = Duration.ofSeconds(10L);
    private static final long EVENTUALLY_CHECK_CYCLE_TIME_MS = 10L;
    private static File workspaceRoot = null;

    public static String getKotlinVersionForTests() {
        try {
            return (String)Files.readLines((File)TestUtils.getWorkspaceFile("prebuilts/tools/common/kotlin-plugin/Kotlin/kotlinc/build.txt"), (Charset)Charsets.UTF_8).get(0);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not determine Kotlin plugin version", ex);
        }
    }

    @Deprecated
    public static File getRoot(String ... names) {
        File root = new File("src/test/resources/testData/");
        for (String name : names) {
            File r;
            if (!(root = new File(root, name)).isDirectory() && !root.getPath().contains("sdk-common") && (r = new File("sdk-common", root.getPath()).getAbsoluteFile()).isDirectory()) {
                root = r;
            }
            TestCase.assertTrue((String)("Test folder '" + name + "' does not exist! (Tip: Check unit test launch config pwd)"), (boolean)root.isDirectory());
        }
        return root;
    }

    public static void deleteFile(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File f : files) {
                    TestUtils.deleteFile(f);
                }
            }
        } else if (dir.isFile()) {
            Assert.assertTrue((String)dir.getPath(), (boolean)dir.delete());
        }
    }

    public static File createTempDirDeletedOnExit() {
        File tempDir = Files.createTempDir();
        PathUtils.addRemovePathHook((Path)tempDir.toPath());
        return tempDir;
    }

    public static synchronized File getWorkspaceRoot() {
        if (workspaceRoot == null) {
            String workspace = System.getenv("TEST_WORKSPACE");
            String workspaceParent = System.getenv("TEST_SRCDIR");
            File currDir = new File("");
            if (workspace != null && workspaceParent != null) {
                workspaceRoot = currDir = new File(workspaceParent, workspace);
            }
            File initialDir = currDir;
            while (currDir != null) {
                if (new File(currDir = currDir.getAbsoluteFile(), "WORKSPACE").exists()) {
                    workspaceRoot = currDir;
                }
                currDir = currDir.getParentFile();
            }
            if (workspaceRoot == null) {
                throw new IllegalStateException("Could not find WORKSPACE root. Is the original working directory a subdirectory of the Android Studio codebase?\n\npwd = " + initialDir.getAbsolutePath());
            }
        }
        return workspaceRoot;
    }

    public static File getWorkspaceFile(String path) {
        File f = new File(TestUtils.getWorkspaceRoot(), path);
        if (!f.exists() && OsType.getHostOs() == OsType.WINDOWS) {
            f = new File(f.getPath() + ".exe");
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("File \"" + path + "\" not found at \"" + TestUtils.getWorkspaceRoot() + "\"");
        }
        return f;
    }

    public static File getTestOutputDir() {
        String testOutputDir = System.getenv("TEST_UNDECLARED_OUTPUTS_DIR");
        if (testOutputDir != null) {
            return new File(testOutputDir);
        }
        return TestUtils.createTempDirDeletedOnExit();
    }

    public static File getPlatformFile(String path) {
        String latestAndroidPlatform = TestUtils.getLatestAndroidPlatform();
        File file = FileUtils.join((File)TestUtils.getSdk(), (String[])new String[]{"platforms", latestAndroidPlatform, path});
        if (!file.exists()) {
            throw new IllegalArgumentException("File \"" + path + "\" not found in platform " + latestAndroidPlatform);
        }
        return file;
    }

    public static boolean runningFromBazel() {
        return System.getenv().containsKey("TEST_WORKSPACE");
    }

    public static String getRelativeSdk() {
        OsType osType = OsType.getHostOs();
        if (osType == OsType.UNKNOWN) {
            throw new IllegalStateException("SDK test not supported on unknown platform: " + OsType.getOsName());
        }
        String hostDir = osType.getFolderName();
        return "prebuilts/studio/sdk/" + hostDir;
    }

    public static File getSdk() {
        return TestUtils.getWorkspaceFile(TestUtils.getRelativeSdk());
    }

    public static File getNdk() {
        return new File(TestUtils.getSdk(), "ndk-bundle");
    }

    public static Path getRemoteSdk() {
        return TestUtils.getWorkspaceFile("prebuilts/studio/sdk/remote/dl.google.com/android/repository").toPath();
    }

    public static String getLatestAndroidPlatform() {
        return "android-26";
    }

    public static void waitForFileSystemTick() throws InterruptedException, IOException {
        TestUtils.waitForFileSystemTick(TestUtils.getFreshTimestamp());
    }

    public static void waitForFileSystemTick(long currentTimestamp) throws InterruptedException, IOException {
        while (TestUtils.getFreshTimestamp() <= currentTimestamp) {
            Thread.sleep(100L);
        }
    }

    private static long getFreshTimestamp() throws IOException {
        File notUsed = File.createTempFile(TestUtils.class.getName(), "waitForFileSystemTick");
        long freshTimestamp = notUsed.lastModified();
        FileUtils.delete((File)notUsed);
        return freshTimestamp;
    }

    public static String getDiff(String before, String after) {
        return TestUtils.getDiff(before, after, 0);
    }

    public static String getDiff(String before, String after, int windowSize) {
        return TestUtils.getDiff(before.split("\n"), after.split("\n"), windowSize);
    }

    public static String getDiff(String[] before, String[] after) {
        return TestUtils.getDiff(before, after, 0);
    }

    public static String getDiff(String[] before, String[] after, int windowSize) {
        int j;
        int i;
        StringBuilder sb = new StringBuilder();
        int n = before.length;
        int m = after.length;
        int[][] lcs = new int[n + 1][m + 1];
        for (i = n - 1; i >= 0; --i) {
            for (j = m - 1; j >= 0; --j) {
                lcs[i][j] = before[i].equals(after[j]) ? lcs[i + 1][j + 1] + 1 : Math.max(lcs[i + 1][j], lcs[i][j + 1]);
            }
        }
        i = 0;
        j = 0;
        while (i < n && j < m) {
            int context;
            if (before[i].equals(after[j])) {
                ++i;
                ++j;
                continue;
            }
            sb.append("@@ -");
            sb.append(Integer.toString(i + 1));
            sb.append(" +");
            sb.append(Integer.toString(j + 1));
            sb.append('\n');
            if (windowSize > 0) {
                for (context = Math.max(0, i - windowSize); context < i; ++context) {
                    sb.append("  ");
                    sb.append(before[context]);
                    sb.append("\n");
                }
            }
            while (i < n && j < m && !before[i].equals(after[j])) {
                if (lcs[i + 1][j] >= lcs[i][j + 1]) {
                    sb.append('-');
                    if (!before[i].trim().isEmpty()) {
                        sb.append(' ');
                    }
                    sb.append(before[i]);
                    sb.append('\n');
                    ++i;
                    continue;
                }
                sb.append('+');
                if (!after[j].trim().isEmpty()) {
                    sb.append(' ');
                }
                sb.append(after[j]);
                sb.append('\n');
                ++j;
            }
            if (windowSize <= 0) continue;
            for (context = i; context < Math.min(n, i + windowSize); ++context) {
                sb.append("  ");
                sb.append(before[context]);
                sb.append("\n");
            }
        }
        if (i < n || j < m) {
            assert (i == n || j == m);
            sb.append("@@ -");
            sb.append(Integer.toString(i + 1));
            sb.append(" +");
            sb.append(Integer.toString(j + 1));
            sb.append('\n');
            while (i < n) {
                sb.append('-');
                if (!before[i].trim().isEmpty()) {
                    sb.append(' ');
                }
                sb.append(before[i]);
                sb.append('\n');
                ++i;
            }
            while (j < m) {
                sb.append('+');
                if (!after[j].trim().isEmpty()) {
                    sb.append(' ');
                }
                sb.append(after[j]);
                sb.append('\n');
                ++j;
            }
        }
        return sb.toString();
    }

    public static void eventually(Runnable runnable) {
        TestUtils.eventually(runnable, DEFAULT_EVENTUALLY_TIMEOUT);
    }

    public static void eventually(Runnable runnable, Duration duration) {
        AssertionError lastError = null;
        Instant timeoutTime = Instant.now().plus(duration);
        while (Instant.now().isBefore(timeoutTime)) {
            try {
                runnable.run();
                return;
            }
            catch (AssertionError e) {
                lastError = e;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e2) {
                    throw new AssertionError((Object)e2);
                }
            }
        }
        throw new AssertionError("Timed out waiting for runnable not to throw; last error was:", (Throwable)((Object)lastError));
    }

    public static void launchProcess(Class toRun, String ... args) {
        Process process;
        LinkedList<String> commandAndArgs = new LinkedList<String>();
        commandAndArgs.add(FileUtils.join((String[])new String[]{System.getProperty("java.home"), "bin", "java"}));
        commandAndArgs.add("-cp");
        commandAndArgs.add(System.getProperty("java.class.path"));
        commandAndArgs.add(toRun.getName());
        commandAndArgs.addAll(Arrays.asList(args));
        ProcessBuilder processBuilder = new ProcessBuilder(commandAndArgs);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (process.exitValue() != 0) {
            throw new RuntimeException("Process returned non-zero exit value: " + process.exitValue());
        }
    }
}

