/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils;

import com.android.testutils.VirtualTimeRepeatKind;
import com.android.testutils.VirtualTimeScheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class VirtualTimeFuture<T>
implements ScheduledFuture<T> {
    private static final AtomicLong sCounter = new AtomicLong();
    private final VirtualTimeScheduler mScheduler;
    private final Runnable mRunnable;
    private final Callable<T> mCallable;
    private final long mOffset;
    private final VirtualTimeRepeatKind mRepeatKind;
    private final CountDownLatch mIsDone = new CountDownLatch(1);
    private final long mId;
    private volatile long mTick;
    private volatile long mTimeoutTick = -1L;
    private boolean mIsCancelled;
    private T mValue;
    private Exception mException;

    VirtualTimeFuture(VirtualTimeScheduler virtualTimeScheduler, Runnable runnable, long tick, long offset, VirtualTimeRepeatKind repeatKind) {
        this.mScheduler = virtualTimeScheduler;
        this.mRunnable = runnable;
        this.mTick = tick;
        this.mCallable = null;
        this.mOffset = offset;
        this.mRepeatKind = repeatKind;
        this.mId = sCounter.getAndIncrement();
    }

    VirtualTimeFuture(VirtualTimeScheduler virtualTimeScheduler, Callable<T> callable, long tick, long offset, VirtualTimeRepeatKind repeatKind) {
        this.mScheduler = virtualTimeScheduler;
        this.mTick = tick;
        this.mCallable = callable;
        this.mRunnable = null;
        this.mOffset = offset;
        this.mRepeatKind = repeatKind;
        this.mId = sCounter.getAndIncrement();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long diff = this.mTick - this.mScheduler.getCurrentTimeNanos();
        return unit.convert(diff, TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        if (this.equals(o)) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.mIsCancelled = this.mScheduler.cancel(this);
        this.mIsDone.countDown();
        return this.mIsCancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    @Override
    public boolean isDone() {
        return this.mIsDone.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.mTimeoutTick >= 0L && this.mScheduler.getCurrentTimeNanos() >= this.mTimeoutTick) {
            this.cancel(false);
        }
        this.mIsDone.await();
        if (this.mIsCancelled) {
            throw new CancellationException();
        }
        if (this.mException != null) {
            throw new ExecutionException(this.mException);
        }
        return this.mValue;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.mTimeoutTick >= 0L && this.mScheduler.getCurrentTimeNanos() >= this.mTimeoutTick) {
            this.cancel(false);
        }
        long end = unit.toNanos(timeout) + this.mScheduler.getCurrentTimeNanos();
        while (!this.isDone() && this.mScheduler.getCurrentTimeNanos() < end) {
            Thread.sleep(0L);
        }
        if (!this.isDone()) {
            throw new TimeoutException();
        }
        if (this.mIsCancelled) {
            throw new CancellationException();
        }
        if (this.mException != null) {
            throw new ExecutionException(this.mException);
        }
        return this.mValue;
    }

    public long getTick() {
        return this.mTick;
    }

    void setmTick(long mTick) {
        this.mTick = mTick;
    }

    public Runnable getRunnable() {
        return this.mRunnable;
    }

    public Callable<T> getCallable() {
        return this.mCallable;
    }

    public VirtualTimeScheduler getOwningScheduler() {
        return this.mScheduler;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public VirtualTimeRepeatKind getRepeatKind() {
        return this.mRepeatKind;
    }

    void run() {
        if (this.mRepeatKind == VirtualTimeRepeatKind.RATE) {
            this.mScheduler.reschedule(this, this.mOffset);
        }
        try {
            if (this.mRunnable != null) {
                this.mRunnable.run();
            } else {
                this.mValue = this.mCallable.call();
            }
            if (this.mRepeatKind == VirtualTimeRepeatKind.NONE) {
                this.mIsDone.countDown();
            }
        }
        catch (Exception e) {
            this.mException = e;
            this.mIsDone.countDown();
        }
        if (this.mRepeatKind == VirtualTimeRepeatKind.DELAY) {
            this.mScheduler.reschedule(this, this.mOffset);
        }
    }

    public long getId() {
        return this.mId;
    }

    void setTimeoutTick(long timeoutTick) {
        this.mTimeoutTick = timeoutTick;
    }
}

