/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils;

import com.android.testutils.VirtualTimeFuture;
import com.android.testutils.VirtualTimeRepeatKind;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class VirtualTimeScheduler
implements ScheduledExecutorService {
    private final Object mGate = new Object();
    private final PriorityQueue<VirtualTimeFuture<?>> mQueue = new PriorityQueue(new VirtualFuturesComparator());
    private volatile long mCurrentTimeNanos = 0L;
    private volatile long mFurthestScheduledTimeNanos = 0L;
    private volatile long mActionsExecuted = 0L;
    private boolean mIsShutdown = false;
    private boolean mIsTerminated = false;

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.schedule(command, unit.toNanos(delay), -1L, VirtualTimeRepeatKind.NONE);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.schedule(callable, unit.toNanos(delay), -1L, VirtualTimeRepeatKind.NONE);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.schedule(command, unit.toNanos(initialDelay), unit.toNanos(period), VirtualTimeRepeatKind.RATE);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.schedule(command, unit.toNanos(initialDelay), unit.toNanos(delay), VirtualTimeRepeatKind.DELAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.mGate;
        synchronized (object) {
            this.mIsShutdown = true;
            if (this.mQueue.isEmpty()) {
                this.mIsTerminated = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        Object object = this.mGate;
        synchronized (object) {
            this.shutdown();
            for (VirtualTimeFuture<?> entry : this.mQueue) {
                Runnable runnable = entry.getRunnable();
                if (runnable == null) continue;
                runnables.add(runnable);
            }
        }
        return runnables;
    }

    @Override
    public boolean isShutdown() {
        return this.mIsShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.mIsTerminated;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isTerminated()) {
            return true;
        }
        long end = unit.toNanos(timeout) + this.getCurrentTimeNanos();
        while (!this.isTerminated() && this.getCurrentTimeNanos() < end) {
            Thread.sleep(0L);
        }
        return this.getCurrentTimeNanos() < end;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.schedule(task, 0L, 0L, VirtualTimeRepeatKind.NONE);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.submit(() -> {
            task.run();
            return result;
        });
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.schedule(task, 0L, -1L, VirtualTimeRepeatKind.NONE);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.invokeAll(tasks, -1L, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Future<T>> results = new ArrayList<Future<T>>();
        Object object = this.mGate;
        synchronized (object) {
            for (Callable<T> task : tasks) {
                VirtualTimeFuture<T> vft = this.schedule(task, 0L, 0L, VirtualTimeRepeatKind.NONE);
                long timeoutNanos = unit.toNanos(timeout);
                if (timeoutNanos >= 0L) {
                    vft.setTimeoutTick(timeoutNanos + this.mCurrentTimeNanos);
                }
                results.add(vft);
            }
        }
        return results;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.invokeAnyAsFuture(tasks).get();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.invokeAnyAsFuture(tasks).get(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command);
    }

    <T> Future<T> invokeAnyAsFuture(Collection<? extends Callable<T>> tasks) {
        SettableFuture output = SettableFuture.create();
        this.submit(() -> {
            int index = 0;
            for (Callable task : tasks) {
                ++index;
                try {
                    output.set(task.call());
                    return;
                }
                catch (Throwable e) {
                    if (index != tasks.size() - 1) continue;
                    output.setException(e);
                }
            }
        });
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledFuture<?> schedule(Runnable command, long initial, long offset, VirtualTimeRepeatKind repeatKind) {
        Object object = this.mGate;
        synchronized (object) {
            if (this.mIsShutdown) {
                throw new RejectedExecutionException("VirtualTimeScheduler has been shutdown");
            }
            long target = this.mCurrentTimeNanos + initial;
            VirtualTimeFuture vf = new VirtualTimeFuture(this, command, target, offset, repeatKind);
            this.queueAndRecordFurthest(vf);
            return vf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> VirtualTimeFuture<T> schedule(Callable<T> command, long initial, long offset, VirtualTimeRepeatKind repeatKind) {
        Object object = this.mGate;
        synchronized (object) {
            if (this.mIsShutdown) {
                throw new RejectedExecutionException("VirtualTimeScheduler has been shutdown");
            }
            long target = this.mCurrentTimeNanos + initial;
            VirtualTimeFuture<T> vf = new VirtualTimeFuture<T>(this, command, target, offset, repeatKind);
            this.queueAndRecordFurthest(vf);
            return vf;
        }
    }

    private void queueAndRecordFurthest(VirtualTimeFuture<?> future) {
        this.mQueue.add(future);
        this.mFurthestScheduledTimeNanos = Math.max(future.getTick(), this.mFurthestScheduledTimeNanos);
    }

    public long advanceBy(long interval, TimeUnit unit) {
        return this.advanceBy(TimeUnit.NANOSECONDS.convert(interval, unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long advanceBy(long intervalNanos) {
        Object object = this.mGate;
        synchronized (object) {
            long endTimeNanos = intervalNanos + this.mCurrentTimeNanos;
            return this.advanceTo(endTimeNanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long advanceTo(long endTimeNanos) {
        long currentActions = 0L;
        Object object = this.mGate;
        synchronized (object) {
            VirtualTimeFuture<?> next;
            long tick;
            while (!this.mQueue.isEmpty() && (tick = (next = this.mQueue.peek()).getTick()) <= endTimeNanos) {
                this.mCurrentTimeNanos = tick;
                this.mQueue.remove();
                if (next.isCancelled()) continue;
                next.run();
                ++currentActions;
                ++this.mActionsExecuted;
            }
            if (this.mCurrentTimeNanos < endTimeNanos) {
                this.mCurrentTimeNanos = endTimeNanos;
            }
            if (this.mIsShutdown && this.mQueue.isEmpty()) {
                this.mIsTerminated = true;
            }
        }
        return currentActions;
    }

    public long getActionsExecuted() {
        return this.mActionsExecuted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActionsQueued() {
        Object object = this.mGate;
        synchronized (object) {
            return this.mQueue.size();
        }
    }

    public long getFurthestScheduledTimeNanos() {
        return this.mFurthestScheduledTimeNanos;
    }

    public long getCurrentTimeNanos() {
        return this.mCurrentTimeNanos;
    }

    public PriorityQueue<VirtualTimeFuture<?>> getQueue() {
        return new PriorityQueue(this.mQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancel(VirtualTimeFuture<?> virtualTimeFuture) {
        Object object = this.mGate;
        synchronized (object) {
            if (virtualTimeFuture.isDone()) {
                return false;
            }
            if (virtualTimeFuture.getTick() < this.mCurrentTimeNanos) {
                return false;
            }
            return this.mQueue.remove(virtualTimeFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reschedule(VirtualTimeFuture<?> virtualTimeFuture, long offset) {
        Object object = this.mGate;
        synchronized (object) {
            long tick = this.mCurrentTimeNanos + offset;
            virtualTimeFuture.setmTick(tick);
            this.queueAndRecordFurthest(virtualTimeFuture);
        }
    }

    private static class VirtualFuturesComparator
    implements Comparator<VirtualTimeFuture<?>> {
        private VirtualFuturesComparator() {
        }

        @Override
        public int compare(VirtualTimeFuture<?> o1, VirtualTimeFuture<?> o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            long tickDiff = o1.getTick() - o2.getTick();
            if (tickDiff < 0L) {
                return -1;
            }
            if (tickDiff == 0L) {
                return Long.compare(o1.getId(), o2.getId());
            }
            return 1;
        }
    }
}

