/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.apk;

import com.android.testutils.apk.AndroidArchive;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.regex.Pattern;

public final class Aar
extends AndroidArchive {
    private static String toClassName(String name) {
        Aar.checkValidClassName(name);
        return name.substring(1, name.length() - 1) + ".class";
    }

    public Aar(Path file) throws IOException {
        super(file);
    }

    public Aar(File file) throws IOException {
        this(file.toPath());
    }

    @Override
    public boolean containsMainClass(String name) throws IOException {
        return this.getEntryAsZip("classes.jar").getEntry(Aar.toClassName(name)) != null;
    }

    @Override
    public boolean containsSecondaryClass(String name) throws IOException {
        String className = Aar.toClassName(name);
        for (Path lib : this.getEntries(Pattern.compile("^/libs/.*\\.jar"))) {
            if (this.getEntryAsZip(lib.toString()).getEntry(className) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Path getJavaResource(String name) throws IOException {
        return this.getEntryAsZip("classes.jar").getEntry(name);
    }

    @Override
    public String toString() {
        return "Aar<" + this.getFile() + ">";
    }
}

