/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.apk;

import com.android.testutils.apk.Zip;
import java.io.IOException;
import java.nio.file.Path;
import java.util.regex.Pattern;

public abstract class AndroidArchive
extends Zip {
    public static final Pattern CLASS_FORMAT = Pattern.compile("^L([a-zA-Z][a-zA-Z0-9_]*/)*[a-zA-Z0-9$._]+;$");

    public AndroidArchive(Path file) throws IOException {
        super(file);
    }

    public static void checkValidClassName(String className) {
        if (!CLASS_FORMAT.matcher(className).matches()) {
            throw new IllegalArgumentException(String.format("class name '%1$s' must be in the format Lcom/foo/Main;", className));
        }
    }

    public abstract boolean containsMainClass(String var1) throws IOException;

    public abstract boolean containsSecondaryClass(String var1) throws IOException;

    public abstract Path getJavaResource(String var1) throws IOException;

    public final boolean containsClass(String name) throws IOException {
        return this.containsMainClass(name) || this.containsSecondaryClass(name);
    }

    public final Path getResource(String name) {
        return this.getEntry("res/" + name);
    }
}

