/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.apk;

import com.android.testutils.truth.DexUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.raw.HeaderItem;

public final class Dex {
    private final Supplier<byte[]> fileBytesSupplier;
    private final String name;
    private ImmutableMap<String, DexBackedClassDef> classes;

    public Dex(Path path) {
        this(path, path.toString());
    }

    public Dex(File file) {
        this(file.toPath());
    }

    public Dex(byte[] fileContent, String name) {
        this.fileBytesSupplier = () -> fileContent;
        this.name = name;
    }

    Dex(Path path, String name) {
        this.fileBytesSupplier = () -> {
            try {
                return Files.readAllBytes(path);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        this.name = name;
    }

    public ImmutableMap<String, DexBackedClassDef> getClasses() throws IOException {
        if (this.classes != null) {
            return this.classes;
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (DexBackedClassDef classDef : DexUtils.loadDex(this.fileBytesSupplier.get()).getClasses()) {
            mapBuilder.put((Object)classDef.getType(), (Object)classDef);
        }
        this.classes = mapBuilder.build();
        return this.classes;
    }

    public int getVersion() {
        return HeaderItem.getVersion((byte[])this.fileBytesSupplier.get(), (int)0);
    }

    public String toString() {
        return "Dex<" + this.name + ">";
    }
}

