/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.apk;

import com.android.testutils.apk.AndroidArchive;
import com.android.testutils.apk.Dex;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public abstract class DexAndroidArchive
extends AndroidArchive {
    private final Dex mainDex;
    private final List<Dex> secondaryDexes;

    public DexAndroidArchive(Path file, String mainDexName, String secondaryDexName) throws IOException {
        super(file);
        Path dex;
        Path mainDexPath = this.getEntry(mainDexName);
        Dex mainDex = mainDexPath != null ? new Dex(mainDexPath, this.displayName + ":" + mainDexName) : null;
        ImmutableList.Builder secondaryDexes = ImmutableList.builder();
        int index = 2;
        while ((dex = this.getEntry(String.format(secondaryDexName, index))) != null) {
            secondaryDexes.add((Object)new Dex(dex, this.displayName + ":" + secondaryDexName));
            ++index;
        }
        this.mainDex = mainDex;
        this.secondaryDexes = secondaryDexes.build();
    }

    public final Optional<Dex> getMainDexFile() throws IOException {
        return Optional.ofNullable(this.mainDex);
    }

    public final List<Dex> getSecondaryDexFiles() throws IOException {
        return this.secondaryDexes;
    }

    public final List<Dex> getAllDexes() throws IOException {
        ImmutableList.Builder dexListBuilder = ImmutableList.builder();
        if (this.mainDex != null) {
            dexListBuilder.add((Object)this.mainDex);
        }
        return dexListBuilder.addAll(this.secondaryDexes).build();
    }

    @Override
    public final boolean containsMainClass(String name) throws IOException {
        AndroidArchive.checkValidClassName(name);
        return this.mainDex != null && this.mainDex.getClasses().containsKey((Object)name);
    }

    @Override
    public final boolean containsSecondaryClass(String name) throws IOException {
        AndroidArchive.checkValidClassName(name);
        for (Dex dex : this.secondaryDexes) {
            if (!dex.getClasses().containsKey((Object)name)) continue;
            return true;
        }
        return false;
    }
}

