/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.apk;

import com.android.testutils.apk.Apk;
import com.android.testutils.apk.Dex;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;

public final class SplitApks
implements AutoCloseable {
    private final List<Apk> apks;
    private ImmutableMap<String, DexBackedClassDef> allClasses = null;

    public SplitApks(List<Apk> apks) {
        this.apks = ImmutableList.copyOf(apks);
    }

    public Apk get(int index) {
        return this.apks.get(index);
    }

    public int size() {
        return this.apks.size();
    }

    public List<Dex> getAllDexes() throws IOException {
        ImmutableList.Builder allDexes = ImmutableList.builder();
        for (Apk apk : this.apks) {
            allDexes.addAll(apk.getAllDexes());
        }
        return allDexes.build();
    }

    public Map<String, DexBackedClassDef> getAllClasses() throws IOException {
        if (this.allClasses != null) {
            return this.allClasses;
        }
        ImmutableMap.Builder allClassesBuilder = ImmutableMap.builder();
        for (Dex dex : this.getAllDexes()) {
            allClassesBuilder.putAll(dex.getClasses());
        }
        this.allClasses = allClassesBuilder.build();
        return this.allClasses;
    }

    public List<Path> getEntries(String name) {
        return this.apks.stream().map(apk -> apk.getEntry(name)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void close() throws Exception {
        for (Apk apk : this.apks) {
            apk.close();
        }
    }

    public String toString() {
        return "Apks<" + this.apks.stream().map(Apk::toString).collect(Collectors.joining(",")) + ">";
    }
}

