/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.classloader;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public final class MultiClassLoader
extends ClassLoader {
    private final LinkedHashMap<String, Class<?>> classesToLoad = Maps.newLinkedHashMap();

    public MultiClassLoader(List<String> classesToLoad) {
        for (String classToLoad : classesToLoad) {
            this.classesToLoad.put(classToLoad, null);
        }
    }

    public List<Class<?>> load() throws ClassNotFoundException {
        ArrayList loadedClasses = new ArrayList(this.classesToLoad.size());
        for (String classToLoad : this.classesToLoad.keySet()) {
            loadedClasses.add(this.loadClass(classToLoad));
        }
        return loadedClasses;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (String classToLoad : this.classesToLoad.keySet()) {
            if (name.equals(classToLoad)) {
                if (this.classesToLoad.get(classToLoad) == null) {
                    Preconditions.checkState((this.findLoadedClass(classToLoad) == null ? 1 : 0) != 0);
                    this.classesToLoad.put(classToLoad, this.defineClass(classToLoad));
                }
                return this.classesToLoad.get(classToLoad);
            }
            if (!name.startsWith(classToLoad + "$")) continue;
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass == null) {
                loadedClass = this.defineClass(name);
            }
            return loadedClass;
        }
        return super.loadClass(name);
    }

    private Class<?> defineClass(String name) {
        byte[] bytes;
        String classFile = name.replace('.', '/') + ".class";
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(classFile);
        try {
            bytes = MultiClassLoader.convertStreamToBytes(stream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    private static byte[] convertStreamToBytes(InputStream stream) throws IOException {
        byte[] bytes = new byte[stream.available()];
        try (DataInputStream dataInputStream = new DataInputStream(stream);){
            dataInputStream.readFully(bytes);
        }
        return bytes;
    }
}

