/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.concurrency;

import com.android.testutils.TestUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;

public final class InterProcessConcurrencyTester {
    private static final Duration TIMEOUT_TO_START_ACTION_WHEN_CONCURRENCY_EXPECTED = Duration.ofSeconds(60L);
    private static final Duration TIMEOUT_TO_START_ACTION_WHEN_NO_CONCURRENCY_EXPECTED = Duration.ofSeconds(2L);
    private List<Class> classInvocationList = new LinkedList<Class>();
    private List<String[]> argsList = new LinkedList<String[]>();

    public void addClassInvocationFromNewProcess(Class classUnderTest, String[] args) {
        this.classInvocationList.add(classUnderTest);
        this.argsList.add(args);
    }

    public void assertThatActionsCanRunConcurrently() throws IOException {
        Preconditions.checkArgument((this.classInvocationList.size() >= 2 ? 1 : 0) != 0, (Object)"There must be at least 2 actions for concurrency checks.");
        Assert.assertTrue((String)"Two or more actions ran sequentially while all the actions were expected to run concurrently.", (this.executeActionsAndGetRunningPattern(TIMEOUT_TO_START_ACTION_WHEN_CONCURRENCY_EXPECTED) == RunningPattern.CONCURRENT ? 1 : 0) != 0);
    }

    public void assertThatActionsCannotRunConcurrently() throws IOException {
        Preconditions.checkArgument((this.classInvocationList.size() >= 2 ? 1 : 0) != 0, (Object)"There must be at least 2 actions for concurrency checks.");
        Assert.assertTrue((String)"Two or more actions ran concurrently while all the actions were expected to run sequentially.", (this.executeActionsAndGetRunningPattern(TIMEOUT_TO_START_ACTION_WHEN_NO_CONCURRENCY_EXPECTED) == RunningPattern.SEQUENTIAL ? 1 : 0) != 0);
    }

    private RunningPattern executeActionsAndGetRunningPattern(Duration timeoutToStartAction) throws IOException {
        ServerSocket serverSocket = InterProcessConcurrencyTester.openServerSocket();
        LinkedList<Runnable> runnables = new LinkedList<Runnable>();
        for (int i = 0; i < this.classInvocationList.size(); ++i) {
            Class classUnderTest = this.classInvocationList.get(i);
            String[] args = this.argsList.get(i);
            String[] allArgs = Arrays.copyOf(args, args.length + 1);
            allArgs[args.length] = String.valueOf(serverSocket.getLocalPort());
            runnables.add(() -> TestUtils.launchProcess(classUnderTest, allArgs));
        }
        Map<Thread, Optional<Throwable>> threads = InterProcessConcurrencyTester.executeRunnablesInThreads(runnables);
        LinkedList<Socket> startedProcesses = new LinkedList<Socket>();
        while (startedProcesses.size() < runnables.size()) {
            startedProcesses.add(InterProcessConcurrencyTester.acceptSocketOnEvent(serverSocket, ProcessEvent.PROCESS_STARTED));
        }
        while (!startedProcesses.isEmpty()) {
            InterProcessConcurrencyTester.processCanResume((Socket)startedProcesses.remove());
        }
        int remainingActions = this.classInvocationList.size();
        LinkedList<Socket> runningActions = new LinkedList<Socket>();
        int maxConcurrentActions = 0;
        while (remainingActions > 0) {
            Socket startedAction = runningActions.isEmpty() ? InterProcessConcurrencyTester.acceptSocketOnEvent(serverSocket, ProcessEvent.ACTION_STARTED) : InterProcessConcurrencyTester.acceptSocketOnEvent(serverSocket, ProcessEvent.ACTION_STARTED, (int)timeoutToStartAction.toMillis());
            if (startedAction != null) {
                --remainingActions;
                runningActions.add(startedAction);
                if (runningActions.size() <= maxConcurrentActions) continue;
                maxConcurrentActions = runningActions.size();
                continue;
            }
            while (!runningActions.isEmpty()) {
                InterProcessConcurrencyTester.processCanResume((Socket)runningActions.remove());
            }
        }
        while (!runningActions.isEmpty()) {
            InterProcessConcurrencyTester.processCanResume((Socket)runningActions.remove());
        }
        InterProcessConcurrencyTester.waitForThreadsToFinish(threads);
        InterProcessConcurrencyTester.closeServerSocket(serverSocket);
        Preconditions.checkState((maxConcurrentActions >= 1 && maxConcurrentActions <= runnables.size() ? 1 : 0) != 0);
        if (maxConcurrentActions == 1) {
            return RunningPattern.SEQUENTIAL;
        }
        if (maxConcurrentActions == runnables.size()) {
            return RunningPattern.CONCURRENT;
        }
        return RunningPattern.MIXED;
    }

    private static Map<Thread, Optional<Throwable>> executeRunnablesInThreads(List<Runnable> runnables) {
        ConcurrentHashMap<Thread, Optional<Throwable>> threads = new ConcurrentHashMap<Thread, Optional<Throwable>>();
        CountDownLatch allThreadsStartedLatch = new CountDownLatch(runnables.size());
        for (Runnable runnable : runnables) {
            Thread thread = new Thread(() -> {
                allThreadsStartedLatch.countDown();
                runnable.run();
            });
            threads.put(thread, Optional.empty());
            thread.setUncaughtExceptionHandler((aThread, throwable) -> threads.put(aThread, Optional.of(throwable)));
        }
        for (Thread thread : threads.keySet()) {
            thread.start();
        }
        try {
            allThreadsStartedLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return threads;
    }

    private static void waitForThreadsToFinish(Map<Thread, Optional<Throwable>> threads) {
        for (Thread thread : threads.keySet()) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        for (Optional optional : threads.values()) {
            if (!optional.isPresent()) continue;
            throw new RuntimeException((Throwable)optional.get());
        }
    }

    private static ServerSocket openServerSocket() throws IOException {
        return new ServerSocket(0);
    }

    private static Socket acceptSocketOnEvent(ServerSocket serverSocket, ProcessEvent processEvent) throws IOException {
        return (Socket)Verify.verifyNotNull((Object)InterProcessConcurrencyTester.acceptSocketOnEvent(serverSocket, processEvent, 0));
    }

    private static Socket acceptSocketOnEvent(ServerSocket serverSocket, ProcessEvent processEvent, int millisTimeout) throws IOException {
        Socket socket;
        serverSocket.setSoTimeout(millisTimeout);
        try {
            socket = serverSocket.accept();
        }
        catch (SocketTimeoutException e) {
            return null;
        }
        DataInputStream inputStream = new DataInputStream(socket.getInputStream());
        Preconditions.checkState((ProcessEvent.valueOf(inputStream.readUTF()) == processEvent ? 1 : 0) != 0);
        return socket;
    }

    private static void processCanResume(Socket socket) throws IOException {
        try (DataOutputStream outputStream = new DataOutputStream(socket.getOutputStream());){
            outputStream.writeUTF(ProcessEvent.PROCESS_CAN_RESUME.name());
        }
        socket.close();
    }

    private static void closeServerSocket(ServerSocket serverSocket) throws IOException {
        serverSocket.close();
    }

    public static class MainProcessNotifier {
        private final int serverSocketPort;

        public MainProcessNotifier(int serverSocketPort) {
            this.serverSocketPort = serverSocketPort;
        }

        public void processStarted() throws IOException {
            this.notifyMainProcess(ProcessEvent.PROCESS_STARTED);
        }

        public void actionStarted() throws IOException {
            this.notifyMainProcess(ProcessEvent.ACTION_STARTED);
        }

        private void notifyMainProcess(ProcessEvent processEvent) throws IOException {
            try (Socket socket = new Socket("localhost", this.serverSocketPort);
                 DataOutputStream outputStream = new DataOutputStream(socket.getOutputStream());
                 DataInputStream inputStream = new DataInputStream(socket.getInputStream());){
                outputStream.writeUTF(processEvent.name());
                Preconditions.checkState((ProcessEvent.valueOf(inputStream.readUTF()) == ProcessEvent.PROCESS_CAN_RESUME ? 1 : 0) != 0);
            }
        }
    }

    private static enum ProcessEvent {
        PROCESS_STARTED,
        ACTION_STARTED,
        PROCESS_CAN_RESUME;

    }

    private static enum RunningPattern {
        CONCURRENT,
        SEQUENTIAL,
        MIXED;

    }
}

