/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.filesystemdiff;

import com.android.testutils.filesystemdiff.Action;
import com.android.testutils.filesystemdiff.DirectoryEntry;
import com.android.utils.ILogger;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class DeleteDirectoryAction
extends Action {
    private DirectoryEntry mEntry;

    public DeleteDirectoryAction(DirectoryEntry entry) {
        this.mEntry = entry;
    }

    @Override
    public DirectoryEntry getSourceEntry() {
        return this.mEntry;
    }

    @Override
    public void execute(final ILogger logger) {
        try {
            Files.walkFileTree(this.mEntry.getPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    logger.verbose("Deleting file %s", new Object[]{file});
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    logger.verbose("Deleting directory %s", new Object[]{dir});
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

