/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.filesystemdiff;

import com.android.testutils.filesystemdiff.Action;
import com.android.testutils.filesystemdiff.ActionExecutor;
import com.android.testutils.filesystemdiff.CreateDirectoryAction;
import com.android.testutils.filesystemdiff.CreateFileAction;
import com.android.testutils.filesystemdiff.CreateSymbolicLinkAction;
import com.android.testutils.filesystemdiff.DeleteDirectoryAction;
import com.android.testutils.filesystemdiff.DeleteFileAction;
import com.android.testutils.filesystemdiff.DeleteSymbolicLinkAction;
import com.android.testutils.filesystemdiff.DirectoryEntry;
import com.android.testutils.filesystemdiff.FileEntry;
import com.android.testutils.filesystemdiff.FileSystemEntry;
import com.android.testutils.filesystemdiff.SymbolicLinkEntry;
import com.android.utils.ILogger;
import java.util.ArrayList;
import java.util.List;

public class Script {
    private List<Action> mActions = new ArrayList<Action>();

    public List<Action> getActions() {
        return this.mActions;
    }

    public void addCreateEntry(FileSystemEntry source, FileSystemEntry destination) {
        assert (destination.getKind() == source.getKind());
        switch (source.getKind()) {
            case Directory: {
                this.mActions.add(new CreateDirectoryAction((DirectoryEntry)source, (DirectoryEntry)destination));
                break;
            }
            case SymbolicLink: {
                this.mActions.add(new CreateSymbolicLinkAction((SymbolicLinkEntry)source, (SymbolicLinkEntry)destination));
                break;
            }
            case File: {
                this.mActions.add(new CreateFileAction((FileEntry)source, (FileEntry)destination));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void addDeleteEntry(FileSystemEntry entry) {
        switch (entry.getKind()) {
            case Directory: {
                this.mActions.add(new DeleteDirectoryAction((DirectoryEntry)entry));
                break;
            }
            case SymbolicLink: {
                this.mActions.add(new DeleteSymbolicLinkAction((SymbolicLinkEntry)entry));
                break;
            }
            case File: {
                this.mActions.add(new DeleteFileAction((FileEntry)entry));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void execute(ILogger logger) {
        this.execute(logger, new ActionExecutor());
    }

    public void execute(ILogger logger, ActionExecutor executor) {
        for (Action action : this.getActions()) {
            executor.execute(logger, action);
        }
    }
}

