/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.filesystemdiff;

import com.android.testutils.filesystemdiff.DirectoryEntry;
import com.android.testutils.filesystemdiff.FileEntry;
import com.android.testutils.filesystemdiff.FileSystemEntry;
import com.android.testutils.filesystemdiff.SymbolicLinkDefinition;
import com.android.testutils.filesystemdiff.SymbolicLinkEntry;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;

public class TreeBuilder {
    public static FileSystemEntry buildFromFileSystem(Path rootPath) {
        FileSystemEntry root = TreeBuilder.mapPath(rootPath);
        if (root instanceof DirectoryEntry) {
            DirectoryEntry dirEntry = (DirectoryEntry)root;
            ForkJoinPool pool = new ForkJoinPool();
            pool.invoke(new TraverseDirectoryTask(dirEntry));
        }
        return root;
    }

    public static FileSystemEntry buildFromSymbolicLinkDefinitions(Path rootPath, Iterable<SymbolicLinkDefinition> symbolicLinks) {
        DirectoryEntry root = new DirectoryEntry(rootPath);
        HashMap<Path, DirectoryEntry> directories = new HashMap<Path, DirectoryEntry>();
        directories.put(root.getPath(), root);
        for (SymbolicLinkDefinition link : symbolicLinks) {
            SymbolicLinkEntry childEntry = new SymbolicLinkEntry(link.getPath(), link.getTarget());
            DirectoryEntry parentEntry = TreeBuilder.getOrCreateDirectoryEntry(root, directories, link.getPath().getParent());
            parentEntry.addChildEntry(childEntry);
        }
        return root;
    }

    private static DirectoryEntry getOrCreateDirectoryEntry(DirectoryEntry root, Map<Path, DirectoryEntry> directories, Path directoryPath) {
        if (directoryPath == null) {
            return root;
        }
        DirectoryEntry entry = directories.get(directoryPath);
        if (entry != null) {
            return entry;
        }
        entry = new DirectoryEntry(directoryPath);
        directories.put(directoryPath, entry);
        DirectoryEntry parentEntry = TreeBuilder.getOrCreateDirectoryEntry(root, directories, directoryPath.getParent());
        parentEntry.addChildEntry(entry);
        return entry;
    }

    private static FileSystemEntry mapPath(Path path) {
        BasicFileAttributes attributes;
        try {
            attributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (attributes.isSymbolicLink()) {
            try {
                return new SymbolicLinkEntry(path, Files.readSymbolicLink(path));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (attributes.isDirectory()) {
            return new DirectoryEntry(path);
        }
        return new FileEntry(path);
    }

    public static class TraverseDirectoryTask
    extends RecursiveTask<DirectoryEntry> {
        private DirectoryEntry mRoot;

        public TraverseDirectoryTask(DirectoryEntry root) {
            this.mRoot = root;
        }

        @Override
        protected DirectoryEntry compute() {
            try {
                try (DirectoryStream<Path> childPaths = Files.newDirectoryStream(this.mRoot.getPath());){
                    ArrayList<TraverseDirectoryTask> tasks = new ArrayList<TraverseDirectoryTask>();
                    for (Path childPath : childPaths) {
                        FileSystemEntry child = TreeBuilder.mapPath(childPath);
                        if (child instanceof DirectoryEntry) {
                            tasks.add(new TraverseDirectoryTask((DirectoryEntry)child));
                            continue;
                        }
                        this.mRoot.addChildEntry(child);
                    }
                    TraverseDirectoryTask.invokeAll(tasks);
                    tasks.forEach(x -> this.mRoot.addChildEntry(x.mRoot));
                }
                return this.mRoot;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

