/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.truth;

import com.android.testutils.apk.Zip;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class AbstractZipSubject<S extends Subject<S, T>, T extends Zip>
extends Subject<S, T>
implements Closeable {
    public AbstractZipSubject(FailureStrategy failureStrategy, T subject) {
        super(failureStrategy, subject);
    }

    public abstract void contains(String var1) throws IOException;

    public abstract void doesNotContain(String var1) throws IOException;

    public final IterableSubject<? extends IterableSubject<?, String, List<String>>, String, List<String>> entries(String conformingTo) throws IOException {
        this.exists();
        return this.check().that((Iterable)((Zip)this.getSubject()).getEntries(Pattern.compile(conformingTo)).stream().map(Path::toString).collect(Collectors.toList()));
    }

    public final void containsFileWithContent(String path, String content) throws IOException {
        this.exists();
        ((StringSubject)this.check().that(this.extractContentAsString(path).trim()).named(this.internalCustomName() + ": " + path)).isEqualTo((Object)content.trim());
    }

    public final void containsFileWithMatch(String path, String pattern) throws IOException {
        this.exists();
        this.check().that(this.extractContentAsString(path)).containsMatch(pattern);
    }

    public final void containsFileWithContent(String path, byte[] content) throws IOException {
        this.exists();
        String subjectName = (String)MoreObjects.firstNonNull((Object)this.internalCustomName(), (Object)((Zip)this.getSubject()).getFile().getFileName().toString());
        byte[] actual = this.extractContentAsBytes(path);
        ((PrimitiveByteArraySubject)this.check().that(actual).named(path + " in " + subjectName + " content=" + Arrays.toString(actual))).isEqualTo((Object)content);
    }

    public final void containsFileWithoutContent(String path, String sub) {
        int index;
        this.exists();
        byte[] contents = this.extractContentAsBytes(path);
        if (contents == null) {
            this.failWithRawMessage("No entry with path " + path, new Object[0]);
        }
        if ((index = Bytes.indexOf((byte[])contents, (byte[])sub.getBytes())) != -1) {
            this.failWithRawMessage("Found byte sequence at " + index + " in class file " + path, new Object[0]);
        }
    }

    public final void exists() {
        if (!((Zip)this.getSubject()).exists()) {
            this.fail("exists");
        }
    }

    public final void doesNotExist() {
        if (((Zip)this.getSubject()).exists()) {
            this.fail("does not exist");
        }
    }

    @Override
    public final void close() {
        try {
            ((Zip)this.getSubject()).close();
        }
        catch (Exception e) {
            this.failWithRawMessage("Exception while closing %1$s", new Object[]{this.getSubject()});
        }
    }

    protected final String extractContentAsString(String path) {
        Path entry = ((Zip)this.getSubject()).getEntry(path);
        if (entry == null) {
            this.failWithRawMessage("Entry %s does not exist in zip %s.", new Object[]{path, ((Zip)this.getSubject()).toString()});
            return null;
        }
        try {
            return Files.readAllLines(entry).stream().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            this.failWithRawMessage("IOException when extracting %1$s from zip %2$s: %3$s", new Object[]{path, this.getSubject(), e.toString()});
            return null;
        }
    }

    protected final byte[] extractContentAsBytes(String path) {
        Path entry = ((Zip)this.getSubject()).getEntry(path);
        if (entry == null) {
            this.failWithRawMessage("Entry " + path + " does not exist.", new Object[0]);
            return null;
        }
        try {
            return Files.readAllBytes(entry);
        }
        catch (IOException e) {
            this.failWithRawMessage("IOException when extracting %1$s from zip %2$s: %3$s", new Object[]{path, this.getSubject(), e.toString()});
            return null;
        }
    }
}

