/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.truth;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.util.Optional;

public class Java8OptionalSubject<T>
extends Subject<Java8OptionalSubject<T>, Optional<T>> {
    private static final SubjectFactory<Java8OptionalSubject<Object>, Optional<Object>> FACTORY = new SubjectFactory<Java8OptionalSubject<Object>, Optional<Object>>(){

        public Java8OptionalSubject<Object> getSubject(FailureStrategy fs, Optional<Object> that) {
            return new Java8OptionalSubject<Object>(fs, that);
        }
    };

    public Java8OptionalSubject(FailureStrategy failureStrategy, Optional<T> subject) {
        super(failureStrategy, subject);
    }

    public static <T> Java8OptionalSubject<T> assertThat(Optional<T> optional) {
        return (Java8OptionalSubject)Truth.assert_().about(FACTORY).that(optional);
    }

    public void isPresent() {
        if (!((Optional)this.getSubject()).isPresent()) {
            this.fail("is present");
        }
    }

    public void hasValueEqualTo(T value) {
        Object actual;
        if (!((Optional)this.getSubject()).isPresent()) {
            this.fail("is present");
        }
        if (!(actual = ((Optional)this.getSubject()).get()).equals(value)) {
            this.failWithBadResults("is equals to", value.toString(), "is", actual);
        }
    }

    public void isAbsent() {
        if (((Optional)this.getSubject()).isPresent()) {
            this.fail("is not present");
        }
    }
}

