/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.truth;

import com.google.common.base.Joiner;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.List;

public class PathSubject
extends Subject<PathSubject, Path> {
    public static final SubjectFactory<PathSubject, Path> FACTORY = new SubjectFactory<PathSubject, Path>(){

        public PathSubject getSubject(FailureStrategy fs, Path that) {
            return new PathSubject(fs, that);
        }
    };

    public PathSubject(FailureStrategy failureStrategy, Path subject) {
        super(failureStrategy, (Object)subject);
    }

    public static PathSubject assertThat(Path path) {
        return (PathSubject)Truth.assert_().about(FACTORY).that((Object)path);
    }

    public static PathSubject assertThat(File file) {
        return PathSubject.assertThat(file == null ? null : file.toPath());
    }

    public void hasName(String name) {
        ((StringSubject)this.check().that(((Path)this.getSubject()).getFileName().toString()).named(this.getDisplaySubject())).isEqualTo((Object)name);
    }

    public void exists() {
        if (!Files.exists((Path)this.getSubject(), new LinkOption[0])) {
            this.fail("exists");
        }
    }

    public void doesNotExist() {
        if (Files.exists((Path)this.getSubject(), new LinkOption[0])) {
            this.fail("does not exist");
        }
    }

    public void isFile() {
        if (!Files.isRegularFile((Path)this.getSubject(), new LinkOption[0])) {
            this.fail("is a file");
        }
    }

    public void isDirectory() {
        if (!Files.isDirectory((Path)this.getSubject(), new LinkOption[0])) {
            this.fail("is a directory");
        }
    }

    public void isExecutable() {
        if (!Files.isExecutable((Path)this.getSubject())) {
            this.fail("is not executable");
        }
    }

    public void hasContents(byte[] expectedContents) throws IOException {
        this.exists();
        try {
            byte[] contents = Files.readAllBytes((Path)this.getSubject());
            if (!Arrays.equals(contents, expectedContents)) {
                this.failWithBadResults("contains", "byte[" + expectedContents.length + "]", "is", "byte[" + contents.length + "]");
            }
        }
        catch (IOException e) {
            this.failWithRawMessage("Unable to read %s", new Object[]{this.getSubject()});
        }
    }

    public void hasContents(String ... expectedContents) throws IOException {
        this.exists();
        try {
            List<String> contents = Files.readAllLines((Path)this.getSubject());
            if (!Arrays.asList(expectedContents).equals(contents)) {
                this.failWithBadResults("contains", Joiner.on((char)'\n').join((Object[])expectedContents), "is", Joiner.on((char)'\n').join(contents));
            }
        }
        catch (IOException e) {
            this.failWithRawMessage("Unable to read %s", new Object[]{this.getSubject()});
        }
    }

    public void wasModifiedAt(FileTime expectedTime) throws IOException {
        FileTime actualTime = Files.getLastModifiedTime((Path)this.getSubject(), new LinkOption[0]);
        if (!actualTime.equals(expectedTime)) {
            this.failWithBadResults("was last modified at", expectedTime, "was last modified at", actualTime);
        }
    }

    public void isNewerThan(FileTime expectedTime) throws IOException {
        FileTime actualTime = Files.getLastModifiedTime((Path)this.getSubject(), new LinkOption[0]);
        if (actualTime.compareTo(expectedTime) <= 0) {
            this.failWithBadResults("was modified after", expectedTime, "was last modified at", actualTime);
        }
    }
}

