/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.deviceprovider.gradle;

import com.android.tools.utp.plugins.deviceprovider.gradle.EmulatorHandle;
import com.google.testing.platform.core.device.DeviceProviderException;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.lib.process.Handle;
import com.google.testing.platform.lib.process.inject.SubprocessComponent;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J(\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/utp/plugins/deviceprovider/gradle/EmulatorHandleImpl;", "Lcom/android/tools/utp/plugins/deviceprovider/gradle/EmulatorHandle;", "subprocessComponent", "Lcom/google/testing/platform/lib/process/inject/SubprocessComponent;", "(Lcom/google/testing/platform/lib/process/inject/SubprocessComponent;)V", "emulatorGpuFlag", "", "emulatorPath", "logger", "Ljava/util/logging/Logger;", "processHandle", "Lcom/google/testing/platform/lib/process/Handle;", "showEmulatorKernelLogging", "", "closeInstance", "", "configure", "isAlive", "launchInstance", "avdName", "avdFolder", "avdId", "enableDisplay", "Companion", "android-device-provider-gradle"})
public final class EmulatorHandleImpl
implements EmulatorHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SubprocessComponent subprocessComponent;
    @NotNull
    private final Logger logger;
    private String emulatorPath;
    private String emulatorGpuFlag;
    private boolean showEmulatorKernelLogging;
    private Handle processHandle;
    @NotNull
    private static final String EMULATOR_NO_WINDOW = "-no-window";
    @NotNull
    private static final String EMULATOR_GPU = "-gpu";
    @NotNull
    private static final String EMULATOR_NO_AUDIO = "-no-audio";
    @NotNull
    private static final String EMULATOR_NO_BOOT_ANIM = "-no-boot-anim";
    @NotNull
    private static final String EMULATOR_READ_ONLY = "-read-only";
    @NotNull
    private static final String EMULATOR_VERBOSE = "-verbose";
    @NotNull
    private static final String EMULATOR_SHOW_KERNEL = "-show-kernel";

    public EmulatorHandleImpl(@NotNull SubprocessComponent subprocessComponent) {
        Intrinsics.checkNotNullParameter((Object)subprocessComponent, (String)"subprocessComponent");
        this.subprocessComponent = subprocessComponent;
        this.logger = LoggerExtKt.getLogger((Object)this);
    }

    @Override
    public void configure(@NotNull String emulatorPath, @NotNull String emulatorGpuFlag, boolean showEmulatorKernelLogging) {
        Intrinsics.checkNotNullParameter((Object)emulatorPath, (String)"emulatorPath");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        this.emulatorPath = emulatorPath;
        this.emulatorGpuFlag = emulatorGpuFlag;
        this.showEmulatorKernelLogging = showEmulatorKernelLogging;
    }

    @Override
    public boolean isAlive() {
        boolean bl;
        if (this.processHandle != null) {
            Handle handle;
            Handle handle2 = this.processHandle;
            if (handle2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processHandle");
                handle = null;
            } else {
                handle = handle2;
            }
            bl = handle.isAlive();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void launchInstance(@NotNull String avdName, @NotNull String avdFolder, @NotNull String avdId, boolean enableDisplay) {
        Object object;
        Object object2;
        String string;
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
        Intrinsics.checkNotNullParameter((Object)avdId, (String)"avdId");
        Object object3 = new String[1];
        Object object4 = this.emulatorPath;
        if (object4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emulatorPath");
            string = null;
        } else {
            string = object4;
        }
        object3[0] = string;
        List args = CollectionsKt.mutableListOf((Object[])object3);
        args.add(Intrinsics.stringPlus((String)"@", (Object)avdName));
        if (!enableDisplay) {
            args.add(EMULATOR_NO_WINDOW);
            args.add(EMULATOR_NO_AUDIO);
        }
        args.add(EMULATOR_GPU);
        object3 = this.emulatorGpuFlag;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emulatorGpuFlag");
            object2 = null;
        } else {
            object2 = object3;
        }
        args.add(object2);
        args.add(EMULATOR_READ_ONLY);
        args.add(EMULATOR_NO_BOOT_ANIM);
        if (this.showEmulatorKernelLogging) {
            args.add(EMULATOR_VERBOSE);
            args.add(EMULATOR_SHOW_KERNEL);
        }
        args.add("-id");
        args.add(avdId);
        object4 = System.getenv();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getenv()");
        Map emulatorEnvironment = MapsKt.toMutableMap((Map)object4);
        object4 = emulatorEnvironment;
        String string2 = "ANDROID_AVD_HOME";
        boolean bl = false;
        object4.put(string2, avdFolder);
        this.processHandle = this.subprocessComponent.subprocess().executeAsync(args, emulatorEnvironment, (Function1)new Function1<String, Unit>((Object)this.logger){

            public final void invoke(String p0) {
                ((Logger)this.receiver).info(p0);
            }
        }, (Function1)new Function1<String, Unit>((Object)this.logger){

            public final void invoke(String p0) {
                ((Logger)this.receiver).info(p0);
            }
        });
        object4 = this.processHandle;
        if (object4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processHandle");
            object = null;
        } else {
            object = object4;
        }
        if (!object.isAlive()) {
            throw new DeviceProviderException(Intrinsics.stringPlus((String)"Booting the emulator failed. Command was: ", (Object)CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)), null, null, 6, null);
        }
    }

    @Override
    public void closeInstance() {
        if (this.processHandle != null) {
            Handle handle;
            Handle handle2 = this.processHandle;
            if (handle2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processHandle");
                handle = null;
            } else {
                handle = handle2;
            }
            handle.destroy();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/utp/plugins/deviceprovider/gradle/EmulatorHandleImpl$Companion;", "", "()V", "EMULATOR_GPU", "", "EMULATOR_NO_AUDIO", "EMULATOR_NO_BOOT_ANIM", "EMULATOR_NO_WINDOW", "EMULATOR_READ_ONLY", "EMULATOR_SHOW_KERNEL", "EMULATOR_VERBOSE", "android-device-provider-gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

