/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.apkinstaller;

import com.android.tools.utp.plugins.host.apkinstaller.AndroidTestApkInstallerPlugin;
import com.android.tools.utp.plugins.host.apkinstaller.proto.AndroidApkInstallerConfigProto;
import com.google.protobuf.ProtocolStringList;
import com.google.testing.platform.api.config.Config;
import com.google.testing.platform.api.config.ConfigExtKt;
import com.google.testing.platform.api.context.Context;
import com.google.testing.platform.api.context.ContextExtKt;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.device.DeviceProperties;
import com.google.testing.platform.api.error.ErrorSummary;
import com.google.testing.platform.api.plugin.HostPlugin;
import com.google.testing.platform.core.error.ErrorType;
import com.google.testing.platform.core.error.UtpException;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.lib.process.Handle;
import com.google.testing.platform.lib.process.Subprocess;
import com.google.testing.platform.lib.process.inject.SubprocessComponent;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import com.google.testing.platform.runtime.android.device.AndroidDeviceProperties;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 52\u00020\u0001:\u00015B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J&\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!H\u0002J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010&\u001a\u00020\u0019H\u0016J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0006H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J*\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0!2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u00020\u0019H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\"\u00104\u001a\u0004\u0018\u00010\n2\u0006\u00100\u001a\u0002012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\nH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin;", "Lcom/google/testing/platform/api/plugin/HostPlugin;", "logger", "Ljava/util/logging/Logger;", "subprocessComponentFactory", "Lkotlin/Function1;", "Lcom/google/testing/platform/api/context/Context;", "Lcom/google/testing/platform/lib/process/inject/SubprocessComponent;", "(Ljava/util/logging/Logger;Lkotlin/jvm/functions/Function1;)V", "aaptPath", "", "installables", "", "Lcom/google/testing/platform/proto/api/core/TestArtifactProto$Artifact;", "pluginConfig", "Lcom/android/tools/utp/plugins/host/apkinstaller/proto/AndroidApkInstallerConfigProto$AndroidApkInstallerConfig;", "subprocessComponent", "userId", "afterAll", "", "testSuiteResult", "Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "deviceController", "Lcom/google/testing/platform/api/device/DeviceController;", "cancelled", "", "afterEach", "testResult", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "apkInstallErrorMessage", "apkPath", "deviceSerial", "additionalOutput", "", "beforeAll", "beforeEach", "testCase", "Lcom/google/testing/platform/proto/api/core/TestCaseProto$TestCase;", "canRun", "configure", "context", "getFeatureMinApiLevel", "Lcom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin$Companion$MinFeatureApiLevel;", "installOption", "Lcom/android/tools/utp/plugins/host/apkinstaller/proto/AndroidApkInstallerConfigProto$InstallableApk$InstallOption;", "getInstallCmd", "installableApk", "Lcom/android/tools/utp/plugins/host/apkinstaller/proto/AndroidApkInstallerConfigProto$InstallableApk;", "deviceApiLevel", "", "forceReinstall", "getPackageNameFromApk", "getUserId", "Companion", "android-test-plugin-host-apk-installer"})
@SourceDebugExtension(value={"SMAP\nAndroidTestApkInstallerPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTestApkInstallerPlugin.kt\ncom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin\n+ 2 ConfigExt.kt\ncom/google/testing/platform/api/config/ConfigExtKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n64#2:373\n1849#3,2:374\n1849#3:376\n1849#3,2:378\n1850#3:380\n1849#3:381\n1849#3,2:382\n1850#3:384\n1#4:377\n*S KotlinDebug\n*F\n+ 1 AndroidTestApkInstallerPlugin.kt\ncom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin\n*L\n174#1:373\n205#1:374,2\n226#1:376\n259#1:378,2\n226#1:380\n352#1:381\n354#1:382,2\n352#1:384\n*E\n"})
public final class AndroidTestApkInstallerPlugin
implements HostPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Function1<Context, SubprocessComponent> subprocessComponentFactory;
    private AndroidApkInstallerConfigProto.AndroidApkInstallerConfig pluginConfig;
    private Set<TestArtifactProto.Artifact> installables;
    @Nullable
    private String userId;
    private SubprocessComponent subprocessComponent;
    private String aaptPath;
    @NotNull
    private static final List<String> BASE_INSTALL_CMD = CollectionsKt.listOf((Object)"install");
    @NotNull
    private static final List<String> INSTALL_MULTIPLE_CMD = CollectionsKt.listOf((Object)"install-multiple");
    @NotNull
    private static final Companion.installErrorSummary.1 installErrorSummary = new ErrorSummary(){
        private final int errorCode;
        private final String errorName;
        private final Enum<?> errorType;
        private final String namespace;
        {
            this.errorCode = 2002;
            this.errorName = "Test APK installation Error";
            this.errorType = (Enum)ErrorType.TEST;
            this.namespace = "AndroidTestApkInstallerPlugin";
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorName() {
            return this.errorName;
        }

        public Enum<?> getErrorType() {
            return this.errorType;
        }

        public String getNamespace() {
            return this.namespace;
        }
    };
    @NotNull
    private static final Regex packageNameRegex = new Regex("package:\\sname='(\\S*)'.*$");

    public AndroidTestApkInstallerPlugin(@NotNull Logger logger, @NotNull Function1<? super Context, ? extends SubprocessComponent> subprocessComponentFactory) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(subprocessComponentFactory, (String)"subprocessComponentFactory");
        this.logger = logger;
        this.subprocessComponentFactory = subprocessComponentFactory;
    }

    public /* synthetic */ AndroidTestApkInstallerPlugin(Logger logger, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = LoggerExtKt.getLogger((Object)Companion);
        }
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(logger, (Function1<? super Context, ? extends SubprocessComponent>)function1);
    }

    private final Companion.MinFeatureApiLevel getFeatureMinApiLevel(AndroidApkInstallerConfigProto.InstallableApk.InstallOption installOption) {
        Companion.MinFeatureApiLevel minApiLevel = Companion.MinFeatureApiLevel.NONE;
        if (installOption.getInstallAsSplitApk()) {
            minApiLevel = Companion.MinFeatureApiLevel.SPLIT_APK;
        }
        return minApiLevel;
    }

    private final String getUserId(int deviceApiLevel, DeviceController deviceController, String deviceSerial) {
        String userId;
        if (deviceApiLevel < 24) {
            return null;
        }
        Object[] objectArray = new String[]{"shell", "am", "get-current-user"};
        CommandResult result = DeviceController.DefaultImpls.execute$default((DeviceController)deviceController, (List)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null);
        if (result.getStatusCode() != 0) {
            this.logger.warning("Failed to execute command to obtain user ID from device " + deviceSerial);
            return null;
        }
        String string = userId = (String)CollectionsKt.getOrNull((List)result.getOutput(), (int)0);
        if ((string != null ? StringsKt.toIntOrNull((String)string) : null) == null) {
            this.logger.warning("Unexpected output of command get-current-user, expected a user id found the following output: " + userId);
            return null;
        }
        return userId;
    }

    private final List<String> getInstallCmd(AndroidApkInstallerConfigProto.InstallableApk installableApk, int deviceApiLevel, boolean forceReinstall) {
        Object[] objectArray;
        List installCmd;
        List list = installCmd = deviceApiLevel >= Companion.MinFeatureApiLevel.SPLIT_APK.getApiLevel() ? CollectionsKt.toMutableList((Collection)INSTALL_MULTIPLE_CMD) : CollectionsKt.toMutableList((Collection)BASE_INSTALL_CMD);
        if (deviceApiLevel >= 34) {
            installCmd.add("--bypass-low-target-sdk-block");
        }
        installCmd.add("-t");
        if (installableApk != null && installableApk.getInstallOptions().getInstallAsTestService()) {
            if (deviceApiLevel >= 23) {
                installCmd.add("-g");
            }
            if (deviceApiLevel >= 30) {
                installCmd.add("--force-queryable");
            }
        }
        if (this.userId != null) {
            objectArray = new String[]{"--user", this.userId};
            installCmd.addAll(CollectionsKt.listOfNotNull((Object[])objectArray));
        }
        if (forceReinstall) {
            objectArray = new String[]{"-r", "-d"};
            installCmd.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        return installCmd;
    }

    static /* synthetic */ List getInstallCmd$default(AndroidTestApkInstallerPlugin androidTestApkInstallerPlugin, AndroidApkInstallerConfigProto.InstallableApk installableApk, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return androidTestApkInstallerPlugin.getInstallCmd(installableApk, n, bl);
    }

    private final String getPackageNameFromApk(String apkPath) {
        Ref.ObjectRef packageName = new Ref.ObjectRef();
        SubprocessComponent subprocessComponent = this.subprocessComponent;
        if (subprocessComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subprocessComponent");
            subprocessComponent = null;
        }
        Subprocess subprocess = subprocessComponent.subprocess();
        Object[] objectArray = new String[4];
        String string = this.aaptPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptPath");
            string = null;
        }
        objectArray[0] = string;
        objectArray[1] = "dump";
        objectArray[2] = "badging";
        objectArray[3] = apkPath;
        Handle.DefaultImpls.waitFor$default((Handle)Subprocess.DefaultImpls.executeAsync$default((Subprocess)subprocess, (List)CollectionsKt.listOf((Object[])objectArray), null, (Function1)((Function1)new Function1<String, Unit>((Ref.ObjectRef<String>)packageName){
            final /* synthetic */ Ref.ObjectRef<String> $packageName;
            {
                this.$packageName = $packageName;
                super(1);
            }

            public final void invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (AndroidTestApkInstallerPlugin.access$getPackageNameRegex$cp().matches((CharSequence)it)) {
                    Object object = Regex.find$default((Regex)AndroidTestApkInstallerPlugin.access$getPackageNameRegex$cp(), (CharSequence)it, (int)0, (int)2, null);
                    this.$packageName.element = object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
                }
            }
        }), null, (int)10, null), null, (int)1, null);
        return (String)packageName.element;
    }

    public void configure(@NotNull Context context) {
        Config config;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Config $this$parseConfig$iv = config = ContextExtKt.getConfig((Context)context);
        boolean $i$f$parseConfig = false;
        AndroidApkInstallerConfigProto.AndroidApkInstallerConfig androidApkInstallerConfig = (AndroidApkInstallerConfigProto.AndroidApkInstallerConfig)ConfigExtKt.parseConfig((Config)$this$parseConfig$iv, AndroidApkInstallerConfigProto.AndroidApkInstallerConfig.class);
        if (androidApkInstallerConfig == null) {
            AndroidApkInstallerConfigProto.AndroidApkInstallerConfig androidApkInstallerConfig2 = AndroidApkInstallerConfigProto.AndroidApkInstallerConfig.getDefaultInstance();
            androidApkInstallerConfig = androidApkInstallerConfig2;
            Intrinsics.checkNotNullExpressionValue((Object)androidApkInstallerConfig2, (String)"getDefaultInstance(...)");
        }
        this.pluginConfig = androidApkInstallerConfig;
        this.installables = ConfigExtKt.getSetup((Config)config).getInstallables();
        this.subprocessComponent = (SubprocessComponent)this.subprocessComponentFactory.invoke((Object)context);
        this.aaptPath = ConfigExtKt.getAndroidSdk((Config)config).getAaptPath();
        AndroidApkInstallerConfigProto.AndroidApkInstallerConfig androidApkInstallerConfig3 = this.pluginConfig;
        if (androidApkInstallerConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pluginConfig");
            androidApkInstallerConfig3 = null;
        }
        this.logger.info("Configuring AndroidTestApkInstallerPlugin: " + androidApkInstallerConfig3);
    }

    private final String apkInstallErrorMessage(String apkPath, String deviceSerial, List<String> additionalOutput) {
        return "Failed to install APK: " + apkPath + " on device " + deviceSerial + "." + (String)(additionalOutput.isEmpty() ? "" : "\n" + additionalOutput);
    }

    public void beforeAll(@NotNull DeviceController deviceController) throws UtpException {
        Object result;
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        DeviceProperties deviceProperties = deviceController.getDevice().getProperties();
        Intrinsics.checkNotNull((Object)deviceProperties, (String)"null cannot be cast to non-null type com.google.testing.platform.runtime.android.device.AndroidDeviceProperties");
        int deviceApiLevel = Integer.parseInt(((AndroidDeviceProperties)deviceProperties).getDeviceApiLevel());
        String deviceSerial = deviceController.getDevice().getSerial();
        this.userId = this.getUserId(deviceApiLevel, deviceController, deviceSerial);
        if (deviceApiLevel >= 33) {
            Object[] objectArray = new String[]{"shell", "settings", "put", "global", "verifier_verify_adb_installs", "0"};
            DeviceController.DefaultImpls.execute$default((DeviceController)deviceController, (List)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null);
        }
        List installablesInstallCmd = AndroidTestApkInstallerPlugin.getInstallCmd$default(this, null, deviceApiLevel, false, 4, null);
        Set<TestArtifactProto.Artifact> set = this.installables;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"installables");
            set = null;
        }
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestArtifactProto.Artifact artifact = (TestArtifactProto.Artifact)element$iv;
            boolean bl = false;
            String apkPath = artifact.getSourcePath().getPath();
            Intrinsics.checkNotNull((Object)apkPath);
            if (((CharSequence)apkPath).length() == 0) {
                this.logger.warning("Installable APK has empty path.");
                continue;
            }
            this.logger.info("Installing installable artifact: " + apkPath + " on device " + deviceSerial + ".");
            result = DeviceController.DefaultImpls.execute$default((DeviceController)deviceController, (List)CollectionsKt.plus((Collection)installablesInstallCmd, (Iterable)CollectionsKt.listOf((Object)apkPath)), null, (int)2, null);
            boolean bl2 = false;
            if (result.getStatusCode() == 0) continue;
            ErrorSummary errorSummary = installErrorSummary;
            String string = artifact.getSourcePath().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            throw new UtpException(errorSummary, this.apkInstallErrorMessage(string, deviceSerial, result.getOutput()), null, 4, null);
        }
        AndroidApkInstallerConfigProto.AndroidApkInstallerConfig androidApkInstallerConfig = this.pluginConfig;
        if (androidApkInstallerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pluginConfig");
            androidApkInstallerConfig = null;
        }
        List list = androidApkInstallerConfig.getApksToInstallList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getApksToInstallList(...)");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Duration duration;
            AndroidApkInstallerConfigProto.InstallableApk installableApk = (AndroidApkInstallerConfigProto.InstallableApk)element$iv;
            boolean bl = false;
            if (installableApk.getApkPathsList().isEmpty()) continue;
            AndroidApkInstallerConfigProto.InstallableApk.InstallOption installOption = installableApk.getInstallOptions();
            Intrinsics.checkNotNullExpressionValue((Object)installOption, (String)"getInstallOptions(...)");
            Companion.MinFeatureApiLevel featureMinApi = this.getFeatureMinApiLevel(installOption);
            if (featureMinApi.getApiLevel() > deviceApiLevel) {
                throw new UtpException((ErrorSummary)installErrorSummary, "Minimum API level for installing " + featureMinApi + " feature is " + featureMinApi.getApiLevel() + " but device " + deviceSerial + " is API level " + deviceApiLevel + ".", null, 4, null);
            }
            result = installableApk.getInstallOptions().getInstallApkTimeout();
            int it = ((Number)result).intValue();
            boolean bl3 = false;
            Object object = it > 0 ? result : null;
            if (object != null) {
                long it2 = ((Integer)object).intValue();
                boolean bl4 = false;
                duration = Duration.ofSeconds(it2);
            } else {
                duration = null;
            }
            Duration installTimeoutDuration = duration;
            List<String> installCmd = this.getInstallCmd(installableApk, deviceApiLevel, installableApk.getForceReinstallBeforeTest());
            this.logger.info("Installing " + installableApk.getApkPathsList() + " on device " + deviceSerial + ".");
            if (!installableApk.getInstallOptions().getInstallAsSplitApk() && installableApk.getApkPathsCount() > 1) {
                ProtocolStringList protocolStringList = installableApk.getApkPathsList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getApkPathsList(...)");
                Iterable $this$forEach$iv2 = (Iterable)protocolStringList;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String apkPath = (String)element$iv2;
                    boolean bl5 = false;
                    Collection collection = installCmd;
                    ProtocolStringList protocolStringList2 = installableApk.getInstallOptions().getCommandLineParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)protocolStringList2, (String)"getCommandLineParameterList(...)");
                    CommandResult result2 = deviceController.execute(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)protocolStringList2)), (Object)apkPath), installTimeoutDuration);
                    boolean bl6 = false;
                    if (result2.getStatusCode() == 0) continue;
                    ErrorSummary errorSummary = installErrorSummary;
                    Intrinsics.checkNotNull((Object)apkPath);
                    throw new UtpException(errorSummary, this.apkInstallErrorMessage(apkPath, deviceSerial, result2.getOutput()), null, 4, null);
                }
            } else {
                Collection collection = installCmd;
                ProtocolStringList protocolStringList = installableApk.getInstallOptions().getCommandLineParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getCommandLineParameterList(...)");
                Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)protocolStringList));
                ProtocolStringList protocolStringList3 = installableApk.getApkPathsList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList3, (String)"getApkPathsList(...)");
                CommandResult result3 = deviceController.execute(CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)protocolStringList3)), installTimeoutDuration);
                boolean bl7 = false;
                if (result3.getStatusCode() != 0) {
                    throw new UtpException((ErrorSummary)installErrorSummary, this.apkInstallErrorMessage(installableApk.getApkPathsList().toString(), deviceSerial, result3.getOutput()), null, 4, null);
                }
            }
            if (deviceApiLevel < 24 || installableApk.getApkPathsList().isEmpty() || installableApk.getInstallOptions().getForceCompilation() == AndroidApkInstallerConfigProto.InstallableApk.InstallOption.ForceCompilation.NO_FORCE_COMPILATION) continue;
            ProtocolStringList protocolStringList = installableApk.getApkPathsList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getApkPathsList(...)");
            Object object2 = CollectionsKt.first((List)((List)protocolStringList));
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first(...)");
            String packageName = this.getPackageNameFromApk((String)object2);
            if (packageName == null) {
                ProtocolStringList protocolStringList4 = installableApk.getApkPathsList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList4, (String)"getApkPathsList(...)");
                this.logger.warning("Failed to resolve package name for " + CollectionsKt.first((List)((List)protocolStringList4)));
                continue;
            }
            AndroidApkInstallerConfigProto.InstallableApk.InstallOption.ForceCompilation forceCompilation = installableApk.getInstallOptions().getForceCompilation();
            switch (forceCompilation == null ? -1 : WhenMappings.$EnumSwitchMapping$0[forceCompilation.ordinal()]) {
                case 1: {
                    this.logger.info("Running force AOT compilation for " + packageName);
                    Object[] objectArray = new String[]{"shell", "cmd", "package", "compile", "-m", "speed", "-f", packageName};
                    DeviceController.DefaultImpls.execute$default((DeviceController)deviceController, (List)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null);
                    break;
                }
                case 2: {
                    this.logger.info("Running profile based AOT compilation for " + packageName);
                    Object[] objectArray = new String[]{"shell", "cmd", "package", "compile", "-m", "speed-profile", "-f", packageName};
                    DeviceController.DefaultImpls.execute$default((DeviceController)deviceController, (List)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null);
                    break;
                }
                default: {
                    this.logger.warning("Unknown force compilation option is specified: " + installableApk.getInstallOptions().getForceCompilation());
                }
            }
        }
    }

    public void beforeEach(@Nullable TestCaseProto.TestCase testCase, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
    }

    public void afterEach(@NotNull TestResultProto.TestResult testResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
    }

    public void afterAll(@NotNull TestSuiteResultProto.TestSuiteResult testSuiteResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testSuiteResult, (String)"testSuiteResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        AndroidApkInstallerConfigProto.AndroidApkInstallerConfig androidApkInstallerConfig = this.pluginConfig;
        if (androidApkInstallerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pluginConfig");
            androidApkInstallerConfig = null;
        }
        List list = androidApkInstallerConfig.getApksToInstallList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getApksToInstallList(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidApkInstallerConfigProto.InstallableApk installableApk = (AndroidApkInstallerConfigProto.InstallableApk)element$iv;
            boolean bl = false;
            if (!installableApk.getUninstallAfterTest()) continue;
            ProtocolStringList protocolStringList = installableApk.getApkPathsList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getApkPathsList(...)");
            Iterable $this$forEach$iv2 = (Iterable)protocolStringList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String apkPackage;
                String apkPath = (String)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)apkPath);
                if (this.getPackageNameFromApk(apkPath) == null) continue;
                this.logger.info("Uninstalling " + apkPackage + " for device " + deviceController.getDevice().getSerial() + ".");
                CommandResult result = AndroidDeviceControllerExtKt.uninstall$default((DeviceController)deviceController, (String)apkPackage, (boolean)false, null, (int)6, null);
                boolean bl3 = false;
                if (result.getStatusCode() == 0) continue;
                this.logger.warning("Device " + deviceController.getDevice().getSerial() + " failed to uninstall test APK " + apkPackage + ".\n" + result.getOutput());
            }
        }
    }

    public boolean canRun() {
        return true;
    }

    public AndroidTestApkInstallerPlugin() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ Regex access$getPackageNameRegex$cp() {
        return packageNameRegex;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin$Companion;", "", "()V", "BASE_INSTALL_CMD", "", "", "INSTALL_MULTIPLE_CMD", "installErrorSummary", "com/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin$Companion$installErrorSummary$1", "Lcom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin$Companion$installErrorSummary$1;", "packageNameRegex", "Lkotlin/text/Regex;", "MinFeatureApiLevel", "android-test-plugin-host-apk-installer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin$Companion$MinFeatureApiLevel;", "", "apiLevel", "", "(Ljava/lang/String;II)V", "getApiLevel", "()I", "NONE", "SPLIT_APK", "android-test-plugin-host-apk-installer"})
        private static final class MinFeatureApiLevel
        extends Enum<MinFeatureApiLevel> {
            private final int apiLevel;
            public static final /* enum */ MinFeatureApiLevel NONE = new MinFeatureApiLevel(Integer.MIN_VALUE);
            public static final /* enum */ MinFeatureApiLevel SPLIT_APK = new MinFeatureApiLevel(21);
            private static final /* synthetic */ MinFeatureApiLevel[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private MinFeatureApiLevel(int apiLevel) {
                this.apiLevel = apiLevel;
            }

            public final int getApiLevel() {
                return this.apiLevel;
            }

            public static MinFeatureApiLevel[] values() {
                return (MinFeatureApiLevel[])$VALUES.clone();
            }

            public static MinFeatureApiLevel valueOf(String value) {
                return Enum.valueOf(MinFeatureApiLevel.class, value);
            }

            @NotNull
            public static EnumEntries<MinFeatureApiLevel> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = minFeatureApiLevelArray = new MinFeatureApiLevel[]{MinFeatureApiLevel.NONE, MinFeatureApiLevel.SPLIT_APK};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidApkInstallerConfigProto.InstallableApk.InstallOption.ForceCompilation.values().length];
            try {
                nArray[AndroidApkInstallerConfigProto.InstallableApk.InstallOption.ForceCompilation.FULL_COMPILATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidApkInstallerConfigProto.InstallableApk.InstallOption.ForceCompilation.PROFILE_BASED_COMPILATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

