/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.logcat;

import com.google.testing.platform.api.config.Config;
import com.google.testing.platform.api.config.ConfigExtKt;
import com.google.testing.platform.api.device.CommandHandle;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.plugin.HostPlugin;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u001b\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\n %*\u0004\u0018\u00010\t0\t2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\tH\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0015H\u0002J\b\u0010.\u001a\u00020\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/utp/plugins/host/logcat/AndroidTestLogcatPlugin;", "Lcom/google/testing/platform/api/plugin/HostPlugin;", "logger", "Ljava/util/logging/Logger;", "(Ljava/util/logging/Logger;)V", "logcatCommandHandle", "Lcom/google/testing/platform/api/device/CommandHandle;", "logcatFilePaths", "", "", "logcatOptions", "", "outputDir", "tempLogcatFile", "Ljava/io/File;", "tempLogcatWriter", "Ljava/io/BufferedWriter;", "afterAll", "Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "testSuiteResult", "deviceController", "Lcom/google/testing/platform/api/device/DeviceController;", "afterEach", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "testResult", "beforeAll", "", "beforeEach", "testCase", "Lcom/google/testing/platform/proto/api/core/TestCaseProto$TestCase;", "canRun", "", "cancel", "configure", "config", "Lcom/google/testing/platform/api/config/Config;", "generateLogcatFileName", "kotlin.jvm.PlatformType", "testPackageAndClass", "testMethod", "getDeviceCurrentTime", "parseLine", "line", "setUpLogcatCommandLine", "startLogcatAsync", "controller", "stopLogcat", "Companion", "android-test-plugin-host-logcat"})
public final class AndroidTestLogcatPlugin
implements HostPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    private String outputDir;
    private File tempLogcatFile;
    private BufferedWriter tempLogcatWriter;
    private CommandHandle logcatCommandHandle;
    @NotNull
    private List<String> logcatFilePaths;
    @NotNull
    private List<String> logcatOptions;

    public AndroidTestLogcatPlugin(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        boolean bl = false;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(mutableListOf())");
        this.logcatFilePaths = list;
        boolean bl2 = false;
        this.logcatOptions = new ArrayList();
    }

    public /* synthetic */ AndroidTestLogcatPlugin(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = LoggerExtKt.getLogger((Object)Companion);
        }
        this(logger);
    }

    public void configure(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.outputDir = ConfigExtKt.getEnvironment((Config)config).getOutputDirectory();
    }

    public void beforeAll(@NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.logger.fine("Start logcat streaming.");
        this.logcatCommandHandle = this.startLogcatAsync(deviceController);
    }

    public void beforeEach(@Nullable TestCaseProto.TestCase testCase, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public TestResultProto.TestResult afterEach(@NotNull TestResultProto.TestResult testResult, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        TestCaseProto.TestCase testCase = testResult.getTestCase();
        String packageName = testCase.getTestPackage();
        String className = testCase.getTestClass();
        String methodName = testCase.getTestMethod();
        TestResultProto.TestResult.Builder builder = testResult.toBuilder();
        boolean bl = false;
        boolean bl2 = false;
        TestResultProto.TestResult.Builder $this$afterEach_u24lambda_u2d3 = builder;
        boolean bl3 = false;
        List<String> list = this.logcatFilePaths;
        boolean bl4 = false;
        boolean bl5 = false;
        synchronized (list) {
            boolean bl6 = false;
            Iterable iterable = this.logcatFilePaths;
            boolean bl7 = false;
            for (Object t : iterable) {
                void $this$afterEach_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0;
                String it = (String)t;
                boolean bl8 = false;
                String string = packageName + '.' + className;
                Intrinsics.checkNotNullExpressionValue((Object)methodName, (String)"methodName");
                if (!Intrinsics.areEqual((Object)it, (Object)this.generateLogcatFileName(string, methodName))) continue;
                TestArtifactProto.Artifact.Builder builder2 = TestArtifactProto.Artifact.newBuilder();
                boolean bl9 = false;
                boolean bl10 = false;
                TestArtifactProto.Artifact.Builder builder3 = builder2;
                TestResultProto.TestResult.Builder builder4 = $this$afterEach_u24lambda_u2d3;
                boolean bl11 = false;
                $this$afterEach_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.getLabelBuilder().setLabel("logcat");
                $this$afterEach_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.getLabelBuilder().setNamespace("android");
                $this$afterEach_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.getSourcePathBuilder().setPath(it);
                Unit unit = Unit.INSTANCE;
                builder4.addOutputArtifact(builder2.build());
            }
            Unit unit = Unit.INSTANCE;
        }
        TestResultProto.TestResult updatedTestResult = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)updatedTestResult, (String)"updatedTestResult");
        return updatedTestResult;
    }

    @NotNull
    public TestSuiteResultProto.TestSuiteResult afterAll(@NotNull TestSuiteResultProto.TestSuiteResult testSuiteResult, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)testSuiteResult, (String)"testSuiteResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.stopLogcat();
        return testSuiteResult;
    }

    public boolean canRun() {
        return true;
    }

    public boolean cancel() {
        return false;
    }

    private final String generateLogcatFileName(String testPackageAndClass, String testMethod) {
        String string;
        String string2 = this.outputDir;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            string = null;
        } else {
            string = string2;
        }
        return new File(string, "logcat-" + testPackageAndClass + '-' + testMethod + ".txt").getAbsolutePath();
    }

    private final String getDeviceCurrentTime(DeviceController deviceController) {
        Object[] objectArray = new String[]{"date", "+%m-%d\\ %H:%M:%S"};
        CommandResult dateCommandResult = AndroidDeviceControllerExtKt.deviceShell$default((DeviceController)deviceController, (List)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null);
        if (dateCommandResult.getStatusCode() != 0 || dateCommandResult.getOutput().isEmpty()) {
            this.logger.warning("Failed to read device time.");
            return null;
        }
        return '\'' + (String)dateCommandResult.getOutput().get(0) + ".000'";
    }

    private final List<String> setUpLogcatCommandLine() {
        boolean bl = false;
        List logcatCommand = new ArrayList();
        bl = false;
        boolean bl2 = false;
        List $this$setUpLogcatCommandLine_u24lambda_u2d4 = logcatCommand;
        boolean bl3 = false;
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("shell");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("logcat");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("-v");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("threadtime");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("-b");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("main");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.addAll((Collection)this.logcatOptions);
        return logcatCommand;
    }

    private final CommandHandle startLogcatAsync(DeviceController controller) {
        String deviceTime = this.getDeviceCurrentTime(controller);
        if (deviceTime != null) {
            Object[] objectArray = new String[]{"-T", deviceTime};
            this.logcatOptions = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        Ref.BooleanRef testRunInProgress = new Ref.BooleanRef();
        return controller.executeAsync(this.setUpLogcatCommandLine(), (Function1)new Function1<String, Unit>(testRunInProgress, this){
            final /* synthetic */ Ref.BooleanRef $testRunInProgress;
            final /* synthetic */ AndroidTestLogcatPlugin this$0;
            {
                this.$testRunInProgress = $testRunInProgress;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                if (StringsKt.contains$default((CharSequence)line, (CharSequence)"TestRunner: started: ", (boolean)false, (int)2, null)) {
                    this.$testRunInProgress.element = true;
                    AndroidTestLogcatPlugin.access$parseLine(this.this$0, line);
                }
                if (this.$testRunInProgress.element) {
                    BufferedWriter bufferedWriter;
                    BufferedWriter bufferedWriter2;
                    BufferedWriter bufferedWriter3;
                    BufferedWriter bufferedWriter4 = AndroidTestLogcatPlugin.access$getTempLogcatWriter$p(this.this$0);
                    if (bufferedWriter4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                        bufferedWriter3 = null;
                    } else {
                        bufferedWriter3 = bufferedWriter4;
                    }
                    bufferedWriter3.write(line);
                    bufferedWriter4 = AndroidTestLogcatPlugin.access$getTempLogcatWriter$p(this.this$0);
                    if (bufferedWriter4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                        bufferedWriter2 = null;
                    } else {
                        bufferedWriter2 = bufferedWriter4;
                    }
                    bufferedWriter2.newLine();
                    bufferedWriter4 = AndroidTestLogcatPlugin.access$getTempLogcatWriter$p(this.this$0);
                    if (bufferedWriter4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                        bufferedWriter = null;
                    } else {
                        bufferedWriter = bufferedWriter4;
                    }
                    bufferedWriter.flush();
                }
                if (StringsKt.contains$default((CharSequence)line, (CharSequence)"TestRunner: finished:", (boolean)false, (int)2, null)) {
                    this.$testRunInProgress.element = false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopLogcat() {
        block12: {
            Object object;
            block15: {
                Object object2;
                block13: {
                    try {
                        if (this.logcatCommandHandle != null) {
                            Object object3;
                            CommandHandle commandHandle;
                            object2 = this.logcatCommandHandle;
                            if (object2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"logcatCommandHandle");
                                commandHandle = null;
                            } else {
                                commandHandle = object2;
                            }
                            commandHandle.stop();
                            object2 = this.logcatCommandHandle;
                            if (object2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"logcatCommandHandle");
                                object3 = null;
                            } else {
                                object3 = object2;
                            }
                            CommandHandle.DefaultImpls.waitFor$default((CommandHandle)object3, null, (int)1, null);
                        }
                        if (this.tempLogcatWriter == null) break block12;
                        object2 = this.tempLogcatWriter;
                        if (object2 != null) break block13;
                    }
                    catch (Throwable t) {
                        BufferedWriter bufferedWriter;
                        block16: {
                            BufferedWriter bufferedWriter2;
                            block14: {
                                try {
                                    this.logger.warning(Intrinsics.stringPlus((String)"Stopping logcat failed with the following error: ", (Object)t));
                                    if (this.tempLogcatWriter == null) break block12;
                                    bufferedWriter2 = this.tempLogcatWriter;
                                    if (bufferedWriter2 != null) break block14;
                                }
                                catch (Throwable throwable) {
                                    if (this.tempLogcatWriter != null) {
                                        BufferedWriter bufferedWriter3;
                                        BufferedWriter bufferedWriter4 = this.tempLogcatWriter;
                                        if (bufferedWriter4 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                                            bufferedWriter3 = null;
                                        } else {
                                            bufferedWriter3 = bufferedWriter4;
                                        }
                                        bufferedWriter3.close();
                                    }
                                    throw throwable;
                                }
                                Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                                bufferedWriter = null;
                                break block16;
                            }
                            bufferedWriter = bufferedWriter2;
                        }
                        bufferedWriter.close();
                    }
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                    object = null;
                    break block15;
                }
                object = object2;
            }
            ((BufferedWriter)object).close();
        }
    }

    private final void parseLine(String line) {
        File file;
        String[] stringArray = new String[]{"TestRunner: started: "};
        CharSequence charSequence = (CharSequence)StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
        stringArray = new String[]{"("};
        List testPackageClassAndMethodNames = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string = (String)testPackageClassAndMethodNames.get(0);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String testMethod = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        String testPackageAndClass = StringsKt.removeSuffix((String)((String)testPackageClassAndMethodNames.get(1)), (CharSequence)")");
        String tempFileName = this.generateLogcatFileName(testPackageAndClass, testMethod);
        this.tempLogcatFile = new File(tempFileName);
        Intrinsics.checkNotNullExpressionValue((Object)tempFileName, (String)"tempFileName");
        this.logcatFilePaths.add(tempFileName);
        Object object = this.tempLogcatFile;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatFile");
            file = null;
        } else {
            file = object;
        }
        object = file;
        boolean bl2 = false;
        object = new FileOutputStream((File)object);
        Charset charset = Charsets.UTF_8;
        boolean bl3 = false;
        Object object2 = object;
        int n = 0;
        object2 = new OutputStreamWriter((OutputStream)object2, charset);
        n = 8192;
        boolean bl4 = false;
        this.tempLogcatWriter = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
    }

    public AndroidTestLogcatPlugin() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$parseLine(AndroidTestLogcatPlugin $this, String line) {
        $this.parseLine(line);
    }

    public static final /* synthetic */ BufferedWriter access$getTempLogcatWriter$p(AndroidTestLogcatPlugin $this) {
        return $this.tempLogcatWriter;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/tools/utp/plugins/host/logcat/AndroidTestLogcatPlugin$Companion;", "", "()V", "android-test-plugin-host-logcat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

