/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Compressor;
import com.android.zipflinger.Crc32;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BytesSource
extends Source {
    private ByteBuffer buffer;

    public BytesSource(byte[] bytes, String name, int compressionLevel) throws IOException {
        super(name);
        this.crc = Crc32.crc32(bytes);
        this.uncompressedSize = bytes.length;
        if (compressionLevel == 0) {
            this.buffer = ByteBuffer.wrap(bytes);
            this.compressedSize = this.uncompressedSize;
            this.compressionFlag = 0;
        } else {
            this.buffer = Compressor.deflate(bytes, compressionLevel);
            this.compressedSize = this.buffer.limit();
            this.compressionFlag = (short)8;
        }
    }

    @Override
    void prepare() {
    }

    @Override
    long writeTo(ZipWriter writer) throws IOException {
        return writer.write(this.buffer);
    }
}

