/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Archive;
import com.android.zipflinger.BytesSource;
import com.android.zipflinger.CentralDirectory;
import com.android.zipflinger.CentralDirectoryRecord;
import com.android.zipflinger.Compressor;
import com.android.zipflinger.EndOfCentralDirectory;
import com.android.zipflinger.Entry;
import com.android.zipflinger.ExtractionInfo;
import com.android.zipflinger.FreeStore;
import com.android.zipflinger.LocalFileHeader;
import com.android.zipflinger.Location;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipInfo;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipReader;
import com.android.zipflinger.ZipSource;
import com.android.zipflinger.ZipWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZipArchive
implements Archive {
    private final FreeStore freestore;
    private boolean closed;
    private final File file;
    private final CentralDirectory cd;
    private final ZipWriter writer;
    private final ZipReader reader;

    public ZipArchive(File file) throws IOException {
        this.file = file;
        if (Files.exists(file.toPath(), new LinkOption[0])) {
            ZipMap map = ZipMap.from(file, true);
            this.cd = map.getCentralDirectory();
            this.freestore = new FreeStore(map.getEntries());
        } else {
            HashMap<String, Entry> entries = new HashMap<String, Entry>();
            this.cd = new CentralDirectory(ByteBuffer.allocate(0), entries);
            this.freestore = new FreeStore(entries);
        }
        FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
        this.writer = new ZipWriter(channel);
        this.reader = new ZipReader(channel);
        this.closed = false;
    }

    public static Map<String, Entry> listEntries(File file) throws IOException {
        return ZipMap.from(file, false).getEntries();
    }

    public List<String> listEntries() {
        return this.cd.listEntries();
    }

    public ByteBuffer getContent(String name) throws IOException {
        ExtractionInfo extractInfo = this.cd.getExtractionInfo(name);
        if (extractInfo == null) {
            return null;
        }
        Location loc = extractInfo.getLocation();
        ByteBuffer payloadByteBuffer = ByteBuffer.allocate(Math.toIntExact(loc.size()));
        this.reader.read(payloadByteBuffer, loc.first);
        if (extractInfo.isCompressed()) {
            return Compressor.inflate(payloadByteBuffer.array());
        }
        return payloadByteBuffer;
    }

    @Override
    public void add(BytesSource source) throws IOException {
        if (this.closed) {
            throw new IllegalStateException(String.format("Cannot add source to closed archive %s", this.file));
        }
        this.writeSource(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ZipSource sources) throws IOException {
        if (this.closed) {
            throw new IllegalStateException(String.format("Cannot add zip source to closed archive %s", this.file));
        }
        try {
            sources.open();
            for (Source source : sources.getSelectedEntries()) {
                this.writeSource(source);
            }
        }
        finally {
            sources.close();
        }
    }

    @Override
    public void delete(String name) {
        if (this.closed) {
            throw new IllegalStateException(String.format("Cannot delete '%s' from closed archive %s", name, this.file));
        }
        Location loc = this.cd.delete(name);
        if (loc != Location.INVALID) {
            this.freestore.free(loc);
        }
    }

    @Override
    public void close() throws IOException {
        this.closeWithInfo();
    }

    /*
     * Exception decompiling
     */
    public ZipInfo closeWithInfo() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File getFile() {
        return this.file;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private ZipInfo writeArchive(ZipWriter writer) throws IOException {
        this.checkNumEntries();
        List<Location> freeLocations = this.freestore.getFreeLocations();
        for (int i = 0; i < freeLocations.size() - 1; ++i) {
            ZipArchive.fillFreeLocation(freeLocations.get(i), writer);
        }
        Location lastFreeLocation = this.freestore.getLastFreeLocation();
        long cdStart = lastFreeLocation.first;
        writer.position(cdStart);
        this.cd.write(writer);
        Location cdLocation = new Location(cdStart, writer.position() - cdStart);
        long numEntries = this.cd.getNumEntries();
        Location eocdLocation = EndOfCentralDirectory.write(writer, cdLocation, numEntries);
        writer.truncate(writer.position());
        Location payLoadLocation = new Location(0L, cdStart);
        return new ZipInfo(payLoadLocation, cdLocation, eocdLocation);
    }

    private void checkNumEntries() {
        long numEntries = this.cd.getNumEntries();
        if (numEntries > 65535L) {
            throw new IllegalStateException("Too many entries (" + numEntries + ")");
        }
    }

    private static void fillFreeLocation(Location location, ZipWriter writer) throws IOException {
        long spaceToFill = location.size();
        if (spaceToFill < 34L) {
            return;
        }
        while (spaceToFill > 0L) {
            long entrySize = spaceToFill <= 65565L ? spaceToFill : 65535L;
            int size = Math.toIntExact(entrySize);
            ByteBuffer virtualEntry = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
            LocalFileHeader.fillVirtualEntry(virtualEntry);
            writer.write(virtualEntry, location.first + location.size() - spaceToFill);
            spaceToFill -= (long)virtualEntry.capacity();
        }
    }

    private void writeSource(Source source) throws IOException {
        int paddingForAlignment;
        Location loc;
        source.prepare();
        this.validateName(source);
        long headerSize = LocalFileHeader.sizeFor(source);
        long bytesNeeded = headerSize + source.getCompressedSize();
        if (source.isAligned()) {
            loc = this.freestore.alloc(bytesNeeded, headerSize, source.getAlignment());
            paddingForAlignment = Math.toIntExact(loc.size() - bytesNeeded);
        } else {
            loc = this.freestore.ualloc(bytesNeeded);
            paddingForAlignment = 0;
        }
        LocalFileHeader lfh = new LocalFileHeader(source.getNameBytes(), source.getCompressionFlag(), source.getCrc(), source.getCompressedSize(), source.getUncompressedSize(), paddingForAlignment);
        this.writer.position(loc.first);
        lfh.write(this.writer);
        long payloadStart = this.writer.position();
        long payloadSize = source.writeTo(this.writer);
        CentralDirectoryRecord cdRecord = new CentralDirectoryRecord(source.getNameBytes(), source.getCrc(), source.getCompressedSize(), source.getUncompressedSize(), loc, source.getCompressionFlag(), new Location(payloadStart, payloadSize));
        this.cd.add(source.getName(), cdRecord);
    }

    private void validateName(Source source) {
        byte[] nameBytes = source.getNameBytes();
        String name = source.getName();
        if ((long)nameBytes.length > 65535L) {
            throw new IllegalStateException(String.format("Name '%s' is more than %d bytes", name, 65535L));
        }
        if (this.cd.contains(name)) {
            throw new IllegalStateException(String.format("Entry name '%s' collided", name));
        }
    }
}

